Program ScrollGeo;

Uses Mode13h, Sprites, Crt;

Const GeoMapSizeX=100;
      GeoMapSizeY=100;

Var GeoMap:Array[0..GeoMapSizeX,0..GeoMapSizeY] Of Byte;
    GeoImages:Array[1..5] Of Pointer;
    A,B:Word;
    C:Char;

Procedure GenGeoMap;
Var A,B:Word;
Begin
     For A:=0 To GeoMapSizeX Do
       For B:=0 To GeoMapSizeY Do
         GeoMap[A,B]:=Random(5)+1;
End;

Procedure LoadGeoImages(Filename:String);
Var F:File;
    Index:Word;
Begin
     Assign(F,Filename);
     Reset(F,1);
     Index:=1;
     While Not Eof(F) Do
     Begin
          LoadImage(F,GeoImages[Index]);
          Inc(Index);
     End;
End;

Procedure DispGeo(X,Y,DX,DY,Where:Word);
Var A,B:Word;
    C:Byte;
Begin
     For A:=0 To DX-1 Do
       For B:=0 To DY-1 Do
       Begin
            C:=GeoMap[X+A,Y+B];
            PutImage(A*16,B*16,GeoImages[C],Where);
       End;
End;

Procedure SetColors;
Begin
     SetColor(0,0,0,0);                 { Black }
     SetColor(1,40,20,0);               { Brown }
     SetColor(2,0,50,0);                { Light Green }
     SetColor(3,0,25,0);                { Dark Green }
     SetColor(4,0,55,60);               { Light Blue }
     SetColor(5,0,0,60);                { Dark Blue }
     SetColor(6,35,35,35);              { Gray }
End;

Begin
     { Initialization }
     GenGeoMap;
     LoadGeoImages('ScrlGeo.Img');
     InitGraph;
     SetColors;
     { Move around }
     { Press A to go up, Z to go down, N to go left, M to go right }
     { and Q to quit. }
     { The program doesn't do checking, so don't go out of bounds ! }
     A:=0;
     B:=0;
     Repeat
           DispGeo(A,B,10,10,Vga);
           C:=Readkey;
           If C='a' Then B:=B-1;
           If C='z' Then B:=B+1;
           If C='n' Then A:=A-1;
           If C='m' Then A:=A+1;
     Until C='q';
     { Close down }
     Closegraph;
     For A:=1 To 5 Do KillImage(GeoImages[A]);
End.