{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-}
{$M 8192,0,655360}

{ tabstep = 4 }
{ VBE warning: only 64k window sizes are supported (ehehee, I dunno if other size exist }

CONST
	FontSignature: ARRAY[1..10] OF CHAR = 'FONTDATA11';
	TextString = 'THIS IS A TEST OF TEXT OUTPUT ROUTINE FOR SVGA... MUHAHAHAAA... 640X480 SUCKS TOO MUCH! AT LEAST '+
		'MOST MONITORS SUCK AT 640X480... @#$%^&*()1234567890_+-=\|~`';

TYPE
	TFontCharacter = RECORD
		Width: BYTE;
		Height: BYTE;
		Offsety: INTEGER;
		LeftSpace: INTEGER;
		RightSpace: INTEGER;
	END;

	PVBEInfo = ^TVBEInfo;
	TVBEInfo = RECORD
		Signature: ARRAY[1..4] OF CHAR;
		Version: WORD;
		OEMName: POINTER;
		Capabilites: LONGINT;
		SupportedModes: POINTER;
		MemorySize: WORD;
		reserved1: ARRAY[1..236] OF BYTE;
	END;

	PVBEModeInfo = ^TVBEModeInfo;
	TVBEModeInfo = RECORD
		Attributes: WORD;
		WindowAAttributes: BYTE;
		WindowBAttributes: BYTE;
		Granularity: WORD;
		WindowSize: WORD;
		WindowASegment: WORD;
		WindowBSegment: WORD;
		WindowPositioningFunction: POINTER;
		BytesPerScanline: WORD;
		ResolutionX: WORD;
		ResolutionY: WORD;
		CharacterSizeX: BYTE;
		CharacterSizeY: BYTE;
		PlanesCount: BYTE;
		BitsPerPixel: BYTE;
		BanksCount: BYTE;
		MemoryModelType: BYTE;
		BankSize: BYTE;
		Pages: BYTE;
		reserved1: ARRAY[1..1] OF BYTE;
		RedMaskSize: BYTE;
		RedFieldPosition: BYTE;
		GreenMaskSize: BYTE;
		GreenFieldPosition: BYTE;
		BlueMaskSize: BYTE;
		BlueFieldPosition: BYTE;
		ReservedMaskSize: BYTE;
		DirectColorModeInfo: BYTE;
		reserved2: ARRAY[1..216] OF BYTE;
	END;

VAR
	VBEWindowSegment: WORD;
	VBEWindowWidth: WORD;
	VBEWindowGranularity: WORD;
	VBEWindowProcedure: POINTER;
	VBEWindowProcedureGet: POINTER;
	VBEWindowProcedureInternal: POINTER;

{ warning: this example font printing routine is designed only for fonts less than 64k in size }
{ so, be warned about this limitation }

{ hehe, if you understood my technique correctly, you maybe figured out that }
{ this routine can be used in 320x200 mode also }

{ FontData - pointer to correct font (warning: no checks for validity are performed) }
{ Text - text to output }
{ BaseColour - base colour }
{ x,y - coordinates within screen }
{ wx1,wy1,wx2,wy2 - clipping bounds }
PROCEDURE FontStringPrint(FontData: POINTER; Text: STRING; BaseColour: BYTE; x,y: INTEGER; wx1,wy1,wx2,wy2: WORD);
ASSEMBLER;
VAR
	xtOffs: WORD;
	xtIncr: WORD;
	DIIncrement: WORD;
	Newx: WORD;
	Currenty: WORD;
	CurrentChar: WORD;
	Character: BYTE;
	ScreenWidth: WORD;
	ScreenAddress: WORD;
	CurrentBank: WORD;
	SwitchProcedure: POINTER;
ASM
	PUSH DS

	CLD

	MOV AX,[WORD PTR VBEWindowProcedure]
	MOV [WORD PTR SwitchProcedure],AX
	MOV AX,[WORD PTR VBEWindowProcedure+2]
	MOV [WORD PTR SwitchProcedure+2],AX

	CALL [VBEWindowProcedureGet]
	MOV [CurrentBank],AX
	MOV AX,[VBEWindowWidth]
	MOV [ScreenWidth],AX
	MOV AX,[VBEWindowSegment]
	MOV [ScreenAddress],AX
	MOV AX,[x]
	MOV [Newx],AX

	MOV [CurrentChar],0

@@CharOutput:
	LDS SI,[Text]
	MOV AL,[DS:SI]
	XOR AH,AH
	CMP AX,[CurrentChar]
	JBE @@Done

	ADD SI,[CurrentChar]
	MOV AL,[DS:SI+1]
	MOV [Character],AL

	LDS SI,[FontData]
	MOV AL,[Character]
	XOR AH,AH
	SHL AX,2
	ADD SI,AX
	MOV SI,[DS:SI]
	CMP SI,0
	JE @@DoneChar

	ADD SI,[WORD PTR FontData]

	MOV AX,[x]
	SUB AX,[DS:SI+TFontCharacter.LeftSpace]
	MOV [x],AX
	MOV BL,[DS:SI+TFontCharacter.Width]
	XOR BH,BH
	ADD AX,BX
	ADD AX,[DS:SI+TFontCharacter.RightSpace]
	MOV [Newx],AX

	MOV DX,BX
	CMP DX,0
	JE @@DoneChar

	MOV AX,[x]
	CMP AX,[wx2]
	JG @@DoneChar

	ADD AX,DX
	DEC AX
	CMP AX,[wx1]
	JL @@DoneChar

	MOV [xtIncr],0
	CMP AX,[wx2]
	JLE @@NoRightClip

	SUB AX,[wx2]
	SUB DX,AX
	ADD [xtIncr],AX

@@NoRightClip:
	MOV [xtOffs],0
	MOV AX,[x]
	CMP AX,[wx1]
	JGE @@NoLeftClip

	MOV BX,[wx1]
	SUB BX,AX
	SUB DX,BX
	ADD AX,BX
	MOV [xtOffs],BX
	ADD [xtIncr],BX

@@NoLeftClip:
	MOV [x],AX

	MOV CL,[DS:SI+TFontCharacter.Height]
	XOR CH,CH
	CMP CX,0
	JE @@DoneChar

	MOV AX,[y]
	ADD AX,[DS:SI+TFontCharacter.Offsety]
	MOV [Currenty],AX
	CMP AX,[wy2]
	JG @@DoneChar

	ADD AX,CX
	DEC AX
	CMP AX,[wy1]
	JL @@DoneChar

	CMP AX,[wy2]
	JLE @@NoBottomClip

	SUB AX,[wy2]
	SUB CX,AX

@@NoBottomClip:
	XOR BX,BX
	MOV AX,[Currenty]
	CMP AX,[wy1]
	JGE @@NoTopClip

	MOV BX,[wy1]
	SUB BX,AX
	SUB CX,BX
	ADD AX,BX

@@NoTopClip:
	PUSH DX

	MOV DX,[ScreenWidth]
	MUL DX
	ADD AX,[x]
	ADC DX,0
	MOV DI,AX
	CMP DX,[CurrentBank]
	JE @@NoBankSwitch1

	MOV [CurrentBank],DX
	PUSH DX
	CALL [SwitchProcedure]

@@NoBankSwitch1:
	MOV AX,[ScreenAddress]
	MOV ES,AX

	MOV AL,[DS:SI+TFontCharacter.Width]
	XOR AH,AH
	MUL BX
	ADD SI,AX
	ADD SI,[xtOffs]
	ADD SI,TYPE TFontCharacter
	MOV AH,[BaseColour]
	DEC AH

	POP DX

	MOV BX,[ScreenWidth]
	SUB BX,DX
	MOV [DIIncrement],BX

@@FillLoopy:
	MOV BX,DI
	ADD BX,DX
	JNC @@StandardFillLoop

	PUSH DX
	PUSH BX
	SUB DX,BX

@@CuteFillLoopx1:
	LODSB
	INC DI
	CMP AL,0
	JE @@CuteNoFill1

	ADD AL,AH
	MOV [ES:DI-1],AL

@@CuteNoFill1:
	DEC DX
	JNZ @@CuteFillLoopx1

	POP BX

	INC [CurrentBank]
	PUSH [CurrentBank]
	CALL [SwitchProcedure]

	CMP BX,0
	JE @@NoCute2

@@CuteFillLoopx2:
	LODSB
	INC DI
	CMP AL,0
	JE @@CuteNoFill2

	ADD AL,AH
	MOV [ES:DI-1],AL

@@CuteNoFill2:
	DEC BX
	JNZ @@CuteFillLoopx2

@@NoCute2:
	POP DX
	JMP @@FillxDone

@@StandardFillLoop:
	MOV BX,DX

@@FillLoopx:
	LODSB
	INC DI
	CMP AL,0
	JE @@NoFill

	ADD AL,AH
	MOV [ES:DI-1],AL

@@NoFill:
	DEC BX
	JNZ @@FillLoopx

@@FillxDone:
	ADD SI,[xtIncr]
	ADD DI,[DIIncrement]
	JC @@SwitchBank

	LOOP @@FillLoopy

	JMP @@DoneChar

@@SwitchBank:
	INC [CurrentBank]
	PUSH [CurrentBank]
	CALL [SwitchProcedure]
	LOOP @@FillLoopy

@@DoneChar:
	MOV AX,[Newx]
	MOV [x],AX
	INC [CurrentChar]
	JMP @@CharOutput

@@Done:
	POP DS
END;

PROCEDURE VBEWindowSet(NewBank: WORD); FAR;
ASSEMBLER;
ASM
	PUSH DS
	PUSH BX
	PUSH DX
	PUSH AX
	MOV AX,SEG @Data
	MOV DS,AX
	MOV AX,[NewBank]
	MOV BX,[VBEWindowGranularity]
	MUL BX
	MOV DX,AX
	XOR BX,BX
	CALL [VBEWindowProcedureInternal]
	POP AX
	POP DX
	POP BX
	POP DS
END;

FUNCTION VBEWindowGet: WORD; FAR;
ASSEMBLER;
ASM
	PUSH DS
	PUSH BX
	PUSH DX
	MOV AX,SEG @Data
	MOV DS,AX
	MOV BX,0100H
	CALL [VBEWindowProcedureInternal]
	MOV AX,DX
	XOR DX,DX
	MOV BX,[VBEWindowGranularity]
	DIV BX
	POP DX
	POP BX
	POP DS
END;

PROCEDURE VBEVideoModeSet(Mode: WORD);
VAR
	ModeInfo: TVBEModeInfo;
	Result: WORD;
BEGIN
	ASM
		MOV BX,[Mode]
		MOV AX,4F02H
		INT 10H
		MOV [Result],AX
	END;

	IF (LO(Result)<>$4F) OR (HI(Result)<>0) THEN
		BEGIN
			WRITELN('modeset error!');
			HALT;
		END;

	ASM
		MOV BX,1
		MOV AX,SS
		MOV ES,AX
		LEA DI,ModeInfo
		MOV AX,4F01H
		MOV CX,[Mode]
		INT 10H
		MOV [Result],AX
	END;

	IF (LO(Result)<>$4F) OR (HI(Result)<>0) THEN
		BEGIN
			WRITELN('modeinfoget error!');
			HALT;
		END;

	VBEWindowSegment:=ModeInfo.WindowASegment;
	VBEWindowWidth:=ModeInfo.BytesPerScanLine;
	VBEWindowGranularity:=64 DIV ModeInfo.Granularity;
	VBEWindowProcedureInternal:=ModeInfo.WindowPositioningFunction;
	VBEWindowProcedure:=ADDR(VBEWindowSet);
	VBEWindowProcedureGet:=ADDR(VBEWindowGet);
END;

FUNCTION VBEInstalled: BOOLEAN;
ASSEMBLER;
VAR
	VBEInfo: TVBEInfo;
ASM
	MOV AX,SS
	MOV ES,AX
	LEA DI,VBEInfo
	MOV AX,4F00H
	INT 10H

	XOR BH,BH
	CMP AL,4FH
	JNE @@Done

	CMP AH,0
	JNE @@Done

	INC BL

@@Done:
	MOV AL,BL
END;

PROCEDURE PaletteElementSet(Colour: BYTE; RedValue, GreenValue, BlueValue: BYTE);
ASSEMBLER;
ASM
	MOV DX,3C8H
	MOV AL,Colour
	OUT DX,AL

	CLI
	MOV DX,3C9H
	MOV AL,RedValue
	OUT DX,AL
	MOV AL,GreenValue
	OUT DX,AL
	MOV AL,BlueValue
	OUT DX,AL
	STI
END;

PROCEDURE VerticalRetraceWait;
ASSEMBLER;
ASM
	MOV DX,3DAH

@@WaitForVRetrace:
	IN AL,DX
	TEST AL,8
	JZ @@WaitForVRetrace
END;

PROCEDURE DataFillByte(Buffer: POINTER; Count: WORD; Value: BYTE; BufferOffset: WORD);
ASSEMBLER;
ASM
	CLD

	LES DI,[Buffer]
	ADD DI,[BufferOffset]

	MOV AL,[Value]
	MOV AH,AL

	MOV CX,[Count]
	SHR CX,1
	JNC @@FillWords

	STOSB

@@FillWords:
	REP STOSW
END;

PROCEDURE DataMove(Source, Destination: POINTER; Count: WORD; SourceOffset, DestinationOffset: WORD);
ASSEMBLER;
ASM
	CLD

	MOV DX,DS

	LDS SI,[Source]
	ADD SI,[SourceOffset]
	LES DI,[Destination]
	ADD DI,[DestinationOffset]

	MOV CX,[Count]
	SHR CX,1
	JNC @@MoveWords

	MOVSB

@@MoveWords:
	REP MOVSW

	MOV DS,DX
END;

FUNCTION Keypressed: BOOLEAN;
ASSEMBLER;
ASM
	XOR BX,BX
	MOV AH,01H
	INT 16H
	JZ @Done

	MOV BX,-1

@Done:
	MOV AX,BX
END;

FUNCTION Readkey: WORD;
ASSEMBLER;
ASM
	XOR AH,AH
	INT 16H
END;

VAR
	InFile: FILE; { filehandle }
	FontBuffer: POINTER; { buffer for font }
	CheckSignature: ARRAY[1..SIZEOF(FontSignature)] OF CHAR; { signature hold }
	ScrollDirection: INTEGER;
	Currentx,i: INTEGER;
	CurrentTime: LONGINT;

BEGIN
	IF NOT VBEInstalled THEN
		BEGIN
			WRITELN('No VESA BIOS Extensions found!');
			HALT;
		END;

	FileMode:=0; {open file in read-only mode}
	ASSIGN(InFile,'EXAMPLE.FNT');
	RESET(InFile,1);

	IF IORESULT<>0 THEN
		BEGIN
			WRITELN('Cannot open EXAMPLE.FNT file!');
			HALT;
		END;

	IF FILESIZE(InFile)>$FFFF THEN
		BEGIN
			WRITELN('Cannot handle font bigger than 64k!');
			HALT;
		END;

	BLOCKREAD(InFile,CheckSignature,SIZEOF(FontSignature)); {load signature}

	IF IORESULT<>0 THEN
		HALT;

	IF CheckSignature<>FontSignature THEN
		BEGIN
			WRITELN('Invalid fontfile!');
			HALT;
		END;

	GETMEM(FontBuffer,FILESIZE(InFile)-10); {allocate buffer for font}
	BLOCKREAD(InFile,FontBuffer^,FILESIZE(InFile)-10); {load font}
	CLOSE(InFile); {close file}

	VBEVideoModeSet($101);

	{setup palette}
	PaletteElementSet(10,10,10,10);
	PaletteElementSet(11,16,16,16);
	PaletteElementSet(12,30,30,30);
	PaletteElementSet(13,63,63,63);

	PaletteElementSet(14,10,0,0);
	PaletteElementSet(15,16,0,0);
	PaletteElementSet(16,30,0,0);
	PaletteElementSet(17,63,0,0);

	Currentx:=330;
	ScrollDirection:=-1;

	FontStringPrint(FontBuffer,'PRESS ANY KEY TO EXIT',14,180,450,0,0,639,479);

	REPEAT
		FontStringPrint(FontBuffer,TextString,10,Currentx,TRUNC(235+SIN(Currentx*3.1416/180)*110),0,0,639,479);
		VerticalRetraceWait; {wait for vertical retrace}
		Currentx:=Currentx+ScrollDirection;

		IF (Currentx>630) OR (Currentx<-1290) THEN
			ScrollDirection:=-ScrollDirection;
	UNTIL Keypressed; {loop until key was pressed}

	Readkey; {flush keyboard buffer}
	ASM MOV AX,3H; INT 10H; END; {set text mode}
END.