/*
    NSWATER.CPP.
   C 䥪 .
   H室 䠩:
                     VGA.DRV - pp VGA p
                     FIRE.COL - p 
   Copyright (C) 1995 by D.J. Wolf/Nimbus Studio Labs, Moscow, Russia.
   All rights reserved.
   tel.(095) 941-5065 (ask Andrew).
*/

#include <mtools.hpp>        // 䠩  襩 ⥪ Multimedia Toolkits v1.0.
#include <graphics.hpp>      //     cc⢥(c 
                             //y c c ;)
#include <mtfile.hpp>
#include <psts4.hpp>
#include <gif.hpp>

#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <sys/stat.h>
#include <mem.h>
#include <dos.h>
#include <alloc.h>

#include "nsdemo.hpp"

//p p  p⨪  p⠫.
#define X_SIZE 320
#define Y_SIZE 200

//p.
#define WATCOL01 "watcol.col"

//p    c⠭樨  業p .
#define DIST_BLOCK_SIZE 64000

// 䠩 .
#define WATDAT01 "watdat01.dat"

//p楤yp p樨 c室   䥪 .
// c뢠c  䠩 c  WATDAT01.
//pp:
//          xC - p X  業p,
//          yC - p Y  業p,
//          wWidth - ppc p  p⠫,
//          wHeight - ppc p  p⨪,
//p p:
//             TRUE -  訡,
//             FALSE - 訡.
int GenWaterData(int xC,int yC,int wWidth,int wHeight)
  {
   //뤥塞    .
   int huge *DistData;
   if ((DistData=(int huge*)farmalloc((long)DIST_BLOCK_SIZE*sizeof(int)))==NULL)
	{
	 CloseGraph();
	 printf("Not enough free memory.\n\n");
	 return FALSE;
	}

   //c塞 c⠭樨.
   for(int y=0;y<wHeight;y++)
      {
       for(int x=0;x<wWidth;x++)
	  {
	   float dist;
	   //c⠭ cc  py  p, p室饣
	   // 業p    窥.
	   dist=sqrt((long)(xC-x)*(xC-x)+(long)(yC-y)*(yC-y))*20;
	   DistData[(long)y*wWidth+x]=(int)floor(dist);
	  }
      }

    //C 䠩..
    MTFile *file=new MTFile(WATDAT01);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't create file %s !",WATDAT01);
	delete file;
	return FALSE;
       }

    //c뢠 䠩.
    MemoryBlock TmpBlk;
    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)DistData;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=(long)DIST_BLOCK_SIZE*sizeof(int);

    if (!file->Write(&TmpBlk,(unsigned long)0l,(unsigned long)TmpBlk.dwSize/2))
       {
	CloseGraph();
	printf("\nCan't write file %s !",WATDAT01);
	delete file;
	farfree(DistData);
	return FALSE;
       }

    if (!file->Write(&TmpBlk,(unsigned long)TmpBlk.dwSize/2,(unsigned long)TmpBlk.dwSize/2+1))
       {
	CloseGraph();
	printf("\nCan't write file %s !",WATDAT01);
	delete file;
	farfree(DistData);
	return FALSE;
       }
    delete file;
    farfree(DistData);

    return TRUE;

  }

//p楤yp c 䥪 .
// pyc  ⮬ c  nsfirst.vol.
//p p:
//             TRUE -  訡,
//             FALSE - 訡.
int WaterEffect(int wWidth,int wHeight)
  {
   char byColorMap[768];

   //⥭ p.
   MTFile *file=new MTFile(WATCOL01,MT_READ_ONLY);
   if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't open file %s !",WATCOL01);
	delete file;
	return FALSE;
       }

   MemoryBlock TmpBlk;
   TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)&byColorMap;
   TmpBlk.wHandle=0;
   TmpBlk.dwSize=768l;

   if (!file->Read(&TmpBlk,(unsigned long)0l,(unsigned long)768l))
       {
	CloseGraph();
	printf("\nCan't read file %s !",WATCOL01);
	delete file;
	return FALSE;
       }
   delete file;

   //뤥塞    .
   int huge *DistData;
   if ((DistData=(int huge*)farmalloc((long)DIST_BLOCK_SIZE*sizeof(int)))==NULL)
	{
	 CloseGraph();
	 printf("Not enough free memory.\n\n");
	 return FALSE;
	}

    //p뢠 䠩.
    file=new MTFile(WATDAT01,MT_READ_ONLY);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't open file %s !",WATDAT01);
	delete file;
	farfree(DistData);
	return FALSE;
       }

    //⠥ 䠩.
    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)DistData;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=(long)DIST_BLOCK_SIZE*sizeof(int);

    if (!file->Read(&TmpBlk,(unsigned long)0l,(unsigned long)DIST_BLOCK_SIZE*sizeof(int)))
       {
	CloseGraph();
	printf("\nCan't read file %s !",WATDAT01);
	delete file;
	farfree(DistData);
	return FALSE;
       }
    delete file;

   //樠 pc p.
   InitGraph("vga.drv",0);
   if (GraphResult()!=GRAPH_NO_ERROR)
       {
	CloseGraph();
	farfree(DistData);
	printf("\nCan't setup video mode or can't find driver 'vga.drv'!");
	return FALSE;
       }

   SetColorMap(byColorMap);

   //c塞 ⠡y cyc.
   int SinTable[360];
   for(int i=0;i<360;i++)
     SinTable[i]=abs((int)((float)sin(i*3.1415/180)*256));

   int Phase;
   unsigned long dwVal=0l;

   Phase=400;

   do
     {
      int huge *lpDistStr;         //⥫  cpy c⠭権.
      unsigned wScrOffset;
      wScrOffset=0l;

      for(int y=0;y<wHeight;y++)
	 {
	  lpDistStr=DistData+(long)y*wWidth;
	  wScrOffset=(unsigned)y*320;

	  //뢮 p.
	  _DX=FP_SEG(SinTable);
	  _SI=FP_OFF(SinTable);
	  _DI=wScrOffset;
	  _CX=wWidth;
	  _AX=FP_SEG(lpDistStr);
	  _BX=FP_OFF(lpDistStr);

	  asm {
	       push bp
	       push es
	       push ds

	       mov bp,Phase            //bp - 䠧.

	       db 08eh
	       db 0e8h                 //mov gs,ax; gs:bx - y⥫  cc c⠭権.

	       mov ds,dx               //ds:si - ⠡ cyc.

	       mov ax,0a000h
	       mov es,ax               //es:di-y⥫  .

	       cld
	      };
	  WaterL1:
	  asm {
	       db 065h
	       db 08bh
	       db 007h                 //mov ax,gs:[bx]; ax-c⠭.

	       add bx,2

	       add ax,bp               //ax=c⠭+䠧.

	       push bx
	       xor dx,dx
	       mov bx,360
	       idiv bx
	       mov bx,dx               //bx-c⮪   ax  360.
	       shl bx,1

	       mov ax,ds:[si+bx]       //al-祭 cyc.

	       stosb

	       pop bx

	       dec cx
	       jnz WaterL1             //  c c  cp.

	       pop ds
	       pop es
	       pop bp
	      };
	 }

      Phase-=10;
      dwVal++;
      if (dwP5!=1) DPause(1,18);
     }
   while(!kbhit() && dwVal<200l);                    //   py y.

   //c py.
   SetActiveScreen(DISPLAY);

   farfree(DistData);

/*   for(i=0; i<63; i++)
      {
       FadeColorMapOnce(byColorMap,OFF,0,256);
//       DPause(5,18);
      }*/
  }
