// Plasma.cpp / CuteElf
// Copyright (c) 1997 Samuel Marshall

#include "DirectXConversion.h"

#include "stdlib.h"
#include "math.h"

int iRed[4],iGreen[4],iBlue[4];

BYTE bPalette[256][3];

void InitialisePalette()
{
	// Pick random colour
	iRed[0]=rand()*256/RAND_MAX;
	iGreen[0]=rand()*256/RAND_MAX;
	iBlue[0]=rand()*256/RAND_MAX;

	iRed[1]=(iRed[0]+128)&0xff;
	iGreen[1]=(iGreen[0]+128)&0xff;
	iBlue[1]=(iBlue[0]+128)&0xff;

	for(int i=0;i<256;i++)
	{
		int p=(i<128)? i : 255-i; 
		
		bPalette[i][0]=(iRed[1]*p+iRed[0]*(127-p))/127;
		bPalette[i][1]=(iGreen[1]*p+iGreen[0]*(127-p))/127;
		bPalette[i][2]=(iBlue[1]*p+iBlue[0]*(127-p))/127;
	}
	
	SetPalette(&bPalette[0][0]);
}

void FadePalette(int iAmount)
{
	// Amount goes from 0 (just past old palette)
	// to 31 (new palette)
	iAmount++;

	for(int i=0;i<256;i++)
	{
		int p=(i<128)? i : 255-i; 
		int c;
		
		c=(iRed[1]*p+iRed[0]*(127-p))
			*iAmount/127;
		c+=(iRed[3]*p+iRed[2]*(127-p))
			*(32-iAmount)/127;
		bPalette[i][0]=c/32;

		c=(iGreen[1]*p+iGreen[0]*(127-p))
			*iAmount/127;
		c+=(iGreen[3]*p+iGreen[2]*(127-p))
			*(32-iAmount)/127;
		bPalette[i][1]=c/32;

		c=(iBlue[1]*p+iBlue[0]*(127-p))
			*iAmount/127;
		c+=(iBlue[3]*p+iBlue[2]*(127-p))
			*(32-iAmount)/127;
		bPalette[i][2]=c/32;
	}

	SetPalette(&bPalette[0][0]);
}

char PickSpeed()
{
	char c;
	
	do
	{
		c=rand()*6/RAND_MAX;
		c+=rand()*7/RAND_MAX;
	}
	while(c==5);

	return c-5;
}

DWORD PASCAL PlasmaProc(void* param)
{
	BYTE* bOutput;
	DWORD dwLineOffset;
	int iFrames=0;

	char cSine[256];
	for(int i=0;i<256;i++)
		cSine[i]=(char)
			(127*sin(double(i)*3.141592654/128));

	BYTE bYFrame1=PickSpeed(),bYFrame2=PickSpeed(),
		bXFrame1=PickSpeed(),bXFrame2=PickSpeed(),
	    bXPos1=0,bXSpeed1=PickSpeed(),
		bXPos2=35,bXSpeed2=PickSpeed(),
		bYPos1=0,bYSpeed1=PickSpeed(),
		bYPos2=94,bYSpeed2=PickSpeed(),
		bXSpeedY1=PickSpeed(),bXSpeedY2=PickSpeed();

	InitialisePalette();

	while(!sg_fThreadQuit)
	{
		BYTE bYStore1=bYPos1,bYStore2=bYPos2;
		BYTE b2XStore1=bXPos1,b2XStore2=bXPos2;
		DWORD dwPos=0;
		HrStartFrame(bOutput,dwLineOffset);
		for(int y=0;y<200;y++)
		{
			BYTE bXStore1=bXPos1,bXStore2=bXPos2;
			BYTE bPartialSum=cSine[bYPos1]+
				cSine[bYPos2];

			DWORD dwOutput=(DWORD)(&bOutput[0]);

			_asm
			{
				push esi
				push edi

				mov ebx,0
				mov al,bXPos1
				mov ah,bXPos2

				mov cl,bXSpeed1
				mov ch,bXSpeed2

				mov edi,dwOutput
				add edi,dwPos
	
				mov esi,160

			loopstart:
				mov dl,bPartialSum
				mov dh,dl

				mov bl,al
				add dl,cSine[ebx]
				mov bl,ah
				add dl,cSine[ebx]

				add al,cl
				add ah,ch

				mov bl,al
				add dh,cSine[ebx]
				mov bl,ah
				add dh,cSine[ebx]

				add al,cl
				add ah,ch

				mov [edi],dx
				add edi,2

				dec esi
				jnz loopstart

				pop edi
				pop esi
			}

			dwPos+=320+dwLineOffset;

			bYPos1+=bYSpeed1;bYPos2+=bYSpeed2;

			bXPos1=bXStore1; bXPos2=bXStore2;

			bXPos1+=bXSpeedY1; bXPos2+=bXSpeedY2;
		}

		bYPos1=bYStore1; bYPos2=bYStore2;
		bXPos1=b2XStore1; bXPos2=b2XStore2;

		bYPos1+=bYFrame1; bYPos2+=bYFrame2;
		bXPos1+=bXFrame1; bXPos2+=bXFrame2;

		if(iFrames==200)
		{
			for(int i=0;i<2;i++)
			{
				iRed[i+2]=iRed[i];
				iGreen[i+2]=iGreen[i];
				iBlue[i+2]=iBlue[i];
			}

			// Pick random new colour
			iRed[0]=rand()*256/RAND_MAX;
			iGreen[0]=rand()*256/RAND_MAX;
			iBlue[0]=rand()*256/RAND_MAX;

			// and the furthest from it
			iRed[1]=(iRed[0]+128)&0xff;
			iGreen[1]=(iGreen[0]+128)&0xff;
			iBlue[1]=(iBlue[0]+128)&0xff;
		}
		if(iFrames==232) iFrames=0;
		if(iFrames>=200)
			FadePalette(iFrames-200);

		HrFinishFrame();

		iFrames++;
	}

	sg_fThreadQuit=0;
	return 0;
}

