#ifndef DXERRORS_H
#define DXERRORS_H

#define DDERR_NOTINITIALIZED 123456789

HRESULT hrDirectDrawError[]=
{
	DDERR_NOTINITIALIZED ,		// 0
	DDERR_NOTPAGELOCKED ,
	DDERR_CANTPAGEUNLOCK ,
	DDERR_CANTPAGELOCK ,
	DDERR_DCALREADYCREATED ,
	DDERR_INVALIDSURFACETYPE ,
	DDERR_NOMIPMAPHW ,
	DDERR_UNSUPPORTEDMODE ,
	DDERR_NOTPALETTIZED ,
	DDERR_IMPLICITLYCREATED ,
	DDERR_WRONGMODE ,			// 10
	DDERR_NODC ,
	DDERR_CANTCREATEDC ,
	DDERR_NOTLOCKED ,
	DDERR_CANTDUPLICATE ,
	DDERR_NOTFLIPPABLE ,
	DDERR_EXCLUSIVEMODEALREADYSET ,
	DDERR_NOTAOVERLAYSURFACE ,
	DDERR_INVALIDPOSITION ,
	DDERR_NOOVERLAYDEST ,
	DDERR_OVERLAYNOTVISIBLE ,	// 20
	DDERR_NODDROPSHW ,
	DDERR_NOBLTHW ,
	DDERR_BLTFASTCANTCLIP ,
	DDERR_NOPALETTEHW ,
	DDERR_NOPALETTEATTACHED ,
	DDERR_HWNDALREADYSET ,
	DDERR_HWNDSUBCLASSED ,
	DDERR_NOHWND ,
	DDERR_NOCLIPPERATTACHED ,
	DDERR_CLIPPERISUSINGHWND ,	// 30
	DDERR_REGIONTOOSMALL ,
	DDERR_NOEMULATION ,
	DDERR_PRIMARYSURFACEALREADYEXISTS ,
	DDERR_NODIRECTDRAWHW ,
	DDERR_DIRECTDRAWALREADYCREATED ,
	DDERR_INVALIDDIRECTDRAWGUID ,
	DDERR_XALIGN ,
	DDERR_WASSTILLDRAWING ,
	DDERR_VERTICALBLANKINPROGRESS ,
	DDERR_UNSUPPORTEDMASK ,		// 40
	DDERR_UNSUPPORTEDFORMAT ,
	DDERR_UNSUPPORTED ,
	DDERR_TOOBIGWIDTH ,
	DDERR_TOOBIGSIZE ,
	DDERR_TOOBIGHEIGHT ,
	DDERR_SURFACENOTATTACHED ,
	DDERR_SURFACELOST ,
	DDERR_SURFACEISOBSCURED ,
	DDERR_CANTLOCKSURFACE ,
	DDERR_SURFACEBUSY ,			// 50
	DDERR_SURFACEALREADYDEPENDENT ,
	DDERR_SURFACEALREADYATTACHED ,
	DDERR_COLORKEYNOTSET ,
	DDERR_PALETTEBUSY ,
	DDERR_OVERLAYCOLORKEYONLYONEACTIVE ,
	DDERR_OVERLAYCANTCLIP ,
	DDERR_OUTOFVIDEOMEMORY ,
	DDERR_OUTOFMEMORY ,
	DDERR_OUTOFCAPS ,
	DDERR_NOZOVERLAYHW ,		// 60
	DDERR_NOZBUFFERHW ,
	DDERR_NOVSYNCHW ,
	DDERR_NOTEXTUREHW ,
	DDERR_NOT8BITCOLOR ,
	DDERR_NOT4BITCOLORINDEX ,
	DDERR_NOT4BITCOLOR ,
	DDERR_NOSTRETCHHW ,
	DDERR_NOROTATIONHW ,
	DDERR_NORASTEROPHW ,
	DDERR_NOOVERLAYHW ,			// 70
	DDERR_NOTFOUND ,
	DDERR_NOMIRRORHW ,
	DDERR_NOGDI ,
	DDERR_NOFLIPHW ,
	DDERR_NOEXCLUSIVEMODE ,
	DDERR_NODIRECTDRAWSUPPORT ,
	DDERR_NOCOLORKEYHW ,
	DDERR_NOCOLORKEY ,
	DDERR_NOCOOPERATIVELEVELSET ,
	DDERR_NOCOLORCONVHW ,		// 80
	DDERR_NOCLIPLIST ,
	DDERR_NOALPHAHW ,
	DDERR_NO3D ,
	DDERR_LOCKEDSURFACES ,
	DDERR_INVALIDRECT ,
	DDERR_INVALIDPIXELFORMAT ,
	DDERR_INVALIDPARAMS ,
	DDERR_INVALIDOBJECT ,
	DDERR_INVALIDMODE ,
	DDERR_INVALIDCLIPLIST ,		// 90
	DDERR_INVALIDCAPS ,
	DDERR_INCOMPATIBLEPRIMARY ,
	DDERR_HEIGHTALIGN ,
	DDERR_GENERIC ,
	DDERR_EXCEPTION ,
	DDERR_CURRENTLYNOTAVAIL ,
	DDERR_CANNOTDETACHSURFACE ,
	DDERR_CANNOTATTACHSURFACE ,
	DDERR_ALREADYINITIALIZED,
	DD_OK
};

char strDirectDrawError[][256]=
{
	"DDERR_ALREADYINITIALIZED - This object is already initialized",
	"DDERR_CANNOTATTACHSURFACE  - This surface can not be attached to the requested surface.",
	"DDERR_CANNOTDETACHSURFACE  - This surface can not be detached from the requested surface.",
	"DDERR_CURRENTLYNOTAVAIL  - Support is currently not available.",
	"DDERR_EXCEPTION  - An exception was encountered while performing the requested operation",
	"DDERR_GENERIC  - Generic failure.",
	"DDERR_HEIGHTALIGN  - Height of rectangle provided is not a multiple of reqd alignment",
	"DDERR_INCOMPATIBLEPRIMARY  - Unable to match primary surface creation request with existing primary surface",
	"DDERR_INVALIDCAPS  - One or more of the caps bits passed to the callback are incorrect.",
	"DDERR_INVALIDCLIPLIST  - DirectDraw does not support provided Cliplist.",
	"DDERR_INVALIDMODE  - DirectDraw does not support the requested mode",
	"DDERR_INVALIDOBJECT  - DirectDraw received a pointer that was an invalid DIRECTDRAW object.",
	"DDERR_INVALIDPARAMS  - One or more of the parameters passed to the callback function are incorrect.",
	"DDERR_INVALIDPIXELFORMAT  - pixel format was invalid as specified",
	"DDERR_INVALIDRECT  - Rectangle provided was invalid.",
	"DDERR_LOCKEDSURFACES  - Operation could not be carried out because one or more surfaces are locked",
	"DDERR_NO3D  - There is no 3D present.",
	"DDERR_NOALPHAHW  - Operation could not be carried out because there is no alpha accleration hardware present or available.",
	"DDERR_NOCLIPLIST  - no clip list available",
	"DDERR_NOCOLORCONVHW  - Operation could not be carried out because there is no color conversion hardware present or available.",
	"DDERR_NOCOOPERATIVELEVELSET  - Create function called without DirectDraw object method SetCooperativeLevel being called.",
	"DDERR_NOCOLORKEY  - Surface doesn't currently have a color key",
	"DDERR_NOCOLORKEYHW  - Operation could not be carried out because there is no hardware support of the dest color key.",
	"DDERR_NODIRECTDRAWSUPPORT  - No DirectDraw support possible with current display driver",
	"DDERR_NOEXCLUSIVEMODE  - Operation requires the application to have exclusive mode but the application does not have exclusive mode.",
	"DDERR_NOFLIPHW  - Flipping visible surfaces is not supported.",
	"DDERR_NOGDI  - There is no GDI present.",
	"DDERR_NOMIRRORHW  - Operation could not be carried out because there is no hardware present or available.",
	"DDERR_NOTFOUND  - Requested item was not found",
	"DDERR_NOOVERLAYHW  - Operation could not be carried out because there is no overlay hardware present or available.",
	"DDERR_NORASTEROPHW  - Operation could not be carried out because there is no appropriate raster op hardware present or available.",
	"DDERR_NOROTATIONHW  - Operation could not be carried out because there is no rotation hardware present or available.",
	"DDERR_NOSTRETCHHW  - Operation could not be carried out because there is no hardware support for stretching",
	"DDERR_NOT4BITCOLOR  - DirectDrawSurface is not in 4 bit color palette and the requested operation requires 4 bit color palette.",
	"DDERR_NOT4BITCOLORINDEX  - DirectDrawSurface is not in 4 bit color index palette and the requested operation requires 4 bit color index palette.",
	"DDERR_NOT8BITCOLOR  - DirectDraw Surface is not in 8 bit color mode and the requested operation requires 8 bit color.",
	"DDERR_NOTEXTUREHW  - Operation could not be carried out because there is no texture mapping hardware present or available.",
	"DDERR_NOVSYNCHW  - Operation could not be carried out because there is no hardware support for vertical blank synchronized operations.",
	"DDERR_NOZBUFFERHW  - Operation could not be carried out because there is no hardware support for zbuffer blting.",
	"DDERR_NOZOVERLAYHW  - Overlay surfaces could not be z layered based on their BltOrder because the hardware does not support z layering of overlays.",
	"DDERR_OUTOFCAPS  - The hardware needed for the requested operation has already been allocated.",
	"DDERR_OUTOFMEMORY  - DirectDraw does not have enough memory to perform the operation.",
	"DDERR_OUTOFVIDEOMEMORY  - DirectDraw does not have enough memory to perform the operation.",
	"DDERR_OVERLAYCANTCLIP  - hardware does not support clipped overlays",
	"DDERR_OVERLAYCOLORKEYONLYONEACTIVE  - Can only have ony color key active at one time for overlays",
	"DDERR_PALETTEBUSY  - Access to this palette is being refused because the palette is already locked by another thread.",
	"DDERR_COLORKEYNOTSET  - No src color key specified for this operation.",
	"DDERR_SURFACEALREADYATTACHED  - This surface is already attached to the surface it is being attached to.",
	"DDERR_SURFACEALREADYDEPENDENT  - This surface is already a dependency of the surface it is being made a dependency of.",
	"DDERR_SURFACEBUSY  - Access to this surface is being refused because the surface is already locked by another thread.",
	"DDERR_CANTLOCKSURFACE  - Access to this surface is being refused because no driver exists which can supply a pointer to the surface. This is most likely to happen when attempting to lock the primary surface when no DCI provider is present.",
	"DDERR_SURFACEISOBSCURED  - Access to Surface refused because Surface is obscured.",
	"DDERR_SURFACELOST  - Access to this surface is being refused because the surface is gone. The DIRECTDRAWSURFACE object representing this surface should  have Restore called on it.",
	"DDERR_SURFACENOTATTACHED  - The requested surface is not attached.",
	"DDERR_TOOBIGHEIGHT  - Height requested by DirectDraw is too large.",
	"DDERR_TOOBIGSIZE  - Size requested by DirectDraw is too large -- The individual height and width are OK.",
	"DDERR_TOOBIGWIDTH  - Width requested by DirectDraw is too large.",
	"DDERR_UNSUPPORTED  - Action not supported.",
	"DDERR_UNSUPPORTEDFORMAT  - FOURCC format requested is unsupported by DirectDraw",
	"DDERR_UNSUPPORTEDMASK  - Bitmask in the pixel format requested is unsupported by DirectDraw",
	"DDERR_VERTICALBLANKINPROGRESS  - vertical blank is in progress",
	"DDERR_WASSTILLDRAWING  - Informs DirectDraw that the previous Blt which is transfering information to or from this Surface is incomplete.",
	"DDERR_XALIGN  - Rectangle provided was not horizontally aligned on reqd. boundary",
	"DDERR_INVALIDDIRECTDRAWGUID  - The GUID passed to DirectDrawCreate is not a valid DirectDraw driver identifier.",
	"DDERR_DIRECTDRAWALREADYCREATED  - A DirectDraw object representing this driver has already been created for this process.",
	"DDERR_NODIRECTDRAWHW  - A hardware only DirectDraw object creation was attempted but the driver did not support any hardware.",
	"DDERR_PRIMARYSURFACEALREADYEXISTS  - this process already has created a primary surface",
	"DDERR_NOEMULATION  - software emulation not available.",
	"DDERR_REGIONTOOSMALL  - region passed to Clipper::GetClipList is too small.",
	"DDERR_CLIPPERISUSINGHWND  - an attempt was made to set a clip list for a clipper objec that is already monitoring an hwnd.",
	"DDERR_NOCLIPPERATTACHED  - No clipper object attached to surface object",
	"DDERR_NOHWND  - Clipper notification requires an HWND or no HWND has previously been set as the CooperativeLevel HWND.",
	"DDERR_HWNDSUBCLASSED  - HWND used by DirectDraw CooperativeLevel has been subclassed, this prevents DirectDraw from restoring state.",
	"DDERR_HWNDALREADYSET  - The CooperativeLevel HWND has already been set. It can not be reset while the process has surfaces or palettes created.",
	"DDERR_NOPALETTEATTACHED  - No palette object attached to this surface.",
	"DDERR_NOPALETTEHW  - No hardware support for 16 or 256 color palettes.",
	"DDERR_BLTFASTCANTCLIP  - If a clipper object is attached to the source surface passed into a BltFast call.",
	"DDERR_NOBLTHW  - No blter.",
	"DDERR_NODDROPSHW  - No DirectDraw ROP hardware.",
	"DDERR_OVERLAYNOTVISIBLE  - returned when GetOverlayPosition is called on a hidden overlay",
	"DDERR_NOOVERLAYDEST  - returned when GetOverlayPosition is called on a overlay that UpdateOverlay has never been called on to establish a destionation.",
	"DDERR_INVALIDPOSITION  - returned when the position of the overlay on the destionation is no longer legal for that destionation.",
	"DDERR_NOTAOVERLAYSURFACE  - returned when an overlay member is called for a non-overlay surface",
	"DDERR_EXCLUSIVEMODEALREADYSET  - An attempt was made to set the cooperative level when it was already set to exclusive.",
	"DDERR_NOTFLIPPABLE  - An attempt has been made to flip a surface that is not flippable.",
	"DDERR_CANTDUPLICATE  - Can't duplicate primary & 3D surfaces, or surfaces that are implicitly created.",
	"DDERR_NOTLOCKED  - Surface was not locked. An attempt to unlock a surface that was not locked at all, or by this process, has been attempted.",
	"DDERR_CANTCREATEDC  - Windows can not create any more DCs",
	"DDERR_NODC  - No DC was ever created for this surface.",
	"DDERR_WRONGMODE  - This surface can not be restored because it was created in a different mode.",
	"DDERR_IMPLICITLYCREATED  - This surface can not be restored because it is an implicitly created surface.",
	"DDERR_NOTPALETTIZED  - The surface being used is not a palette-based surface",
	"DDERR_UNSUPPORTEDMODE  - The display is currently in an unsupported mode",
	"DDERR_NOMIPMAPHW  - Operation could not be carried out because there is no mip-map texture mapping hardware present or available.",
	"DDERR_INVALIDSURFACETYPE  - The requested action could not be performed because the surface was of the wrong type.",
	"DDERR_DCALREADYCREATED  - A DC has already been returned for this surface. Only one DC can be  retrieved per surface.",
	"DDERR_CANTPAGELOCK  - The attempt to page lock a surface failed.",
	"DDERR_CANTPAGEUNLOCK  - The attempt to page unlock a surface failed.",
	"DDERR_NOTPAGELOCKED  - An attempt was made to page unlock a surface with no outstanding page locks.",
	"DDERR_NOTINITIALIZED  - An attempt was made to invoke an interface member of a DirectDraw object created by CoCreateInstance() before it was initialized."
};

void ShowDDHR(char* strPlace,HRESULT hr)
{
	if(hr==DD_OK) return;

	int iPos=0,iErrorPos=-1;
	do
	{
		if(hrDirectDrawError[iPos]==hr) iErrorPos=iPos;
		iPos++;
	}
	while(hrDirectDrawError[iPos]!=DD_OK);

	char strTitle[256];
	wsprintf(strTitle,"DirectDraw error at %s",strPlace);

/*	MessageBox(NULL,strDirectDrawError[iPos-1-iErrorPos],
		strTitle,MB_ICONSTOP|MB_OK);*/
	char strTraceMessage[512];
	wsprintf(strTraceMessage,"DirectDraw error %i at %s - %s\n",
		iErrorPos,strTitle,
		strDirectDrawError[iPos-1-iErrorPos]);
	OutputDebugString(strTraceMessage);

};

#endif // DXERRORS_H