program Sternen_Effekt;

uses crt;

const StarNo = 1000; { 1000 Sterne }

type Star3D = record
                x,y,z : integer;
              end;
     Star2D = record
                x,y : integer;
              end;
     Star2DArray = array[1..StarNo] of Star2D;

var Stars3D : array[1..StarNo] of Star3D;
    Stars2D : Star2DArray;
    Backup  : Star2DArray;
    ZAdd,n  : integer;

procedure InitStars;
var n : integer;

begin
  for n := 1 to StarNo do begin
    repeat
      Stars3D[n].x := random(640) - 320;
      Stars3D[n].y := random(400) - 200;
    until (Stars3D[n].x <> 0) and (Stars3D[n].y <> 0);
    Stars3D[n].z := random(StarNo);
  end;
end;

procedure Calc_2Dto3D;
var n : integer;

begin
  for n := 1 to StarNo do begin
    Stars2D[n].x := Stars3D[n].x * 128 div Stars3D[n].z + 160;
    Stars2D[n].y := Stars3D[n].y * 128 div Stars3D[n].z + 100;
  end;
end;

procedure DrawStars;
var n : integer;

begin
  for n := 1 to StarNo do if (Stars2D[n].x > 0) and (Stars2D[n].x < 320)
                             and (Stars2D[n].y > 0) and (Stars2D[n].y < 200)
                             and (Stars3D[n].z < 500)
                          then mem[$A000:Stars2D[n].y*320+Stars2D[n].x] :=
                              63-Stars3D[n].z div 10;
end;

procedure ClearStars;
var n : integer;

begin
  for n := 1 to StarNo do if (Backup[n].x > 0) and (Backup[n].x < 320)
                             and (Backup[n].y > 0) and (Backup[n].y < 200)
                          then mem[$A000:Backup[n].y*320+Backup[n].x] := 0;
end;

procedure MoveStars;
var n : integer;

begin
  for n := 1 to StarNo do begin
    inc(Stars3D[n].z,ZAdd);
    if Stars3D[n].z < 1 then inc(Stars3D[n].z,StarNo);
    if Stars3D[n].z > StarNo then dec(Stars3D[n].z,StarNo);
  end;
end;

procedure WaitRetrace;assembler;
asm
  mov     dx,3DAh
@1:
  in      al,dx
  and     al,8
  jz      @1
@2:
  in      al,dx
  and     al,8
  jz      @2
end;

procedure SetPal(col,r,g,b:byte);assembler;
asm
  mov     dx,3C8h
  mov     al,col
  out     dx,al
  inc     dx
  mov     al,r
  out     dx,al
  mov     al,g
  out     dx,al
  mov     al,b
  out     dx,al
end;


begin
  randomize;            { Zufallsgenerator anwerfen }
  InitStars;            { Sternenarrays mit Werten fllen }
  asm mov ax,13h; int 10h end; { VGA Modus setzen }
  for n := 0 to 63 do SetPal(n,n,n,n); { Palette setzen }
  ZAdd := -4;           { ZAdd initialisieren }
  repeat
    MoveStars;          { Sterne bewegen }
    Backup := Stars2D;  { Alte Sternpositionen sichern }
    Calc_2Dto3D;        { und neue berechnen }
    WaitRetrace;        { Auf Retrace warten }
    ClearStars;         { Alte Sterne lschen }
    DrawStars;          { und neue zeichnen }
  until keypressed;
  readkey;
  asm mov ax,3; int 10h end;
end.
