{
        Unidad para manejo de punto fijo
        Por: FAC
        Contiene cdigo de David Boeren
        Agradecimientos a Night Stalker y Boris Bertelsons

        Manejo de nmeros de punto fijo de 16.16 con signo.

        Para mayor rapidez, inclur el cdigo en la unidad en que se usa.
}


unit FMath;

interface


type Fixed = longint;

{ Conversin entre tipos }
function Int2Fixed(n : integer) : Fixed;        { Entero --> Punto Fijo }
function Real2Fixed(n : real) : Fixed;      {   Real --> Punto Fijo }
function Fixed2Int(n : Fixed) : integer;  { Punto Fijo --> Entero }
function RoundFixed2Int(n : Fixed) : integer; { Fijo --> Entero (redondeo) }
function Fixed2Real(n : Fixed) : real;      { Punto Fijo --> Real }

{ Operaciones algebricas }
function FMul(n1, n2 : Fixed) : Fixed;    { Multiplicacin }
function FDiv(const n1, n2 : Fixed) : Fixed;    { Divisin }


implementation

const long = $66;  { Opcode para instrucciones de 32 bits }

function Int2Fixed(n : integer) : Fixed;
begin
     Int2Fixed := Fixed(n) shl 16;
end;

function Real2Fixed(n : real) : Fixed;
begin
     Real2Fixed := round(n * 65536);
end;

function Fixed2Int(n : Fixed) : integer; assembler;
asm
   db long; mov ax, word ptr [n]     { mov eax, n }
   db long; sar ax, 16               { sar eax, 16 }
end;

function RoundFixed2Int(n : Fixed) : integer; assembler;
asm
   db long; mov ax, word ptr [n]     { mov eax, n }
   db long; add ax, 8000h; dw 0      { add eax, 8000h }
   db long; sar ax, 16               { sar eax, 16 }
end;

function Fixed2Real(n : Fixed) : real;
begin
     Fixed2Real := n / 65536.0;
end;

function FMul(n1, n2 : Fixed) : Fixed; assembler;
asm
   db long; mov ax, word ptr [n1]     { mov eax, n1 }
   db long; mov dx, word ptr [n2]     { mov edx, n2 }
   db long; imul dx                   { imul edx    }
   db long; add ax, 8000h; dw 0       { add eax, 8000h }
   db long; adc dx, 0                 { adc edx, 0  }
   db long; shr ax, 16                { shr eax, 16 }
end;

function FDiv(const n1, n2 : Fixed) : FIxed; assembler;
asm
   db long; mov dx, word ptr [n1]     { mov edx, n1 }
   db long; mov bx, word ptr [n2]     { mov ebx, n2 }
   db long; xor ax, ax                { xor eax, eax }
   db long, $0F, $AC, $D0, $10        { shrd eax, edx, 16 }
   db long; sar dx, 16                { sar edx, 16 }
   db long; idiv bx                   { idiv ebx }
   db long, $0F, $A4, $C2, $10        { shld edx, eax, 16 }
end;

end.
