
// SPLASMA2.CPP  --  por FAC
// Plasma fractal generado con el algoritmo de Alex Chalfin

#include <iostream.h>      // cout
#include <conio.h>         // clrscr, getch, kbhit
#include <stdlib.h>        // abs, randomize, random
#include "mode13.h"
#include "mode13.cpp"

const double Rugosidad = 2.0;


void NuevoColor(int x1, int y1, int x, int y, int x2, int y2)
{
     double color;

     color = abs(x1 - x2) + abs(y1 - y2);
     color = (GetPixel(x1, y1, VGA) + GetPixel(x2, y2, VGA)) / 2 +
             ((random(1000) / 1000.0) - 0.5) * color * Rugosidad;
     if (color < 1) color = 1;
     if (color > 255) color = 255;

     if (!GetPixel(x, y, VGA)) PutPixel(x, y, color, VGA);
}


void GeneraPlasma(int x1, int y1, int x2, int y2)
{
     int x, y, color;

     if (!(((x2 - x1) < 2) && ((y2 - y2) < 2)))
     {
          x = (x1 + x2) / 2;
          y = (y1 + y2) / 2;

          NuevoColor(x1, y1, x, y1, x2, y1);
          NuevoColor(x2, y1, x2, y, x2, y2);
          NuevoColor(x1, y2, x, y2, x2, y2);
          NuevoColor(x1, y1, x1, y, x1, y2);

          color = (GetPixel(x1, y1, VGA) + GetPixel(x2, y1, VGA) +
                   GetPixel(x1, y2, VGA) + GetPixel(x2, y2, VGA) + 2) / 4;

          PutPixel(x, y, color, VGA);

          GeneraPlasma(x1, y1, x, y);
          GeneraPlasma(x, y1, x2, y);
          GeneraPlasma(x, y, x2, y2);
          GeneraPlasma(x1, y, x, y2);
     }
}


// Paleta alterna
void GeneraPaleta(TPalette &pal)
{
     for (byte i = 0; i < 64; i++)
     {
          pal[i][0] = 63 - i;
          pal[i][1] = i;
          pal[i][2] = 0;
          pal[i + 64][0] = 0;
          pal[i + 64][1] = 63 - i;
          pal[i + 64][2] = i;
          pal[i + 128][0] = i;
          pal[i + 128][1] = i;
          pal[i + 128][2] = 63 - i;
          pal[i + 192][0] = 63;
          pal[i + 192][1] = 63 - i;
          pal[i + 192][2] = 0;
     }
}


void main()
{
     TPalette pal;
     byte i;

     clrscr();
     cout << "\nEjemplo de plasma esttico generado con el algoritmo\n"
          << "de Alex Chalfin\n"
          << "\nPresiona una tecla...\n";
     getch();

     randomize();
     SetMode13();
     FadeOut(0);
     ClearScreen(0, VGA);

     // Generamos una paleta con negro, rojo y amarillo
     for (i = 0; i < 64; i++)
     {
          SetPal(i, i, 0, 0);
          SetPal(i + 64, 63, i, 0);
          SetPal(i + 128, 63, 63 - i, 0);
          SetPal(i + 192, 63 - i, 0, 0);
     }
     GetPalette(pal);

//   GeneraPaleta(pal);   // Genera una paleta opcional

     // Generamos 5 "semillas" al azar (opcional)
//     for (i = 0; i < 5; i++)
//         PutPixel(random(320), random(200), random(255) + 1, VGA);

     GeneraPlasma(0, 0, 319, 199);

     while (!kbhit())
     {
          RotatePalette(pal, 255, 1);
          VRetrace();
          SetPalette(pal);
     }
     getch();

     FadeOut(5);
     SetTextMode();
}
