
program Interferencia;

{ Ejemplo de interferencia sobre un fondo esttico + sprite animado }
{ por FAC  --  para el tutorial #7                                  }


uses Mode13, Crt;


{ Definimos el tipo de datos para almacenar los cuadros de la animacin }
type PTCuadro = ^TCuadro;
     TCuadro = array[0..79] of array[0..79] of byte;


var VirScr1, VirScr2 : PTVirtual;  { Usamos 2 pantallas virtuales }
    VirSeg1, VirSeg2 : word;

    paleta : TPalette;

    Cuadro : array[0..7] of PTCuadro;  { La animacin consta de 8 cuadros }

    { Variables del sprite }
    CaraX, CaraY, CaraXVel, CaraYVel, CaraCuadro : integer;

    { CaraX, CaraY : posicin del sprite         }
    { CaraXVel, CaraYVel : velocidad del sprite  }
    { CaraCuadro : cuadro actual                 }


{ Este procedimiento inicializa las variables y carga los cuadros }
{ de la animacin                                                 }
procedure Inicializa;
var x, y, c : integer;
    temp : TPalette;
begin
     Randomize;   { Iniciamos el generador de nmeros aleatorios }

     { Reservamos memoria para los cuadros }
     for c := 0 to 7 do Cuadro[c] := new(PTCuadro);

     { Reservamos memoria para las pantallas virtuales }
     SetupVirtual(VirScr1, VirSeg1);
     SetupVirtual(VirScr2, VirSeg2);

     { El siguiente ciclo carga y almacena los cuadros }
     for c := 0 to 7 do
     begin
          LoadPCX('face'+chr(c+48)+'.pcx', VirSeg1, 80, 80, 0, 0, temp);
          for y := 0 to 79 do
              for x := 0 to 79 do
                  Cuadro[c]^[y][x] := GetPixel(x, y, VirSeg1);
     end;

     { Cargamos la imagen de fondo en la pantalla virtual 1 }
     LoadPCX('back.pcx', VirSeg1, 320, 200, 0, 0, paleta);

     { Creamos la imagen de la interferencia en la pantalla virtual 2 }
     for y := 0 to 199 do
         for x := 0 to 319 do
             PutPixel(x, y, random(16) + 240, VirSeg2);

     { Copiamos los colores de la animacin a la paleta }
     { La animacin utiliza los colores del 128 al 146 }
     for c := 128 to 146 do paleta[c] := temp[c];

     { Creamos una escala de grises en los ltimos 16 colores de la paleta }
     { Estos colores son para la interferencia }
     for c := 240 to 255 do
     begin
          paleta[c][0] := (c - 240) * 16;
          paleta[c][1] := paleta[c][0];
          paleta[c][2] := paleta[c][0];
     end;

     { Inicializamos las variables del sprite }
     CaraX := 120;
     CaraY := 60;
     CaraXVel := -2;
     CaraYVel := -2;
     CaraCuadro := 0;

     SetMode13; { Iniciamos el modo grfico }
end;


{ Este procedimiento libera la memoria reservada y regresa al modo texto }
procedure Termina;
var i : integer;
begin
     for i := 0 to 7 do dispose(Cuadro[i]);
     ShutDownVirtual(VirScr1);
     ShutDownVirtual(VirScr2);
     SetTextMode;
end;


{ Este procedimiento dibuja el sprite (directamente a VGA) }
procedure DibujaCara;
var x, y, off : word;
    cuad : PTCuadro;
begin
     cuad := Cuadro[CaraCuadro div 4];
     { La variable CaraCuadro va de 0 a 31, por lo tanto, la expresin
       CaraCuadro div 4 nos devuelve un nmero de 0 a 7.
       Esto se hace as para disminur la velocidad de animacin }

     off := YOffset[CaraY] + CaraX;
     for y := 0 to 79 do
     begin
          for x := 0 to 79 do
          begin
               { El color "transparente" es el 128 }
               if cuad^[y][x] <> 128 then mem[VGA:off] := cuad^[y][x];
               inc(off); { incrementamos la posicin horizontal }
          end;
          inc(off, 240);
          { Sumamos 240 para pasar a la siguiente lnea, ya que la
            dimensin horizontal del sprite es de 80, -> 240 + 80 = 320 }
     end;
end;


{ Para los que quieran aprender, este es el equivalente en ASM de la       }
{ rutina anterior. Para ver cmo funciona, des-comenten este procedimiento }
{ y comenten el anterior.                                                  }
(*
procedure DibujaCara; assembler;
asm
   mov ax, $A000
   mov es, ax           { movemos a ES el segmento de la memoria VGA }
   mov bx, CaraY        { BX := CaraY }
   mov di, CaraX        { DI := CaraX }
   add bx, bx           { BX := BX * 2  == CaraY * 2 }
   add di, word ptr [YOffset + bx]    { DI := CaraX + YOffset[CaraY]  }
   mov bx, CaraCuadro   { BX := CaraCuadro }
   and bx, $FC          { Esto equivale a BX := (BX div 4) * 4 }
   add bx, offset Cuadro    { Usamos BX como ndice para el array Cuadro }
   mov ax, word ptr [bx + 2]  { AX := Segmento del cuadro }
   mov si, word ptr [bx]      { SI := Offset del cuadro }
   push ds                    { Guardamos DS }
   mov ds, ax                 { DS := AX == Segmento del cuadro }
   mov ch, 80                 { CH := 80  (contador en Y) }

   @loopy:  mov cl, 80        { CL := 80  (contador en X) }

   @loopx:  mov al, [si]      { AL := Siguiente pxel del cuadro }
            test al, $7F      { Comprobamos si AL = 128 }
            jz @transp        { Si es as, saltamos a @transp }
            mov es:[di], al   { Dibujamos el pxel en la pantalla }

   @transp: inc di       { Incrementamos el offset en la pantalla }
            inc si       { Incrementamos el offset en el cuadro }
            dec cl       { decrementamos el contador en X }
            jnz @loopx   { Si no es cero todava, salta a @loopx }

            add di, 240  { Incrementamos el offset en la pantalla en 240 }
            dec ch       { decrementamos el contador en Y }
            jnz @loopy   { Si no es cero todava, saltamos a @loopy }
            pop ds       { recuperamos DS }
end;
*)


{ El siguiente procedimiento mueve el sprite }
procedure MueveCara;
begin
     { Modificamos la posicin del sprite }
     inc(CaraX, CaraXVel);
     inc(CaraY, CaraYVel);

     { Y comprobamos que quede dentro de los lmites }
     if CaraX < 2 then CaraXVel := 2
        else if CaraX > 236 then CaraXVel := -2;

     if CaraY < 2 then CaraYVel := 2
        else if CaraY > 116 then CaraYVel := -2;

     { Incrementamos CaraCuadro y lo mantenemos entre 0 y 31 }
     CaraCuadro := (CaraCuadro + 1) mod 32;
end;


{ Este procedimiento despliega el fondo y el sprite pero sin interferencia }
procedure SinInterferencia;
begin
     SetPalette(paleta);
     while not keypressed do  { mientras no se presione una tecla... }
     begin
          VRetrace;  { Esperamos al retrazado vertical }
          CopyScreen(VirSeg1, VGA); { Copiamos el fondo a VGA }
          DibujaCara;         { Dibujamos el sprite }
          MueveCara;          { y lo movemos }
     end;
     readkey; { leemos la tecla presionada y la desechamos }
end;


{ Este procedimiento introduce poco a poco la interferencia }
procedure ComienzaInterferencia;
var prob : integer;  { probabilidad de interferencia }
begin
     prob := 100; { Empezamos con un valor arbitrario }

     { Hasta que se presione una tecla o la probabilidad sea demasiada... }
     while (not keypressed) and (prob < 800) do
     begin
          VRetrace;  { Esperamos el retrazado vertical }

          { Aqui decidimos si dibujamos el fondo o la interferencia }
          if random(prob) > 100 then CopyScreen(VirSeg2, VGA)
                                else CopyScreen(VirSeg1, VGA);

          DibujaCara;       { Dibujamos el sprite }
          SetPalette(paleta); { Activamos la nueva paleta }
          MueveCara;          { Movemos el sprite }
          inc(prob);          { Aumentamos la probabilidad de interferencia }
          RotatePalette(paleta, 240, 255); { y rotamos la paleta }
     end;
     if keypressed then readkey; { Si se oprimi una tecla, la leemos }
end;


{ En esta parte, el fondo ya no aparece y solo queda la interferencia }
procedure PuraInterferencia;
begin
     while not keypressed do   { mientras no se presione una tecla... }
     begin
          VRetrace;     { Esperamos al retrazado vertical }
          CopyScreen(VirSeg2, VGA); { Copiamos la interferencia a VGA }
          DibujaCara;         { Dibujamos el sprite }
          SetPalette(paleta); { Activamos la nueva paleta }
          MueveCara;          { Movemos el sprite }
          RotatePalette(paleta, 240, 255); { y rotamos la paleta }
     end;
     readkey; { leemos y desechamos la tecla presionada }
end;


{ principal }
begin
     clrscr;
     writeln;
     writeln('Ejemplo de interferencia sobre un fondo esttico y aadiendo');
     writeln('un sprite por encima del efecto.');
     writeln;
     writeln('Presiona una tecla para continuar, otra para iniciar la');
     writeln('interferencia y otra para salir del programa...');
     readkey;

     Inicializa;  { Inicializamos las variables e imgenes }

     SinInterferencia;  { Mostramos el fondo y el sprite sin interferencia }
     ComienzaInterferencia;  { Introducimos la interferencia poco a poco }
     PuraInterferencia;  { y la dejamos ah }

     Termina; { Liberamos la memoria utilizada y terminamos el programa }
end.
