{ Unidad Mode_13.TPU versin 2.0
  Por: FAC aka Alfonso Alba

  Contiene procedimientos y funciones para trabajar en el modo 13 }


unit Mode_13;


interface

{ Tipos y constantes utilizadas }
const VGA = $A000;

type TPalette = array[0..255, 0..2] of byte;


{ Cambiar de modo grfico }
procedure SetMode13;
procedure SetTextMode;

{ Procedimientos de dibujo }
procedure ClearScreen(color : byte; where : word);
procedure PutPixel(x, y : word; color : byte; where : word);
function  GetPixel(x, y : word; where : word) : byte;

procedure HLine(x1, x2, y : word; color : byte; where : word);
procedure VLine(x, y1, y2 : word; color : byte; where : word);

{ Manejo de paleta }
procedure GetPal(color : byte; var red, green, blue : byte);
procedure SetPal(color, red, green, blue : byte);
procedure GetPalette(var pal : TPalette);
procedure SetPalette(pal : TPalette);

{procedure FadeOut(d : word);
procedure FadeIn(p : TPalette; d : word);
procedure RotatePalette(p : TPalette; st, en : byte);}

{ Pantallas virtuales }

type TVirtual = array[1..64000] of byte;
     PTVirtual = ^TVirtual;

procedure SetupVirtual(var Vscr : PTVirtual; var Vseg : word);
procedure ShutDownVirtual(var Vscr : PTVirtual);
procedure CopyScreen(source, dest : word);


{ Procedimientos y funciones diversos }
procedure VRetrace;
procedure LoadPCX(fn : string; where, DimX, DimY, OffX, OffY : word;
                  var pal : TPalette);


implementation


{ Cambio de modo grafico }

procedure SetMode13; { Cambia al modo 13 (320 * 200 * 256) }
begin
     asm
        mov ax, 0013h
        int 10h
     end;
end;


procedure SetTextMode; { Cambia al modo de texto de 80 * 25 caracteres }
begin
     asm
        mov ax, 0003h
        int 10h
     end;
end;


{ Procedimientos de dibujo }

procedure ClearScreen(color : byte; where : word);
{ Borra la pantalla pintndola con un determinado color }
begin
     FillChar(Mem[where:0], 64000, color);
end;


procedure PutPixel(x, y : word; color : byte; where : word);
{ Dibuja un pxel }
begin
     Mem[where:y*320+x] := color;
end;


function GetPixel(x, y, where : word) : byte;
{ Devuelve el color del pxel en (x, y)}
begin
     GetPixel := Mem[where:y*320+x];
end;


procedure HLine(x1, x2, y : word; color : byte; where : word);
{ Dibuja una lnea horizontal desde (x1, y) hasta (x2, y) }
var x : word;
begin
     if x1 < x2
     then
         for x := x1 to x2 do PutPixel(x, y, color, where)
     else
         for x := x2 to x1 do PutPixel(x, y, color, where);
end;


procedure VLine(x, y1, y2 : word; color : byte; where : word);
{ Dibuja una lnea vertical desde (x, y1) hasta (x, y2) }
var y : word;
begin
     if y1 < y2
     then
         for y := y1 to y2 do PutPixel(x, y, color, where)
     else
         for y := y2 to y1 do PutPixel(x, y, color, where);
end;


{ Manejo de paleta }

procedure GetPal(color : byte; var red, green, blue : byte);
{ Lee los valores de rojo, verde y azul de un color en la paleta }
begin
     port[$3C7] := color;
     red := port[$3C9];
     green := port[$3C9];
     blue := port[$3C9];
end;


procedure SetPal(color, red, green, blue : byte);
{ Fija los valores de rojo, verde y azul de un color en la paleta }
begin
     port[$3C8] := color;
     port[$3C9] := red;
     port[$3C9] := green;
     port[$3C9] := blue;
end;


procedure GetPalette(var pal : TPalette);
{ Almacena la paleta actual en una variable de tipo TPalette }
var i : byte;

begin
     for i := 0 to 255 do
         GetPal(i, pal[i, 0], pal[i, 1], pal[i, 2]);
end;


procedure SetPalette(pal : TPalette);
{ Restaura la paleta entera a partir de una variable de tipo TPalette }
var i : byte;

begin
     for i := 0 to 255 do
         SetPal(i, pal[i, 0], pal[i, 1], pal[i, 2]);
end;


{ Pantallas virtuales }

procedure SetupVirtual(var Vscr : PTVirtual; var Vseg : word);
begin
     Vscr := new(PTVirtual);
     Vseg := seg(Vscr^);
end;

procedure ShutDownVirtual(var Vscr : PTVirtual);
begin
     dispose(Vscr);
     Vscr := nil;
end;

procedure CopyScreen(source, dest : word);
begin
     move(Mem[source:0], Mem[dest:0], 64000);
end;


{ Procedimientos diversos }

procedure VRetrace; assembler;
{ Espera hasta que ocurra un retrazado vertical }
label loop1, loop2;

asm
   mov dx, 3DAh         { El puerto $3DA nos dice si est activo el
                          retrazado vertical }
loop1:
      in al, dx         { examinamos el puerto }
      and al, 08h       { y vemos si en ese momento se est efectuando
                          el retrace }
      jnz loop1         { Si es as, esperamos hasta que termine }
loop2:
      in al, dx         { Examinamos otra vez el puerto }
      and al, 08h       { y vemos si empieza algn retrace vertical }
      jz loop2          { Y espera hasta que empiece el retrace }
end;

{ Procedimiento para cargar imagenes PCX }
procedure LoadPCX(fn : string; where, DimX, DimY, OffX, OffY : word;
                  var pal : TPalette);

var f : file of byte; { archivo que vamos a abrir }
    x, y : word;   { contadores y variables temporales }
    r, g, b : byte;   { para leer la paleta de colores }
    c, i, a : byte;      { ms contadores y variables temporales }
    flag : boolean;   { indicador de que hemos terminado }

    { Esta es una funcin auxiliar que incrementa la posicin en el
      array en el que se almacena la imagen e indica si se ha ledo
      toda la imagen }
    function IncPos : boolean;
    begin
         inc(x); { incrementamos X }
         if x = DimX then { Si ya terminamos esa lnea, entonces... }
         begin
              x := 0; { Volvemos a empezar en la siguiente lnea }
              inc(y);
         end;
         if y = DimY then IncPos := true else IncPos := false;
         { Si ya terminamos todas las lneas de la imagen, entonces
           regresa true, de lo contrario regresa false }
    end;

begin
     assign(f, fn); { abrimos el archivo de la imagen }
     reset(f);

     seek(f, 128); { nos saltamos el encabezado de 128 bytes }
     flag := true; { Si flag = false, entonces hemos terminado }
     x := 0; { Empezamos en (0,0); }
     y := 0;
     while flag do
     begin
          read(f, c);   { leemos el siguiente byte }
          if ((c and $c0) = $c0) then
          { y comprobamos los 2 bits ms significativos }
          begin
               { si los bits estn activados, entonces el byte es un
                 contador }
               read(f, a); { leemos el siguiente byte }
               for i := 1 to (c and $3f) do { hacemos el ciclo }
               begin
                    PutPixel(OffX + x, OffY + y, a, where);
                    { almacenamos el byte de datos }
                    if IncPos then flag := false;
                    { Incrementamos la posicin y comprobamos si no
                      hemos terminado de leer la imagen }
               end;
          end
          else
          { Si los 2 bits no estan activados, entonces el byte es un
            byte de datos }
          begin
               PutPixel(OffX + x, OffY + y, c, where);
               { y simplemente lo almacenamos }
               if IncPos then flag := false;
               { y continuamos con la siguiente posicin }
          end;
     end;

     { Si ya termin de leer la imagen, entonces sigue la paleta }
     seek(f, filesize(f) - 768); { Buscamos los ltimos 768 bytes }

     for i := 0 to 255 do { y leemos la paleta }
     begin
          read(f, r, g, b);
          pal[i,0] := r div 4;   { Los valores del archivo PCX }
          pal[i,1] := g div 4; { van de 0 a 255, as que hay }
          pal[i,2] := b div 4;  { que dividirlos entre 4 }
     end;

     close(f); { cerramos el archivo }
end;



end.
