{ Unidad Mode_13.TPU
  Por: FAC aka Alfonso Alba

  Contiene procedimientos y funciones para trabajar en el modo 13 }


unit Mode_13;


interface

{ Tipos y constantes utilizadas }
const VGA = $A000;

type TPalette = array[0..255, 0..2] of byte;


{ Cambiar de modo grfico }
procedure SetMode13;
procedure SetTextMode;

{ Procedimientos de dibujo }
procedure ClearScreen(color : byte);
procedure PutPixel(x, y : word; color : byte);
function  GetPixel(x, y : word) : byte;

procedure HLine(x1, x2, y : word; color : byte);
procedure VLine(x, y1, y2 : word; color : byte);

{ Manejo de paleta }
procedure GetPal(color : byte; var red, green, blue : byte);
procedure SetPal(color, red, green, blue : byte);
procedure GetPalette(var pal : TPalette);
procedure SetPalette(pal : TPalette);


{ Procedimientos y funciones diversos }
procedure VRetrace;


implementation


{ Cambio de modo grafico }

procedure SetMode13; { Cambia al modo 13 (320 * 200 * 256) }
begin
     asm
        mov ax, 0013h
        int 10h
     end;
end;


procedure SetTextMode; { Cambia al modo de texto de 80 * 25 caracteres }
begin
     asm
        mov ax, 0003h
        int 10h
     end;
end;


{ Procedimientos de dibujo }

procedure ClearScreen(color : byte);
{ Borra la pantalla pintndola con un determinado color }
begin
     FillChar(Mem[VGA:0], 64000, color);
end;


procedure PutPixel(x, y : word; color : byte); { Dibuja un pxel }
begin
     Mem[VGA:y*320+x] := color;
end;


function GetPixel(x, y : word) : byte; { Devuelve el color del pxel en (x, y)}
begin
     GetPixel := Mem[VGA:y*320+x];
end;


procedure HLine(x1, x2, y : word; color : byte);
{ Dibuja una lnea horizontal desde (x1, y) hasta (x2, y) }
var x : word;
begin
     if x1 < x2
     then
         for x := x1 to x2 do PutPixel(x, y, color)
     else
         for x := x2 to x1 do PutPixel(x, y, color);
end;


procedure VLine(x, y1, y2 : word; color : byte);
{ Dibuja una lnea vertical desde (x, y1) hasta (x, y2) }
var y : word;
begin
     if y1 < y2
     then
         for y := y1 to y2 do PutPixel(x, y, color)
     else
         for y := y2 to y1 do PutPixel(x, y, color);
end;


{ Manejo de paleta }

procedure GetPal(color : byte; var red, green, blue : byte);
{ Lee los valores de rojo, verde y azul de un color en la paleta }
begin
     port[$3C7] := color;
     red := port[$3C9];
     green := port[$3C9];
     blue := port[$3C9];
end;


procedure SetPal(color, red, green, blue : byte);
{ Fija los valores de rojo, verde y azul de un color en la paleta }
begin
     port[$3C8] := color;
     port[$3C9] := red;
     port[$3C9] := green;
     port[$3C9] := blue;
end;


procedure GetPalette(var pal : TPalette);
{ Almacena la paleta actual en una variable de tipo TPalette }
var i : byte;

begin
     for i := 0 to 255 do
         GetPal(i, pal[i, 0], pal[i, 1], pal[i, 2]);
end;


procedure SetPalette(pal : TPalette);
{ Restaura la paleta entera a partir de una variable de tipo TPalette }
var i : byte;

begin
     for i := 0 to 255 do
         SetPal(i, pal[i, 0], pal[i, 1], pal[i, 2]);
end;


{ Procedimientos diversos }

procedure VRetrace; assembler;
{ Espera hasta que ocurra un retrazado vertical }
label loop1, loop2;

asm
   mov dx, 3DAh         { El puerto $3DA nos dice si est activo el
                          retrazado vertical }
loop1:
      in al, dx         { examinamos el puerto }
      and al, 08h       { y vemos si en ese momento se est efectuando
                          el retrace }
      jnz loop1         { Si es as, esperamos hasta que termine }
loop2:
      in al, dx         { Examinamos otra vez el puerto }
      and al, 08h       { y vemos si empieza algn retrace vertical }
      jz loop2          { Y espera hasta que empiece el retrace }
end;


end.