
program Lineas;

{ Un programa realmente interesante para ver funcionar los algoritmos
  de lneas rectas.

  ... s, tena prisa, y qu? ...
}

uses Mode_13, Crt;


{ Este es el primer algoritmo de lnea descrito en el tutorial }

     procedure Linea1(x1, y1, x2, y2 : word; color : byte);

     var dx, dy, x, y : integer;
         m : real;

     begin
          dx := x2 - x1;
          dy := y2 - y1;

          { Comprobar si es una lnea vertical }
          if dx = 0 then
          begin
               if dy < 0
               then
                   for y := y2 to y1 do PutPixel(x1, y, color)
               else
                   for y := y1 to y2 do PutPixel(x1, y, color);
               exit;
          end;

          { Comprobar si es una lnea horizontal }
          if dy = 0 then
          begin
               if dx < 0
               then
                   for x := x2 to x1 do PutPixel(x, y1, color)
               else
                   for x := x1 to x2 do PutPixel(x, y1, color);
               exit;
          end;

          { Calcular la pendiente y comprobar si es menor o igual que 1 }

          m := dy / dx;

          if abs(m) <= 1.0 then
          begin
               { Si la pendiente es menor o igual a 1, entonces...}
               if dx < 0 then
                   for x := x2 to x1 do
                   begin
                        y := round((x - x1) * m) + y1;
                        PutPixel(x, y, color);
                   end
               else
                   for x := x1 to x2 do
                   begin
                        y := round((x - x1) * m) + y1;
                        PutPixel(x, y, color);
                   end;
          end
          else
          begin
               { Si la pendiente es mayor que 1, entonces... }
               m := 1 / m; { Obtenemos el recproco de la pendiente }

               if dy < 0 then
                   for y := y2 to y1 do
                   begin
                        x := round((y - y1) * m) + x1;
                        PutPixel(x, y, color);
                   end
               else
                   for y := y1 to y2 do
                   begin
                        x := round((y - y1) * m) + x1;
                        PutPixel(x, y, color);
                   end;
          end;
     end;



{ Y este es el segundo algoritmo (un poco ms rpido) }

     procedure Linea2(x1, y1, x2, y2 : word; color : byte);

     var dx, dy, xx, yy : integer;
         m, x, y : real;

     begin
          dx := x2 - x1;
          dy := y2 - y1;

          { Comprobar si es una lnea vertical }
          if dx = 0 then
          begin
               if dy < 0
               then
                   for yy := y2 to y1 do PutPixel(x1, yy, color)
               else
                   for yy := y1 to y2 do PutPixel(x1, yy, color);
               exit;
          end;

          { Comprobar si es una lnea horizontal }
          if dy = 0 then
          begin
               if dx < 0
               then
                   for xx := x2 to x1 do PutPixel(xx, y1, color)
               else
                   for xx := x1 to x2 do PutPixel(xx, y1, color);
               exit;
          end;

          { Calcular la pendiente y comprobar si es menor o igual que 1 }

          m := dy / dx;

          if abs(m) <= 1.0 then
          begin
               { Si la pendiente es menor o igual a 1, entonces...}
               if dx < 0 then
               begin
                    y := y2;
                    for xx := x2 to x1 do
                    begin
                         PutPixel(xx, round(y), color);
                         y := y + m;
                    end;
               end
               else
               begin
                    y := y1;
                    for xx := x1 to x2 do
                    begin
                         PutPixel(xx, round(y), color);
                         y := y + m;
                    end;
               end;
          end
          else
          begin
               { Si la pendiente es mayor que 1, entonces... }
               m := dx / dy; { Obtenemos el recproco de la pendiente }

               if dy < 0 then
               begin
                    x := x2;
                    for yy := y2 to y1 do
                    begin
                         PutPixel(round(x), yy, color);
                         x := x + m;
                    end;
               end
               else
               begin
                    x := x1;
                    for yy := y1 to y2 do
                    begin
                         PutPixel(round(x), yy, color);
                         x := x + m;
                    end;
               end;
          end;
     end;

{ empieza el programa principal }

var i : integer;

begin
     clrscr;
     writeln;
     writeln('Programa de ejemplo para el algoritmo de lnea.');
     writeln;
     writeln('El programa dibuja varias lneas usando el primer algoritmo');
     writeln('y despus espera a que se presione una tecla y vuelve a');
     writeln('dibujar el mismo nmero de lneas, pero usando el segundo');
     writeln('algoritmo, el cual es un poco ms rpido.');
     writeln;
     writeln('Oprime algo para continuar...');
     readkey;

     SetMode13; { Despus de imprimir el rollo, activamos el modo 13 }

     { Dibujamos muchas lneas usando el primer algoritmo }

     for i := 0 to 319 do
         Linea1(160, 0, i, 199, i mod 256);

     for i := 319 downto 0 do
         Linea1(160, 199, i, 0, i mod 256);

     readkey; { espera a que se oprima una tecla }



     ClearScreen(0); { Borra la pantalla }

     { Y dibuja las lneas usando el segundo algoritmo }

     for i := 0 to 319 do
         Linea2(160, 0, i, 199, i mod 256);

     for i := 319 downto 0 do
         Linea2(160, 199, i, 0, i mod 256);

     readkey; { espera que se oprima una tecla }

     SetTextMode; { Regresa al modo texto y termina }
     clrscr;
end.
