{       CHARSET.PAS     por Alfonso Alba Cadena                           }
{                                                                         }
{       Esta unidad, as como la unidad Mode13.PAS son material           }
{       FREEWARE, por lo tanto, no pueden ser vendidas en ninguna         }
{       forma, (ya sea como parte de un programa, cd-rom o diskette),     }
{       sin permiso escrito del autor.                                    }
{                                                                         }
{       Las unidades pueden usarse para otros programas FREEWARE,         }
{       siempre y cuando se le d crdito al autor por estas rutinas.     }
{                                                                         }
{       El autor no se hace responsable por cualquier dao o explosin    }
{       que sufra cualquier persona o cosa, incluyendo computadoras,      }
{       a causa del uso o abuso de estas rutinas.                         }

unit CharSet;

interface

uses Mode13;

type TCharInfo = record
                 x, y : word;
                 end;

     TCharSetInfo = record
                    Chars : array[char] of TCharInfo;
                    SizeX, SizeY : byte;
                    charmap : string[12];
                    end;

     PTTextInfo = ^TTextInfo;
     TTextInfo = object
               private
                      txt : string[80];
                      x, y : word;
                      hs : integer;
                      next : PTTextInfo;
               public
                     constructor Init(nx, ny : word; s : string; nhs : integer);
                     destructor Done;
               end;


     PTCharSet = ^TCharSet;
     TCharSet = object
              public
                    Info : TCharSetInfo;
                    MapScr : PTVirtual;
                    MapSeg : word;
                    AllText : PTTextInfo;
                    Palette : TPalette;

                    constructor Init(fn : string);
                    destructor Done;
                    procedure Load(fn : string);
                    procedure PrintChar(x, y : word; c : char; where : word);
                    procedure PrintString(x, y : word; s : string; hs : integer; where : word);
                    procedure AddText(x, y : word; s : string; hs : integer);
                    procedure ClearText;
                    procedure PrintAll(where : word);
              end;


implementation

constructor TTextInfo.Init(nx, ny : word; s : string; nhs : integer);
begin
     x := nx;
     y := ny;
     txt := s;
     hs := nhs;
     next := nil;
end;

destructor TTextInfo.Done;
begin
     if next <> nil then dispose(next, Done);
     next := nil;
end;



constructor TCharSet.Init(fn : string);
begin
     SetupVirtual(MapScr, MapSeg);
     if fn <> '' then Load(fn);
     AllText := nil;
end;

destructor TCharSet.Done;
begin
     if MapScr <> nil then ShutDownVirtual(MapScr);
     if AllText <> nil then dispose(AllText, Done);
     MapScr := nil;
     AllText := nil;
end;

procedure TCharSet.Load(fn : string);
var f : file of TCharSetInfo;
begin
     assign(f, fn);
     reset(f);
     read(f, Info);
     LoadPCX(Info.CharMap, MapSeg, 320, 200, 0, 0, Palette);
     close(f);
end;

procedure TCharSet.PrintChar(x, y : word; c: char; where : word);
var i, j, sx, scroff, mapoff : word;
begin
     sx := Info.SizeX;
     scroff := YOffset[y] + x;
     mapoff := YOffset[Info.Chars[c].y + 1] + Info.Chars[c].x + 1;
     for j := 2 to Info.SizeY do
     begin
          for i := 2 to sx do
          begin
               if mem[MapSeg:mapoff] <> 0 then
                  mem[where:scroff] := mem[MapSeg:mapoff];
               inc(scroff);
               inc(mapoff);
          end;
          inc(scroff, 321);
          dec(scroff, sx);
          inc(mapoff, 321);
          dec(mapoff, sx);
     end;
end;

procedure TCharSet.PrintString(x, y : word; s : string; hs : integer; where : word);
var i, xx : word;
begin
     xx := x;
     for i := 1 to length(s) do
     begin
          PrintChar(xx, y, s[i], where);
          inc(xx, Info.SizeX);
          inc(xx, hs);
     end;
end;

procedure TCharSet.AddText(x, y : word; s : string; hs : integer);
var temp : PTTextInfo;
begin
     temp := new(PTTextInfo, Init(x, y, s, hs));
     temp^.next := AllText;
     AllText := temp;
end;

procedure TCharSet.ClearText;
begin
     if AllText <> nil then dispose(AllText, Done);
     AllText := nil;
end;

procedure TCharSet.PrintAll(where : word);
var temp : PTTextInfo;
begin
     temp := AllText;
     while temp <> nil do
     begin
          PrintString(temp^.x, temp^.y, temp^.txt, temp^.hs, where);
          temp := temp^.next;
     end;
end;

end.
