

#include <conio.h>
#include <dos.h>
#include <stdlib.h>

#include "irq.h"
#include "vbl.h"

//

extern "C" void interrupt timer_interrupt();
extern "C" void interrupt keyb_interrupt();
extern "C" void music_dummy();
extern "C" void getpal(char[768]);
extern "C" void setpal(char[768]);

//

extern "C"  {

void far*   oldKeybHandler;
void far*   oldTimerHandler;
char        oldPal[768];
int         oldRowsNum;

int         VBLCount    = 0;
int         MusicCount  = 0;
int         SystemCount = 0;
int         VBLTick     = 0;
int         MusicTick   = 0;
int         VBLInitFlag = 0;
int         VBLPalFlag  = 0;
int         GModeChanged = 0;

int         VBLPeriod;
int         MusicPeriod = 1193180/1;     // Default music calling 1 Hz.
int         NextTimerInt;

void        (*MusicHandler)() = music_dummy;
char        VBLPal[768];

int         FadeCount;                  // 0 when fading is not active
int         FadeValues[768];
int         FadeAddValues[768];

            }


//

int
esc_pressed()
{
        return (inp(0x60) == 1);
}

//

int
space_pressed()
{
        return (inp(0x60) == 0x39);
}

//

void
waitVBL(int frames)
{
        while (frames-- > 0)
            waitVBL();
}

//

void
fix_BIOSKeyb()
{
        int* p = (int*) 0x417;

        *p = (*p) & 0xfffffcf0;
}

//

void
init_gmodes()
{
        union   REGS    r;

        r.x.eax = 0x1130;
        r.x.ebx = 0;
        int386(0x10,&r,&r);
        oldRowsNum = (r.x.edx & 0xff);

}

//

void
close_gmodes()
{
        union   REGS    r;


        if (GModeChanged)
        {

            r.x.eax = 3;
            int386(0x10,&r,&r);


            if (oldRowsNum == 49)
            {
                for (int i = 0; i < 2; i++)
                {
                    r.x.eax = 0x1102;
                    r.x.ebx = i;
                    int386(0x10,&r,&r);

                    r.x.eax = 0x1112;
                    r.x.ebx = i;
                    int386(0x10,&r,&r);

                    r.x.eax = 0x1123;
                    r.x.ebx = 0;
                    r.x.edx = 50;
                    int386(0x10,&r,&r);
                }
            }
        }
}

//

void
init_VBL()
{

        if (!VBLInitFlag)
        {

            getpal(oldPal);

            memcopy(VBLPal,oldPal,768);

            init_gmodes();

            oldTimerHandler = irq_gethandler(0);
            oldKeybHandler  = irq_gethandler(1);

            irq_cli();

            irq_sethandler(0,timer_interrupt);
            irq_sethandler(1,keyb_interrupt);
            irq_enable(0);
            irq_enable(1);
            VBLInitFlag = 1;
            update_VBLperiod();

            irq_sti();

            atexit(&close_VBL);
        }

}

//

void
close_VBL()
{

        if (VBLInitFlag)
        {
            irq_cli();

            irq_sethandler(0,oldTimerHandler);
            irq_sethandler(1,oldKeybHandler);
            reset_timer();
            fix_BIOSKeyb();

            irq_sti();

            close_gmodes();

            setpal(oldPal);

        }

}

//

void
set_graphmode()
{

        union   REGS    r;


        GModeChanged = 1;

        r.x.eax = 0x13;
        int386(0x10,&r,&r);

        update_VBLperiod();

        // bla bla stuff :)

}

//




