
;
; Lousyplayer flat real mode version; interface part

; Player
;    The Edge / Cascada  <f94-hwa@nada.kth.se>
; Conversion and interface
;    Cyborg / Mistery    <cyborg@otitsun.oulu.fi>

;    Aurora Editor 2.0 recommended for this source viewing;
;    otherwise all lines containing "[fold]" can be deleted.
.386P


                HMEMREQUIRED    = 1200000       ; Bytes
                DSK_BUFFERSIZE  = 16384         ; Bytes (Min 4)
                STACKLEN        = 100h          ; Paragraphs


; [fold]  [
.MODEL TINY
.SEQ
.STACK STACKLEN*16
koodi           SEGMENT PARA PUBLIC USE16 'koodia'
                ASSUME CS:koodi,DS:koodi,ES:koodi,SS:koodi



; [fold]  ]

        FRM     = 1    ; Tell to MUSICA.ASM that this is flat real mode

INCLUDE FRM\utils.asm
INCLUDE FRM\frm.asm
INCLUDE KERNAL\musica.asm

; [fold]  [
Start:
        cld
        movseg  ds,cs
        mov     [PSPseg],es
        Prints  text1
        call    Check386
        call    GetMemory
        call    GoFlat
        call    EnableA20
        movseg  es,0
        movseg  fs,0
        mov     eax,cs
        shl     eax,4

        xor     ebx,ebx
        mov     bx,OFFSET FileBuffer
        add     eax,ebx
        mov     [AddrFileBuffer],eax
        call    CheckParams
        Prints  text_load
        mov     dx,O FileName
        call    ReadXM
        mov     [AddrModule],edi
        mov     eax,cs
        shl     eax,4
        sub     edi,eax
        mov     [SongPtr],edi
        call    InitGUS

        Prints  text_sinit
        movseg  es,cs
        mov     [SoundCard],Card_GUS
        call    init_card_
        mov     dx,o text_nogus
        cmp     eax,1
        je      Error
        mov     eax,[SongPtr]
        call    init_song_
        mov     dx,o text_notxm
        cmp     eax,1
        je      Error
        mov     dx,o text_badxm
        cmp     eax,2
        je      Error
        call    InitPlay
        call    start_song_

        Prints  text_play
        ;
PlayLoop:
        call    WaitVBL
        Prints  text_play1
        movzx   eax,[SongPos]
        call    PrintNum
        Prints  text_play2
        movzx   eax,[PattPos]
        call    PrintNum
        loopkey PlayLoop
        ;

        Prints  CR
        call    stop_song_
        call    ClosePlay
        movseg  es,0
        movseg  ds,cs
        call    ReleaseMem
        Exit    0


; [fold]  ]

; [fold]  [
Error:
        movseg  ds,cs
        mov     ah,09h
        int     21h
        call    ReleaseMem
        Exit    1

; [fold]  ]

; [fold]  [
; General texts
text1           db 79 dup ('')
                db 10,13
                db ' LousyPlayer/FRM (c) v1.20',13,10
                db ' Coded By the edge/CDA',13,10
                db ' FRM Conversion And Interface By Cyborg/Mistery',13,10,10,36

text_usage      db 'USAGE:',10,13
                db ' LP-FRM <xm filename>',13,10,36

text_load       db '.Loading module',13,10,36
text_sinit      db '.Initializing module',13,10,36

text_play       db 10,13,'Playing module. (Press a key to exit)',13,10,36

text_usegus     db 'GUS detected, forcing GF1 chipset usage.',13,10,36
text_nogus      db 'ERROR: GUS not detected.'
CR              db 13,10,36

text_nofile     db 'ERROR: File not found.',13,10,36
text_notxm      db 'ERROR: Unidentified songformat.',13,10,36
text_badxm      db 'ERROR: Corrupt XM or too old version.',13,10,36
text_badpar     db 'ERROR: Bad parameter.',13,10,36
text_missfile   db 'ERROR: File name missing.',13,10,36
text_setgus     db 'ERROR: ULTRASND environment variable not found.',13,10,36

text_play1      db '   ',13,' Position: $'
text_play2      db ' / $'

; [fold]  ]

; Checks parameters
; [fold]  [
CheckParams:
        movseg  es,ds
        mov     ds,[PSPseg]
        mov     si,80h         ; Start of parameters
        cld                    ; SI = current parameter pos
        lodsb
        movzx   cx,al          ; CX = characters left+1
        jcxz    Done
        lodsb

ParamLoop:

StripSpaces:                   ; Firstly strip trailing spaces 
        cmp     al,' '
        jne     NoSpace
        dec     cx
        jz      Done
        lodsb
        jmp     StripSpaces
NoSpace:
        cmp     al,'-'         ; Check if its parameter or filename 
        je      Param
        cmp     al,'/'
        je      Param
                        ; It was filename 
NoParam:
        mov     di,offset FileName
NameLoop:
        stosb
        dec     cx
        jz      NameRead
        lodsb
        cmp     al,' '
        jne     NameLoop
NameRead:
        shl     ax,8       ; move AL to AH and zero AL
        stosb              ; Add zero for ASCIIZ
        jcxz    Done
        mov     al,ah
        jmp     ParamLoop  ; Back to loop begin

Param:
        dec     cx      ; It was a parameter 
        jz      DisplayHelp
        lodsb
        cmp     al,'a'
        jb      NoLowCase
        cmp     al,'z'
        ja      NoLowCase
        sub     al,('a'-'A')    ; Convert to upper case
NoLowCase:
        cmp     al,'?'          ; Help
        je      DisplayHelp
        mov     dx,o text_badpar
        jmp     Error           ; Bad parameter

ParamDone:
        jcxz    Done
        lodsb
        dec     cx
        jnz     ParamLoop

Done:   mov     dx,o text_missfile
        cmp     byte ptr es:[Filename],0
        je      Error
        movseg  es,0
        movseg  ds,cs
        ret

DisplayHelp:            ; /? /H 
        push    ds
        movseg  ds,cs
        Prints  text_usage
        pop     ds
        jmp     ParamDone


; [fold]  ]

; In: DS:DX=name ofs; Out: EDI=flat address
; [fold]  [
ReadXM:
        call    OpenFile
        call    GetFileLen
        mov     edi,[HighFree]
        push    edi
        call    ReadFile
        mov     [HighFree],edi
        call    CloseFile
        pop     edi
        ret

; [fold]  ]

; Checks GUS from environment variable
; [fold]  [
InitGUS:
        mov     es,[PSPseg]
        mov     es,W es:[02ch]                  ; Environment segment
        xor     di,di
        xor     al,al
EnvLoop:
        cmp     es:[di],al
        je      NotFound
        mov     cx,(GUSenvSize)
        mov     si,offset GUSenv
        repe    cmpsb
        je      Found
        mov     cx,0ffffh
        repne   scasb
        jmp     EnvLoop
NotFound:
        mov     dx,o text_setgus
        jmp     Error
Found:
        movseg  ds,es   ; CX = 0
        movseg  es,cs
        mov     si,di
        mov     bp,16
        call    GetNum                          ; Port
        movzx   edi,di
        mov     es:[GUSBasePort],edi
        mov     bp,10
        call    GetNum                          ; Output DMA
        mov     es:[GUSDramDMA],edi
        call    GetNum                          ; Sampling DMA
        mov     es:[GUSAdcDMA],edi
        call    GetNum                          ; Main IRQ
        mov     es:[GUSGf1IRQ],edi
        call    GetNum                          ; Midi IRQ
        mov     es:[GUSMidiIRQ],edi
        movseg  ds,cs
        mov     eax,[GUSGf1IRQ]
        add     al,08h
        cmp     al,7+08h                        ; IRQ <= 7?
        jbe     LowIRQ
        add     al,70h-8-08h                    ; Its high IRQ
LowIRQ:
        mov     [GUSint],al
        ; 
        mov     ah,35h
        int     21h                             ; Get int vect
        mov     W [OldGUSint],bx
        mov     W [OldGUSint+2],es

        movseg  es,0
        movseg  ds,cs
        Prints  GUSfound1
        mov     eax,[GUSBasePort]
        call    PrintHex
        Prints  GUSfound2
        mov     eax,[GUSGf1IRQ]
        call    PrintNum
        Prints  GUSfound3
        ret

GUSenv          db      'ULTRASND='
GUSenvSize      = $ - offset GUSenv

GUSfound1       db      '.Ultrasound found, forcing GF1 usage at port: $'
GUSfound2       db      'h, IRQ: $'
GUSfound3       db      13,10,'$'

; [fold]  ]

; Initializes player and begins playing music
; [fold]  [
InitPlay:
        movseg  ds,cs           ; Install IRQ handler
        movseg  es,cs
        mov     ah,25h
        mov     al,es:[GUSint]
        mov     dx,o gus_interrupt_
        int     21h

        in      al,0A1h         ; Save old PIC mask
        mov     ah,al
        in      al,21h
        mov     [OldPICmask],ax
        mov     edx,[GUSBasePort]

        call    start_gusirq_

        mov     ax,[OldPICmask]
        mov     ecx,[GUSGf1IRQ] ; Enable GUS IRQ by PIC mask
        mov     dx,not 1
        rol     dx,cl
        and     ax,dx
        out     21h,al
        mov     al,ah
        out     0A1h,al

        mov     eax,[GUSGf1IRQ]
        cmp     al,7
        ja      HighIRQ
        or      al,60h
        out     20h,al
        jmp     IRQdone
HighIRQ:
        and     al,7
        or      al,60h
        out     0A0h,al
IRQdone:
        ret

; [fold]  ]

; Closes player, stops music playing
; [fold]  [
ClosePlay:
        mov     edx,[GUSBasePort]

        add     dx,103h
        mov     al,45h
        cli
        out     dx,al           ; 3x3  45h: select timer control reg
        add     dx,2
        xor     al,al
        out     dx,al           ; 3x5  0: disable timer IRQs

        add     dx,8h-105h
        mov     al,4
        out     dx,al           ; 2x8  4: 'timer stuff'
        inc     dx
        mov     al,10000000b
        out     dx,al           ; 2x9  1000.0000b: reset timer #1
        sti

        mov     ax,[OldPICmask]
        out     21h,al
        mov     al,ah
        out     0A1h,al

        mov     ah,25h          ; restore old interrupt vector
        mov     al,[GUSint]
        lds     dx,[OldGUSint]
        int     21h
        ret

; [fold]  ]

AddrModule      dd ?               ; Absolute address of loaded module
AddrFileBuffer  dd ?               ; Absolute address of FileBuffer

OldGUSint       dd ?               ; Old interrupt vector assigned to GUS int
OldPICMask      dw ?               ; Old Interrupt Control mask
GUSint          db ?               ; Interrupt number

PSPseg          dw ?               ; Segment for program segment prefix
Filename        db 0, 79 DUP (?)   ; Module filename in ASCIIZ
FileBuffer      db DSK_BUFFERSIZE DUP (?)

ENDS

END Start

; [fold]  9
