
;
; FLAT REAL MODE extender for raw/XMS
; by Cyborg / Mistery <cyborg@otitsun.oulu.fi>

; For all routines, CS=DS=data segment!

; Checks if there's a 386; fails and terminates program if not
; [fold]  [
Check386:
.8086
        push    sp              ; Check for 8086
        pop     ax
        cmp     ax,sp
        jne     NoA386

        pushf
        pushf                   ; Check for '286
        pop     ax
        or      ax,4000h
        push    ax
        popf
        pushf
        pop     ax
        popf
        test    ax,4000h
        jz      NoA386
        ret
NoA386:
        Prints  No386Str
        Exit    10

No386Str        db 'ERROR: 386 was not detected!',13,10,'$'
.386P

; [fold]  ]

; Gets memory as specified in MemNeeded variable
; [fold]  [
GetMemory:
        mov     ax,4300h
        int     2Fh
        cmp     al,80h
        jne     NoXMS
        Prints  XMSSupportStr
        mov     ax,4310h
        int     2Fh
        mov     W[XMSDriver],bx
        mov     W[XMSDriver+2],es

        mov     ah,09h                  ; Allocate XMS mem
        mov     dx,[MemNeeded]
        call    [XMSDriver]
        dec     ax
        jnz     AllocFailed
        mov     [XMSHandle],dx
        dec     [XMSMode]

        mov     ah,0Ch                  ; Locks XMS mem block
        call    [XMSDriver]
        dec     ax
        jnz     LockFailed
        mov     W[HighFree],bx
        mov     W[HighFree+2],dx

        mov     ah,03h                  ; Try to enable A20
        call    [XMSDriver]
        ret

AllocFailed:
        Prints  AllocFailedStr
        mov     ax,4C02h
        int     21h
        ret

LockFailed:
        Prints  LockFailedStr
        call    ReleaseMem
        mov     ax,4C03h
        int     21h

NoXMS:
        Prints  RawSupportStr
        mov     ah,88h
        int     15h
        cmp     [MemNeeded],ax
        ja      NotEnoughMem
        mov     [HighFree],100000h
        ret
NotEnoughMem:
        Prints  NotEnoughMemStr
        mov     ax,4C04h
        int     21h

NotEnoughMemStr db 'ERROR: Not enough extended memory!',13,10,'$'
AllocFailedStr  db 'ERROR: XMS memory allocation failed!',13,10,'$'
LockFailedStr   db 'ERROR: Unable to lock XMS block!',13,10,'$'

XMSSupportStr   db '.Using XMS memory allocation',13,10,'$'
RawSupportStr   db '.Using raw memory allocation',13,10,'$'

; [fold]  ]

; Releases memory which were allocated by GetMemory
; [fold]  [
ReleaseMem:
        cmp     [XMSMode],0
        je      RawRelease
        mov     ah,0Dh
        mov     dx,[XMSHandle]
        call    [XMSDriver]
        dec     ax
        jnz     UnLockFailed
BackUnLockFailed:
        mov     ah,0Ah
        mov     dx,[XMSHandle]

        call    [XMSDriver]
        dec     ax
        jnz     ReleaseFailed
RawRelease:
        ret
ReleaseFailed:
        Prints  ReleaseFailedStr
        ret
UnLockFailed:
        Prints  UnLockFailedStr
        jmp     BackUnLockFailed

ReleaseFailedStr db 'ERROR: Could not release XMS block!',13,10,'$'
UnLockFailedStr  db 'ERROR: Could not unlock XMS block!',13,10,'$'

; [fold]  ]

; Enables flat real mode; Returns DS=CS, destroys other segment registers
; [fold]  [
GoFlat:
        mov     eax,cs
        shl     eax,4
        add     [GDTRBase],eax
        mov     eax,cr0
        test    al,1
        jnz     V86Mode
        or      al,1
        lgdt    fword ptr [GDTRLimit]
        mov     bx,1 shl 3
        cli
        mov     cr0,eax
        mov     ds,bx
        mov     es,bx
        mov     fs,bx
        mov     gs,bx
        and     al,11111110b
        mov     cr0,eax
        sti
        movseg  ds,cs
        ret
V86Mode:
        Prints  V86Str
        call    ReleaseMem
        mov     ax,4C05h
        int     21h

GDTRLimit       dw 2*8-1
GDTRBase        dd O GDT-8

V86Str          db 13,10,'ERROR: Processor is in V86 mode!',13,10,'$'

GDT:            ; Flat data descriptor
                dw      0FFFFh          ; Limit 15..0
                dw      0               ; Base  15..0
                db      0               ; Base  23..16
                db      10010010b       ; P,DPL,E,W,A
                db      10001111b       ; G,B,Limit 19..16
                db      0               ; Base  31..24


; [fold]  ]

; Enables A20 line
; [fold]  [
EnableA20:                ; Currently supports only AT switch (no PS/2 etc)
        xor     ax,ax
        mov     es,ax
        dec     ax
        mov     fs,ax

        call    TestA20
        jz      Enabled
        call    WaitKb
        mov     al,0D1h
        out     64h,al
        call    WaitKb
        mov     al,0DFh
        out     60h,al
        xor     cx,cx           ; Wait at least 20s here
A20CheckLoop:
        call    TestA20
        jz      Enabled
        call    WaitOneTick
        loop    A20CheckLoop
        jmp     FatalA20error
Enabled:
        ret

; [fold]  [
WaitKb:         ; Modifies CX AL
        xor     cx,cx
WaitKbLoop:
        in      al,64h
        test    al,10b
        jz      WaitKbDone
        call    WaitOneTick
        loop    WaitKbLoop
        jmp     FatalKbError
WaitKbDone:
        ret

; [fold]  ]

; [fold]  [
WaitOneTick:    ; Waits at least 0.838s; Modifies AX
        mov     al,00000110b
        cli
        out     43h,al
        in      al,40h
        mov     ah,al
        in      al,40h
        sti
WaitLoop:
        mov     al,00000110b
        cli
        out     43h,al
        in      al,40h
        cmp     ah,al
        in      al,40h
        sti
        je      WaitLoop
        ret

; [fold]  ]

; [fold]  [
TestA20:        ; Modifies AX; In: ES=0; FS=0FFFFh; Out: ZF=1=A20 enabled
        mov     al,es:[0]
        mov     ah,al
        not     al
        cli
        xchg    al,fs:[10h]
        cmp     ah,es:[0]               ; Equals -> A20 enabled
        mov     fs:[10h],al
        sti
        ret

; [fold]  ]

; [fold]  [
FatalA20error:
        Prints  FatalA20errorStr
        mov     ax,4C01h
        int     21h

; [fold]  ]

; [fold]  [
FatalKbError:
        Prints  FatalKbErrorStr
        mov     ax,4C02h
        int     21h

; [fold]  ]

FatalA20errorStr db 'ERROR: A20 enabling was not succesful!',13,10,'$'
FatalKbErrorStr  db 'ERROR: Keyboard controller failure!',13,10,'$'


; [fold]  ]

ALIGN 4
XMSDriver       dd ?                            ; XMS driver call address
HighFree        dd ?                            ; First free byte in XMS mem
MemNeeded       dw (HMEMREQUIRED+1023)/1024     ; in kilobytes
XMSHandle       dw ?                            ; Allocated XMS block handle
XMSMode         db 0                            ; 0=rawmode; else XMSmode

; [fold]  10
