/* Generic BMP unit 
   31.1.1998:
   first version of this mighty library
       
   currently max 30 pics supported
   writen by MinMax
   */

#include "..\defs.h"
#include "..\params.h"
#include "picread.h"
#include "vos.h"
#include "fonts.h"
#include <fcntl.h>
#include <stdio.h>
typedef struct {
	byte   b,m;
	dword  bfSize;
	word   bfReserved1;
	word   bfReserved2;
	dword  bfOffBits;
		} BitmapFileHeader;

typedef struct {
	dword  biSize;
	dword  biWidth;
	dword  biHeight;
	word   biPlanes;
	word   biBitCount;
	dword  biCompression;
	dword  biSizeImage;
	dword  biXPelsPerMeter;
	dword  biYPelsPerMeter;
	dword  biClrUsed;
	dword  biClrImportant;
		} BitmapInfoHeader;


//int numpics=0;
//struct genpic picsa[MAXPICS];

int loadpic(const char *filename){ /* loads bmp picture from filename */
                                     /* returns pic's internal number */
	int fh,i;
	char name[30]="";
	int tmp=getpicnum(filename);
	if (tmp!=-1) {printf("Picture: %s already loaded\n",filename); return(tmp);}  
	if (numpics+1==MAXPICS) {printf("Too many pics loaded\n"); return(-1); };
    
	if ((fh=open(filename,O_BINARY|O_RDONLY))==-1) {printf("Picture file doesn't exist\n"); return (-1);};
	for (i=0;(i<strlen(filename))&&(filename[i]!='.');i++) { /* we want only filename without path & extension */
		char str[2]="a";
		if (filename[i]=='\\') {name[0]=0;} else {
			str[0]=filename[i];
			strcat(name,str);
		} 
	}
		//	debug("pic file opened sucessefully");
	strcpy(picsa[numpics].name,name);
	{ /* real reading starts here */

		BitmapFileHeader bfh;
		BitmapInfoHeader bih;
		byte BMPpal[1024];	
		//	char a[200];
		//	itoa(pics[numpics].pal16,a,10);
		//	Tdebug(a); 
	
		//	debug("getting ready to read bitmap file header");
		if (read(fh,&bfh,sizeof(bfh))==-1) return(-1);
		//	debug("getting ready to read bitmap info header");
		if (read(fh,&bih,sizeof(bih))==-1) return(-1);
		picsa[numpics].width=bih.biWidth;
		picsa[numpics].hight=bih.biHeight;

/*		printf("some debug data about picture: \n");
		printf("sizeof bfh: %i\n",sizeof(bfh)); 	
		printf("BM:%c%c \n",bfh.b,bfh.m);
		printf("bfSizeeee:%i \n",bfh.bfSize);
		printf("bfOffBits:%i \n",bfh.bfOffBits);
	
		
		debug("checking bitcount");
	*/	
		if (bih.biBitCount!=8) return (-1);
		//debug("EOK till end of bitcount");
	
		if ((picsa[numpics].data=(byte  *)malloc(bih.biWidth*bih.biHeight))==NULL) return(-1);
		//debug("picload2");
		lseek(fh,bfh.bfOffBits,SEEK_SET);
		read(fh,picsa[numpics].data,bih.biWidth*bih.biHeight); //read image data!
		if (dinfo) printf("Picture name: %s, number: %i (size: %i x %i) was loaded successefuly\n",picsa[numpics].name,numpics,picsa[numpics].width,picsa[numpics].hight); 
		lseek(fh,bih.biSize+sizeof(bfh),SEEK_SET);    //Pallete offset
		read(fh,&BMPpal,256*4); // bih.biClrUsed*4


		i=0;
		while (i<256) {
			byte r,g,b;
		
			b=picsa[numpics].pal[i*3]=BMPpal[i*4];
			g=picsa[numpics].pal[i*3+1]=BMPpal[i*4+1];
			r=picsa[numpics].pal[i*3+2]=BMPpal[i*4+2];
			picsa[numpics].pal16[i]=getcolor(r,g,b); /* precalcualte 8 to 16 bit colours */
			i++;       
		}
	}     
//	memset(pics[numpics].pal16,0,256*2);
//u	printf("Pic size: %ix%i\n", picsa[numpics].width,picsa[numpics].hight);
	close(fh);     
	return(numpics++);
}

putpic(word x, word y, int pin) {
/* puts pic to x,y */
 	int i,j;
// 	XWdebug("pic started2");
 	for(i=0;i<picsa[pin].width;i++) {
		for(j=0;j<picsa[pin].hight;j++) {
			//VOSputpixel(x+i,y+j,pics[pin].data[j*pics[pin].width+i]);
			VOSputpixel16(x+i,y+j,picsa[pin].pal16[picsa[pin].data[j*picsa[pin].width+i]]);

		}
	}
}   
word getpicwidth(int pin) { return (picsa[pin].width); } /* gets width of picture fin */
word getpichight(int pin) { return (picsa[pin].hight); } /* gets highth of picture fin */
   
void freepic() { /* frees ALL pics that are loaded */
	int i;
	for (i=0;i<numpics;i++) {
		free(picsa[i].data);
	}
	printf("All pics successefuly freed\n");
}

int getpicnum(const char *filename){  /* returns pic number */
	int i=0;
	char name[80]="";
	for (i=0;(i<strlen(filename))&&(filename[i]!='.');i++) { /* we want only filename without path & extension */
		char str[2]="a";
		if (filename[i]=='\\') {name[0]=0;} else {
			str[0]=filename[i];
			strcat(name,str);
		}
	}
	i=0;
	while ((i<numpics)&&(strcmpi(picsa[i].name,name)!=0)) i++;
	if (i==numpics) return(-1); else return (i);
}
