;=============================================================================
; ibmpc.inc - The IBM PC specific hardware definitions.
;
; Copyright (C) 1992-93, Dennis Marer               File created: 12/21/92
;                                                   Last modified: 1/27/93
;
; Description:
;  This file contains various equates and definitions specific to the
;  hardware found on IBM PC and compatible computers.  This includes:
;
;       8259 Programmable Interrupt Controller
;       8253 Programmable Interval Timer
;       8255 Programmable Peripheral Interface
;       8042 Slave Processor (incomplete)
;       General CMOS access (incomplete)
;
; Portability:
;  Requires Turbo Assembler 1.0 (TASM) or better to be assembled.
;  Dependent on the IBM PC 386 or better platform and its standard devices.
;
; Modifications:
;  DPM, 1/27/93 Finished the first revision of this file.
;=============================================================================



;-----------------------------------------------------------------------------
; DELAY - A macro used mostly to generate a small delay while talking to the
;  hardware.  This is not required on modern machines, but just in case....
;-----------------------------------------------------------------------------

DELAY           macro   unused                  ; Perform two nonsense jumps
                dw      0EBh,0EBh               ;   to create a delay
                endm



;============== The 8259 Programmable Interrupt Controller (PIC) =============



;-----------------------------------------------------------------------------
; The following defines the addresses of the primary and secondary 8259 PICs
;  in I/O space.  These are referred to PIC1 and PIC2, respectively.
;-----------------------------------------------------------------------------

PIC1_CMND       equ     020h                    ; PIC1 addresses
PIC1_DATA       equ     021h
PIC2_DATA       equ     0A1h                    ; PIC2 addresses
PIC2_CMND       equ     0A0h



;-----------------------------------------------------------------------------
; The following equates are used for the initialization and control of the
;  8259 PIC.  Initialization requires up to four Initialization Command
;  Words (ICWs), the first being written to the Command Port and the rest
;  being written to the Data Port.  These are referred to as ICW1 through
;  ICW4, and have the following format:
;
;       ICW1:   +----+----+----+----+----+----+----+----+
;               |A7  |A6  |A5  |1   |LITM|ADI |SNGL|ICW4|
;               +----+----+----+----+----+----+----+----+
;
;       ICW2:   +----+----+----+----+----+----+----+----+
;               |A15 |A14 |A13 |A12 |A11 |A10 |A9  |A8  | (MCS80/85 MODE)
;               |T7  |T6  |T5  |T4  |T3  |x   |x   |x   | (8086/88 MODE)
;               +----+----+----+----+----+----+----+----+ x = Don't care
;
;       ICW3:   +----+----+----+----+----+----+----+----+
;               |S7  |S6  |S5  |S4  |S3  |S2  |S1  |S0  | (Master device)
;               |0   |0   |0   |0   |0   |ID2 |ID1 |ID0 | (Slave device)
;               +----+----+----+----+----+----+----+----+
;
;       ICW4:   +----+----+----+----+----+----+----+----+
;               |0   |0   |0   |SFNM|BUF |M/S |AEOI|uPM |
;               +----+----+----+----+----+----+----+----+
;
; After initialization, the PIC can be commanded to operate in various modes
;  through the Operation Command Words (OCWs).  These take various forms.
;  OCW1, the interrupt mask register, is read from and written to the
;  Data Port directly.  It indicates inhibited (M=1) and enabled (M=0)
;  channels in the 8259 PIC.
;
;       OCW4:   +----+----+----+----+----+----+----+----+
;               |M7  |M6  |M5  |M4  |M3  |M2  |M1  |M0  |
;               +----+----+----+----+----+----+----+----+
;
; Both OCW2 and OCW3 are not used very much.  The equate PIC_EOI to signal
;  End Of Interrupt is defined, and at this time the only useful command.
;-----------------------------------------------------------------------------

ICW1_ICW4       equ     001h                    ; ICW4 (not) needed
ICW1_SINGLE     equ     002h                    ; Single (cascade) mode
ICW1_INTERVAL4  equ     004h                    ; Call address interval 4 (8)
ICW1_LEVEL      equ     008h                    ; Level triggered (edge) mode
ICW1_INIT       equ     010h                    ; Initialization - required!

ICW4_8086       equ     001h                    ; 8086/88 (MCS-80/85) mode
ICW4_AUTO       equ     002h                    ; Auto (normal) EOI
ICW4_BUF_SLAVE  equ     008h                    ; Buffered mode/slave
ICW4_BUF_MASTER equ     00Ch                    ; Buffered mode/master
ICW4_SFNM       equ     010h                    ; Special fully nested (not)



;-----------------------------------------------------------------------------
; Now define some useful commands to be sent.
;-----------------------------------------------------------------------------

PIC_EOI         equ     020h                    ; End Of Interrupt



;================ The 8253 Programmable Interrupt Timer (PIT) ================



;-----------------------------------------------------------------------------
; The following equates define the addresses of the 8253 PIT in I/O space.
;-----------------------------------------------------------------------------

PIT_CNT0        equ     040h                    ; Counter 0 register
PIT_CNT1        equ     041h                    ; Counter 1 register
PIT_CNT2        equ     042h                    ; Counter 2 register
PIT_CMND        equ     043h                    ; PIT Command Port



;-----------------------------------------------------------------------------
; The following equates are used for the initialization and control of the
;  8253 PIT.  The control word written to the Command Port has the format:
;
;  Control: +----+----+----+----+----+----+----+----+
;               |SC1 |SC0 |RL1 |RL0 |M2  |M1  |M0  |BCD |
;               +----+----+----+----+----+----+----+----+
;
;-----------------------------------------------------------------------------

PIT_SC0         equ     040h                    ; Select counter 0
PIT_SC1         equ     080h                    ; Select counter 1
PIT_SC2         equ     0C0h                    ; Select counter 2

PIT_LATCH       equ     000h                    ; Counter latching procedure
PIT_LMSB        equ     020h                    ; Load MSB only
PIT_LLSB        equ     010h                    ; Load LSB only
PIT_LOAD        equ     030h                    ; Load LSB then MSB

PIT_TERMINAL    equ     000h                    ; Interrupt on terminal count
PIT_1SHOT       equ     002h                    ; Programmable one-shot
PIT_RATE        equ     004h                    ; Rate generator
PIT_SQUARE      equ     006h                    ; Square wave rate generator
PIT_SWSTROBE    equ     008h                    ; Software triggered strobe
PIT_HWSTROBE    equ     00Ah                    ; Hardware triggered strobe

PIT_BCD         equ     001h                    ; Use BCD (binary)



;============= The 8255 Programmable Peripheral Interface (PPI) ==============



;-----------------------------------------------------------------------------
; The following equates define the addresses of the 8255 PPI in I/O space.
;-----------------------------------------------------------------------------

PPI_A           equ     060h
PPI_B           equ     061h
PPI_C           equ     062h
PPI_CMND        equ     063h



;-----------------------------------------------------------------------------
; The following equates are used for the initialization and control of the
;  8255 PPI.  The control word written to the Command Port has the format:
;
;  Control: +----+----+----+----+----+----+----+----+
;               |1   |MB1 |MB0 |A   |C HI|MA  |B   |C LO| (Mode set)
;               |0   |x   |x   |x   |B2  |B1  |B0  |SET | (Bit set/reset)
;               +----+----+----+----+----+----+----+----+ x = Don't care
;
;-----------------------------------------------------------------------------

PPI_A_IN        equ     010h                    ; Port A input (output)
PPI_B_IN        equ     002h                    ; Port B input (output)
PPI_CLO_IN      equ     001h                    ; Port C lower input (output)
PPI_CHI_IN      equ     008h                    ; Port C upper input (output)

PPI_B_BASIC     equ     000h                    ; Group B basic mode
PPI_B_STROBED   equ     004h                    ; Group B strobed mode

PPI_A_BASIC     equ     000h                    ; Group A basic mode
PPI_A_STROBED   equ     020h                    ; Group A strobed mode
PPI_A_BD_BUS    equ     040h                    ; Group A bi-directional bus

PPI_MODESET     equ     080h                    ; Required to set mode



;===================== The 8042 Slave Processor (SP) =========================



;-----------------------------------------------------------------------------
; The following equates define the 8042 slave processor (SP) addresses.
;  This section is incomplete due to lack of documentation.
;-----------------------------------------------------------------------------

SP_PORT_A       equ     060h                    ; Port A
SP_STATUS       equ     064h                    ; Status port



;-----------------------------------------------------------------------------
; The following equates are 8042 slave processor (SP) commands.  This section
;  is incomplete due to lack of documentation.
;-----------------------------------------------------------------------------

SP_WRITE_OUTPUT equ     0D1h                    ; Write output port
SP_DISABLE_A20  equ     0DDh                    ; De-gate A20
SP_ENABLE_A20   equ     0DFh                    ; Gate A20
SP_SHUTDOWN     equ     0FEh                    ; Shut down AT
SP_BUFFER_FULL  equ     002h                    ; Buffer is full


;================================== CMOS =====================================



;-----------------------------------------------------------------------------
; The following equates are CMOS addresses.  This section is incomplete due
;  to lack of documentation.
;-----------------------------------------------------------------------------

CMOS_PORT       equ     070h



;-----------------------------------------------------------------------------
; The following equates are CMOS commands.  This section is incomplete due to
;  lack of documentation.
;-----------------------------------------------------------------------------

CMOS_SHUTDOWN   equ     00Fh
