
_strcpy:
strcpy             PROC  NEAR
comment #
input: eax - destination pointer
       edx - source pointer
output: eax - points to 0 at the end of destination
#

                   PUSH  EBX
                   PUSH  EDX
@@Lp:              MOV   BL,[EDX]
                   MOV   [EAX],BL
                   OR    BL,BL
                   JZ    @@Done
                   INC   EAX
                   INC   EDX
                   JMP   @@Lp
@@Done:
                   POP   EDX
                   POP   EBX
                   RET
strcpy             ENDP

_strncpy:
strncpy            PROC  NEAR
comment #
input: eax - destination pointer
       edx - source pointer
       ecx - count
output: eax - points to 0 at the end of destination, or after last char
              copied to destination
#
                   PUSH  EBX
                   PUSH  ECX
                   PUSH  EDX
@@Lp:              OR    ECX,ECX
                   JZ    @@Done
                   MOV   BL,[EDX]
                   MOV   [EAX],BL
                   OR    BL,BL
                   JZ    @@Done
                   DEC   ECX
                   INC   EAX
                   INC   EDX
                   JMP   @@Lp
@@Done:
                   POP   EDX
                   POP   ECX
                   POP   EBX
                   RET
strncpy            ENDP

_strlen:
strlen             PROC  NEAR
comment #
input: eax - pointer to string
output: eax - length of string (excluding terminating 0)
#
                   PUSH  ECX
                   XOR   ECX,ECX
@@Lp:              CMP   B [EAX],0
                   JZ    @@Done
                   INC   ECX
                   INC   EAX
                   JMP   @@Lp
@@Done:            MOV   EAX,ECX
                   POP   ECX
                   RET
strlen             ENDP

_strcat:
strcat             PROC  NEAR
comment #
input: eax - destination pointer, string to append at
       edx - source pointer
output: eax - points to 0 at the end of destination
#

                   PUSH  EBX
                   PUSH  EDX
; 1 lets find the end of desting string
@@IsZero:          CMP   B [EAX],0
                   JZ    @@Lp
                   INC   EAX
                   JMP   @@IsZero
@@Lp:              MOV   BL,[EDX]
                   MOV   [EAX],BL
                   OR    BL,BL
                   JZ    @@Done
                   INC   EAX
                   INC   EDX
                   JMP   @@Lp
@@Done:
                   POP   EDX
                   POP   EBX
                   RET
strcat             ENDP

_strupr:
strupr             PROC  NEAR
comment #
input: EAX - pointer to string
output: EAX - the same pointer
#
                   PUSH  EAX
@@Lp:              CMP   B[EAX],0
                   JZ    @@Done
                   CMP   B[EAX],'a'
                   JB    @@Skip
                   CMP   B[EAX],'z'
                   JA    @@Skip
                   SUB   B[EAX],20H
                   INC   EAX
                   JMP   SHORT @@Lp
@@Done:
                   POP   EAX
                   RET
strupr             ENDP

_strlwr:
strlwr             PROC  NEAR
comment #
input: EAX - pointer to string
output: EAX - the same pointer
#
                   PUSH  EAX
@@Lp:              CMP   B[EAX],0
                   JZ    @@Done
                   CMP   B[EAX],'A'
                   JB    @@Skip
                   CMP   B[EAX],'Z'
                   JA    @@Skip
                   ADD   B[EAX],20H
                   INC   EAX
                   JMP   SHORT @@Lp
@@Done:
                   POP   EAX
                   RET
strlwr             ENDP

