;****************************************************************************
; Filename: FWRITE.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.Aug.11
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: int @fwrite(char *storage, int size, int count, FILE *fileptr);
;  Comment: writes bytes to file stream
;    Input: Eax = pointer of data to write
;           Edx = size of elements
;           Ecx = number of elements read
;         [Esp] = pointer of opened file stream
;   Output: Eax = number of elements written.
;****************************************************************************

        Include STDDEF.INC


        Codeseg


Proc    fwrite, 4
        Push    Edi
        Push    Esi
        Mov     Edi,[Esp+12]            ; get file ptr
        Push    Edx                     ; save element size
        Mov     [source],Eax       ; Save writing address
        Imul    Ecx,Edx
        Mov     Esi,Ecx
        Push    Esi                     ; save bytes to write

;        Test    [Edi+FILE._mode],2          ; Error if not writable
;        Jz      @@Finished
;        And     [Edi+FILE._mode],NOT 1      ; clear readable flag

;        Cmp     Esi, [Edi+FILE._buffersize]
;        jae     _NoUpdate
;        Mov     Eax, [Edi+FILE._position]
;        Cmp     Eax, [Edi+FILE._size]
;        Jne     _SkipUpdate



;_SkipUpdate:


        Cmp     [Edi+FILE._position], 0
        Je     _NoMemcpy

        Mov     Eax,Edi
        call    @fflush
        Cmp     Eax,EOF
        Je      @@Finished


;        Mov     Eax, [Edi+FILE._position]
;        Mov     Ecx, [Edi+FILE._buffersize]
;        Sub     Ecx, Eax
;        Ja     _NoMemcpy


;        Cmp     Ecx,Esi
;        Jb      _J99
;        Mov     Ecx,Esi
;_J99:
 ;       Jecxz   _NoMemcpy
 ;       Add     Eax, [Edi+FILE._base]
 ;       Mov     Edx,[source]
 ;       Add     [source],Ecx
 ;       Add     [Edi+FILE._position],Ecx
 ;       Sub     Esi,Ecx
;        Call    @memcpy
;        Test    Esi,Esi
;        Jz      @@Finished

_NoMemcpy:
        Mov     Ax, [Edi+FILE._handle]
        Mov     Edx,[source]
        Mov     Ecx,Esi
        Call    @write
        Cmp     Eax,-1
        Je @@Finished
        Sub     Esi,Eax

@@Finished:
        Pop     Eax                 ; Get bytes to written
        Pop     Ecx                 ; Get element size
        Sub     Eax,Esi
        Clear   Edx
        div     Ecx                 ; Calc number of items read.
        Pop     Esi
        Pop     Edi
        Ret

    Align 4
source     DD ?

Endp



        End
