;******************************************************************************
; Filename: WRITE.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1994.06.05
;  Updated: 1994.09.20
;******************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;******************************************************************************
; Function: LONG @write(LONG handle,PVOID buf,LONG len)
;  Comment: Writes data to a file
;    Input: Eax, handle - file handle
;           Edx, buf - pointer to write buffer
;           Ecx, len - length of block to write in bytes
;  Returns: The number of bytes actualy written or -1 if an error occured.
;******************************************************************************

        Include STDDEF.INC

        Codeseg

Proc    write ,3
                Push    Ebx,Edi,Esi
                Mov     Ebx,Eax
                Mov     Ah,40h
                Int     21h
                Jc      @@Error
                Pop     Esi,Edi,Ebx
                Ret
        Align   4
@@Error:        Mov     [Word errno],Ax
        Ifdef   DEBUG
                Call    printf,Offset ErrWriteMsg,Bx,Ax
        Endif
                Mov     Eax,-1
                Pop     Esi,Edi,Ebx
                Ret
Endp

        Dataseg

        IfDef   DEBUG
ErrWriteMsg     Db      "Error writing file with handle %h! Error: %h",LF,0
        Endif

        End
