;******************************************************************************
; Filename: FLENGTH.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1994.09.04
;  Updated: 1995.03.10 PA - Changed to the _fastcall convention
;           1995.03.12 PA - Changed the name from fsize to filelength
;******************************************************************************
; Copyright Adam Seychell, 1994.
; All rights reserved.
;******************************************************************************
; Function: LONG @filelength(LONG handle)
;  Comment: Returns the length of a file in bytes
;    Input: Eax, handle - file handle
;  Returns: file size or -1 if an error occured
;******************************************************************************
        Include STDDEF.INC

        Codeseg

Proc    filelength ,1
                Push    Ebx
                Mov     Ebx,Eax
                Mov     Ax,4200h+SEEK_CUR       ; Get current file position
                Clear   Edx
                Int     21h
                Jc      @@Error
                Push    Eax
                Mov     Ax,4200h+SEEK_END       ; Go to end of file position
                Int     21h
                Pop     Edx
                Push    Eax
                Mov     Ax,4200h+SEEK_SET       ; Return to original position
                Int     21h
                Pop     Eax
                Pop     Ebx
                Ret
        Align   4
@@Error:        Mov     [Word errno],Ax
        IfDef   DEBUG
                Call    printf,Offset ErrSizeMsg,Bx,Ax
        Endif
                Pop     Ebx
                Mov     Eax,-1
                Ret
Endp

        Dataseg

        IfDef   DEBUG
ErrSizeMsg      Db      "Error getting file size with handle %h! Error: %h",LF,0
        Endif

        End
