/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#ifndef __dj_include_crt0_h_
#define __dj_include_crt0_h_

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __dj_ENFORCE_ANSI_FREESTANDING

#ifndef __STRICT_ANSI__

#ifndef _POSIX_SOURCE

/*****************************************************************************\
 * crt0.h - specific to dos32 applications, controls command line
 * argument creation.
\*****************************************************************************/

/*****************************************************************************\
 * If the application wishes to provide a wildcard expansion function,
 * it should define a __crt0_glob_function function.  It should return
 * a list of the expanded values, or 0 if no expansion will occur.
 * The startup code will free the returned pointer if it is nonzero.
 *
 * If no expander function is provided, wildcards will be expanded in
 * the POSIX.1 style.  To disable expansion, provide a __crt0_glob_function
 * that always returns 0.
 *
 * Applications that do not rely on environment variables can provide an
 * alternate version of __crt0_load_environment_file that does nothing.
 *
 * Applications that do not rely on arguments passed to main() can
 * provide an alternate version of __crt0_setup_arguments() that does
 * nothing.
\*****************************************************************************/

extern char  *__dos_argv0;
extern int    __crt0_argc;
extern char **__crt0_argv;

void   __crt0_load_environment_file(char *_app_name);
void   __crt0_setup_arguments(void);
char **__crt0_glob_function(char *_arg);

/*****************************************************************************\
 *
 *  To set any of these startup flags, add the following declaration to
 *  *your* source code:
 *   
 *	int _crt0_startup_flags = _CRT0_FLAG_* | _CRT0_FLAG_*;
 *  
 *  The default is all flags off.
 *
\*****************************************************************************/

extern int _crt0_startup_flags;
/* see _CRT0_FLAG_ALLOC_MEM_CONTAINS_MIN for details */
extern int _crt0_alloc_mem;
/* contains the dma buffers alloced at startup */
extern char _crt0_alloc_dma;

/* If set, argv[0] is left in whatever case it was.  If not set, all
** characters are mapped to lower case.  Note that if the argv0 field in
** the stubinfo structure is present, the case of that part of argv0 is not
** affected. 
*/
#define _CRT0_FLAG_PRESERVE_UPPER_CASE		0x0001

/* If set, reverse slashes (dos-style) are preserved in argv[0].  If not
** set, all reverse slashes are replaced with unix-style slashes.
*/
#define _CRT0_FLAG_USE_DOS_SLASHES		0x0002

/* If set, the .EXE suffix is removed from the file name component of
** argv[0].  If not set, the suffix remains. 
*/
#define _CRT0_FLAG_DROP_EXE_SUFFIX		0x0004

/* If set, the drive specifier (ex: `C:') is removed from the beginning of
** argv[0] (if present).  If not set, the drive specifier remains. 
*/
#define _CRT0_FLAG_DROP_DRIVE_SPECIFIER	0x0008

/* If set, response files (ex: @gcc.rf) are not expanded.  If not set, the
** contents of the response files are used to create arguments.  Note that
** if the file does not exist, that argument remains unexpanded. 
*/
#define _CRT0_FLAG_DISALLOW_RESPONSE_FILES	0x0010

/* fill all alloced memory upon the start
** - do we really need such stuff ? cl.
*/
#define _CRT0_FLAG_FILL_MEMORY 0x0020

/* If set, fill memory (above) with 0xdeadbeef, else fill with zero.
** This is especially useful for debugging uninitialized memory problems.
** - at my opinion useless, cl.
*/
#define _CRT0_FLAG_FILL_DEADBEEF		0x0040


/* If set, disable usage of long file name functions even on systems
** (such as Win95) which support them.  This might be needed to work
** around program assumptions on file name format on programs written
** specifically for DOS.
*/
#define _CRT0_FLAG_NO_LFN			0x0400

/* don't install any exception handler, just rely on dos32 */
#define _CRT0_FLAG_NO_EXCEPTION_AT_ALL  0x0800

/* don't install exception handler 8, due to the slowdown */
#define _CRT0_FLAG_NO_EXCEPTION_8       0x1000

/* defines how _crt0_alloc_mem is interpreted:
   if set it contains the amount memory which is alloced by the program
   (WARNING: in this case _crt0_alloc_mem should be > than 32 kB otherwise
    the prog will abort/crash)
   if not set it contains the amount memory which must remain free */
#define _CRT0_FLAG_ALLOC_MEM_CONTAINS_MIN 0x2000

/* just graps all mem aviable - only one alloc call is used
   use this if you get trouble when running the dos32 prog under
   go32 (p.e. stubify called by make)
   no memsize testing is made */
#define _CRT0_FLAG_GRAP_ALL_MEM 0x4000



#endif /* !_POSIX_SOURCE */
#endif /* !__STRICT_ANSI__ */
#endif /* !__dj_ENFORCE_ANSI_FREESTANDING */

#ifndef __dj_ENFORCE_FUNCTION_CALLS
#endif /* !__dj_ENFORCE_FUNCTION_CALLS */

#ifdef __cplusplus
}
#endif

#endif /* !__dj_include_crt0_h_ */
