#include "bfd.h"
#include "sysdep.h"
#include "libbfd.h"
#include "dos32.h"
#define  STDSTACK  0x10000U /* 64 kB */
#define  USABLE_SECTION (SEC_ALLOC | SEC_HAS_CONTENTS)
#define  HDRSIZE dos32_header_size
#define  SECTIONEND(s) s->vma+s->_raw_size
/*#define  DEBUGIT*/

typedef struct fd {
dos32_header *d32_file_header;
unsigned long stacksize;
unsigned long alloc_for_d32;
unsigned long data_written;
long seek_cache;
} i386dos32_file_data;

long forced_stack_size = 0;

static void noswap()
BFD_FAIL()

/* writes the updated header */
boolean i386dos32_close_and_cleanup(bfd *abfd)
{
   i386dos32_file_data *info;
   sec_ptr asection;
   info=(i386dos32_file_data *)abfd->tdata.any;
   if (!abfd->output_has_begun) return 0;
   /* minimum alloc must be the image size written */
   /* bss is always align 16 */
   info->alloc_for_d32=(info->data_written+15) & 0xFFFFFFF0;
   #ifdef DEBUGIT
     printf("alloc: %d\n",info->alloc_for_d32);
   #endif
   /* gather sizes of all bss & stack sections */
   for (asection=abfd->sections,info->stacksize=0;asection!=(sec_ptr)NULL;
        asection=asection->next)
   {
      if (!strcmp(asection->name,".stack"))   /* is it the stack ? */
                   info->stacksize+=asection->_raw_size;
      else if ((asection->flags & SEC_ALLOC) &&
               (info->alloc_for_d32<SECTIONEND(asection)))
                        info->alloc_for_d32=SECTIONEND(asection);
   }
   #ifdef DEBUGIT
   printf("[i386-dos32] closing & final header (size:%d) in %s\n",HDRSIZE,abfd->filename);
   printf("alloc: %d\n",info->alloc_for_d32);
   #endif
   /* update header */
   if (!info->stacksize) info->stacksize=STDSTACK;
   if (forced_stack_size) info->stacksize=forced_stack_size;
   /* now stack addition + align */
   info->alloc_for_d32=(info->alloc_for_d32+info->stacksize+15) & 0xFFFFFFF0;
   #ifdef DEBUGIT
     printf("alloc: %d\n",info->alloc_for_d32);
   #endif
   info->d32_file_header->exe_length=info->data_written+HDRSIZE;
   info->d32_file_header->image_length=info->data_written;
   info->d32_file_header->initial_memory=info->alloc_for_d32;
   info->d32_file_header->start_esp=info->alloc_for_d32; /*stack behind bss*/
   info->d32_file_header->start_eip=abfd->start_address;
   #ifdef DEBUGIT
     printf("Header info:  image length: %08x\n",
                                info->d32_file_header->image_length);
     printf(" eip: %08x  esp: %08x allocmem: %08x\n",
           info->d32_file_header->start_eip,
           info->d32_file_header->start_esp,
           info->d32_file_header->initial_memory);
   #endif
   if (bfd_seek(abfd,0,SEEK_SET)) return false;
   if (bfd_write((char *)info->d32_file_header,1,HDRSIZE,abfd)!=HDRSIZE)
        return false;
   free(info->d32_file_header);
   free(info);
   return _bfd_generic_close_and_cleanup(abfd);
}

#define i386dos32_bfd_free_cached_info _bfd_generic_bfd_free_cached_info
#define i386dos32_new_section_hook _bfd_generic_new_section_hook

#define i386dos32_get_section_contents \
_bfd_generic_get_section_contents

boolean i386dos32_set_section_contents(bfd *abfd,sec_ptr the_section,
        void *buf,file_ptr where,bfd_size_type size)
{
    i386dos32_file_data *info=(i386dos32_file_data *)abfd->tdata.any;
    int dummy=0;
    #ifdef DEBUGIT
    printf("[i386-dos32] section %s no. %d of %s at %x, size: %x\n",
         the_section->name,the_section->index,the_section->owner->filename,
         where,size);
    #endif
    if ((the_section->flags & USABLE_SECTION)==USABLE_SECTION)
    {
        long section_position=the_section->vma+where+HDRSIZE;
        if (info->seek_cache!=section_position)
              dummy = bfd_seek(abfd,section_position,SEEK_SET);
        if (bfd_write((char *)buf,1,size,abfd)!=size)
        {
          ++dummy;
          info->seek_cache=-1;
        }
        else info->seek_cache=section_position+size;
        if (info->data_written<SECTIONEND(the_section))
                             info->data_written=SECTIONEND(the_section);
    }
    #ifdef DEBUGIT
      printf("[i386-dos32] write result: %d\n",dummy);
    #endif
    return dummy==0; /* debugging, stack, bss stuff is just skipped */
    /* WARNING: THIS WILL CAUSE TROUBLE IF BSS & STACK ARE NOT AT THE
       END OF THE PROGRAM ! */
}

/* stolen from srec.c */
boolean
i386dos32_set_arch_mach (abfd, arch, machine)
     bfd *abfd;
     enum bfd_architecture arch;
     unsigned long machine;
{
  return bfd_default_set_arch_mach (abfd, arch, machine);
}

int i386dos32_sizeof_headers(bfd *abfd,boolean exec)
{
    return 0;
}
#define i386dos32_bfd_get_relocated_section_contents \
  bfd_generic_get_relocated_section_contents
#define i386dos32_bfd_relax_section bfd_generic_relax_section
#define i386dos32_bfd_link_hash_table_create _bfd_generic_link_hash_table_create
#define i386dos32_bfd_link_add_symbols _bfd_generic_link_add_symbols
#define i386dos32_bfd_final_link _bfd_generic_final_link


/*  write the dos32 header */
boolean i386dos32_bfd_set_format(bfd *abfd)
{
   dos32_header *dummy=(dos32_header *)malloc(HDRSIZE);
   i386dos32_file_data *dummy2=
                   (i386dos32_file_data *)malloc(sizeof(i386dos32_file_data));
   #ifdef DEBUGIT
   printf("[i386-dos32] open %s\n",abfd->filename);
   #endif
   if (dummy == NULL || dummy2 == NULL) return false;
   dummy->dos32_id=dos32_header_id;      /*     "Adam", little endian */
   dummy->fixup_entries=0;    /* selector relocs not supported by bfd */
   dummy->dlink_version=0x9999;          /* this is ultra - dlink     */
   dummy->exe_flags=0;                   /* no flags                  */
   dummy->minimum_dos32_version=0x0330;  /* running on 3.3 & better   */
   dummy->exe_start=HDRSIZE;       /* image starts right after header */
   dummy2->d32_file_header=dummy;
/*  dummy2->stacksize=0;   not here */
   dummy2->alloc_for_d32=0;
   dummy2->data_written=0;
   dummy2->seek_cache=-1;
/* if (bfd_write((char *)dummy,1,HDRSIZE,abfd)!=HDRSIZE) return false; */
   abfd->tdata.any=(void *)dummy2;
   return true;
}

boolean i386dos32_bfd_write_contents(bfd *abfd)
{
    i386dos32_file_data *dummy = (i386dos32_file_data *)abfd->tdata.any;
    #ifdef DEBUGIT
    printf("[i386-dos32] flushing %s\n",abfd->filename);
    #endif
    dummy->seek_cache= -1;
    return !bfd_flush(abfd);  /* flush */
}


#define i386dos32_get_symtab_upper_bound _bfd_nosymbols_get_symtab_upper_bound
#define i386dos32_get_symtab             _bfd_nosymbols_get_symtab

asymbol * i386dos32_make_empty_symbol (bfd *abfd)
{
  asymbol *new = (asymbol *) bfd_zalloc (abfd, sizeof (asymbol));
  if (new) new->the_bfd = abfd;
  return new;
}

#define i386dos32_print_symbol          _bfd_nosymbols_print_symbol
#define i386dos32_get_symbol_info       _bfd_nosymbols_get_symbol_info
#define i386dos32_bfd_is_local_label    _bfd_nosymbols_bfd_is_local_label
#define i386dos32_get_lineno            _bfd_nosymbols_get_lineno
#define i386dos32_find_nearest_line     _bfd_nosymbols_find_nearest_line
#define i386dos32_bfd_make_debug_symbol _bfd_nosymbols_bfd_make_debug_symbol


bfd_target i386dos32_vec =
{
   "i386-dos32",
   bfd_target_unknown_flavour,
   false,
   false,
   EXEC_P, /* that's all, notice: no relocation entries */
   SEC_ALLOC | SEC_LOAD | SEC_CODE | SEC_DATA | SEC_HAS_CONTENTS
   | SEC_DATA | SEC_CODE | SEC_READONLY, /* needed ? */
   0,
   0,
   255,
   0, /* don't care ? */
#define swapfail1 ((bfd_vma (*) PARAMS ((const bfd_byte *))) noswap)
#define swapfail2 ((bfd_signed_vma (*) PARAMS ((const bfd_byte *))) noswap)
#define swapfail3 ((void (*) PARAMS ((bfd_vma, bfd_byte *))) noswap)
   swapfail1,swapfail2,swapfail3,
   swapfail1,swapfail2,swapfail3,
   swapfail1,swapfail2,swapfail3,
   swapfail1,swapfail2,swapfail3,
   swapfail1,swapfail2,swapfail3,
   swapfail1,swapfail2,swapfail3,
   {
      _bfd_dummy_target, /* we don't want to read the exe        */
      _bfd_dummy_target, /* perhaps sometimes I'll...            */
      _bfd_dummy_target, /* might be useful for a debugger       */
      _bfd_dummy_target,
   },
   {
      bfd_false,
      i386dos32_bfd_set_format, /* only creating a file is o.k. */
      bfd_false,
      bfd_false,
   },
   {
      bfd_false,
      i386dos32_bfd_write_contents, /* just a flush of iostream */
      bfd_false,
      bfd_false,
   },
     BFD_JUMP_TABLE_GENERIC(i386dos32),
     BFD_JUMP_TABLE_COPY(_bfd_generic),
     BFD_JUMP_TABLE_CORE(_bfd_nocore),
     BFD_JUMP_TABLE_ARCHIVE(_bfd_noarchive),
     BFD_JUMP_TABLE_SYMBOLS(i386dos32),
     BFD_JUMP_TABLE_RELOCS(_bfd_norelocs),
     BFD_JUMP_TABLE_WRITE(i386dos32),
     BFD_JUMP_TABLE_LINK(i386dos32),
     BFD_JUMP_TABLE_DYNAMIC(_bfd_nodynamic),
     NULL
};

void i386dos32_force_stack(long size)
{
    forced_stack_size=size;
}

