/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <stdio.h>
#include <string.h>
#include <sys/utsname.h>
#include <errno.h>
#include <dos32api.h>
#include <dos.h>

int uname(struct utsname *u)
{
  _dos32_regs r;
  unsigned short dos_version;

  if (!u)
  {
    errno = EFAULT;
    return -1;
  }

  dos_version = _get_dos_version(1);
  strncpy(u->sysname, _os_flavor, sizeof(u->sysname) - 1);
  u->sysname[sizeof(u->sysname) - 1] = '\0';
  sprintf(u->version, "%d", dos_version >> 8);
  sprintf(u->release, "%02d", dos_version & 0xff);
  strcpy(u->machine, "pc");

  r.eax = 0x5e00;
  r.ds  = __dos32_dos_buffer_seg;
  r.edx = 0;
  __dos32_call_realmode_int(0x21, &r,0);
  if ((r.flags & 1) || ((r.ecx & 0xff00) == 0))
    strcpy(u->nodename, "pc");
  else
  {
    int i = 8;
    memcpy(u->nodename,__dos32_dos_buffer,8);
    do {
      u->nodename[i--] = 0;
    } while (i && u->nodename[i] <= ' ');
  }
  return 0;
}
