/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <errno.h>
#include "dirstruc.h"

DIR *
opendir(const char *name)
{
  int length;
  DIR *dir = (DIR *)malloc(sizeof(DIR));
  if (dir == 0)
    return 0;
  dir->num_read = 0;
  dir->name = (char *)malloc(strlen(name)+6);
  if (dir->name == 0)
  {
    free(dir);
    return 0;
  }
  strcpy(dir->name, name);

  dir->flags = __opendir_flags;

  /* Append a "." if we got only the device name */
  if (dir->name[1] == ':' && dir->name[2] == 0)
  {
    dir->name[2] = '.';
    dir->name[3] = 0;
  }

  /* Strip trailing slashes, so we can append "/ *.*" */
  length = strlen(dir->name);
  while (1)
  {
    if (length == 0) break;
    length--;
    if (dir->name[length] == '/' ||
	dir->name[length] == '\\')
      dir->name[length] = '\0';
    else
    {
      length++;
      break;
    }
  }

  dir->name[length++] = '/';
  dir->name[length++] = '*';
  dir->name[length++] = '.';
  dir->name[length++] = '*';
  dir->name[length++] = 0;
  return dir;
}
