/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1994, 1995 Charles Sandmann (sandmann@clio.rice.edu)
   Exception handling and basis for signal support for DJGPP V2.0
   This software may be freely distributed, no warranty. */

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <signal.h>
#include <unistd.h>

typedef void (*SignalHandler) (int);

SignalHandler __dos32_timer_sig = 0;

SignalHandler
signal(int sig, SignalHandler func)
{
  SignalHandler temp;

  if (sig != SIGALRM) {
    fprintf(stderr,"Tried to set illegal signal %04x. Exiting.\n\
Sorry, but in this version of the gcc library for the DOS32 extender you can\n\
only set the signal SIGALRM.\n",sig);
    exit(1);
  }
  temp = __dos32_timer_sig;
  __dos32_timer_sig = func;
  return temp;
}

static const char signames[] = "ABRTFPE ILL SEGVTERMALRMHUP INT KILLPIPEQUITUSR1USR2NOFPTRAP";

int
raise(int sig)
{
  if(sig != SIGALRM) {
    fprintf(stderr,"Tried to raise illegal signal %04x",sig);
    if ((sig>=SIGABRT) && (sig<=SIGTRAP)) {
        fprintf(stderr," (SIG");
        _write(STDERR_FILENO,signames+(sig - SIGABRT)*4,4);
        fputc(')',stderr);
    }
    fprintf(stderr,". Exiting.\n\
Sorry, but in this version of the gcc library for the DOS32 extender you can \n\
only raise the signal SIGALRM.\n");
    exit(1);
  }
  if(__dos32_timer_sig == (SignalHandler)SIG_IGN)  return 0;      /* Ignore it */
  __dos32_timer_sig(sig);
  return 0;
}

