/*
 this file was changed or created for the DOS32 library for DJGPP on 21.9.1996
 new created files are copyright 1996 by C.Lageman, see docs.doc for details
*/
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */
/*
 * BIOSDISK.C.
 *
 * Modified by Peter Sulyok 1995 <sulyok@math.klte.hu>.
 *
 * This file is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 */
/*
 * WARNING: this version supports only read/writes of max. 16 (NOT 18 !)
 *          sector, 'cos the DOS 32 lowmem buffer is only 8K big
 *          (and I was too lazy to split into several int calls)
 *
 */

#include <libc/stubs.h>
#include <bios.h>
#include <dos32api.h>
#include <stdlib.h>


int
biosdisk(int cmd, int drive, int head, int track,
	 int sector, int nsects, void *buffer)
{
  int xfer=0, before=0;
  _dos32_regs r;
  switch (cmd)
  {
  case 2:
    xfer = 512 * nsects;
    before = 0;
    break;
  case 3:
    xfer = 512 * nsects;
    before = 1;
    break;
  case 5:
    xfer = 2 * 256;
    before = 1;
    break;
  case 0x0a:
    xfer = (512+7) * nsects;
    before = 0;
    break;
  case 0x0b:
    xfer = (512+7) * nsects;
    before = 1;
    break;
  case 0x0e:
    xfer = 512;
    before = 0;
    break;
  case 0x0f:
    xfer = 512;
    before = 1;
    break;
  }
  if (xfer)
  {
    if (xfer > 16*512)
      return 1;			/* bad command */
  }
  r.eax = (cmd<<8) + nsects;
  r.es  = __dos32_dos_buffer_seg;
  r.ebx = 0;
  r.ecx = ((track & 0xff) << 8) + ( sector | ((track >> 2) & 0xc0));
  r.edx = (head << 8) + drive;
  if (xfer && before)
    memcpy(__dos32_dos_buffer,buffer, xfer);
  __dos32_call_realmode_int(0x13, &r,0);
  if (xfer && !before)
    memcpy(buffer,__dos32_dos_buffer, xfer);
  if (cmd == 0x08)
  {
    ((short *)buffer)[0] = r.ecx;
    ((short *)buffer)[1] = r.edx;
  }
  return ((r.eax >>8) & 0xff);
}

unsigned 
_bios_disk(unsigned _cmd, struct diskinfo_t *_di)
{
  int xfer=0, before=0;
  _dos32_regs r;

  switch( _cmd )
  {
  case 2:
    xfer = 512 * _di->nsectors;
    before = 0;
    break;
  case 3:
    xfer = 512 * _di->nsectors;
    before = 1;
    break;
  case 5:
    xfer = 2 * 256;
    before = 1;
    break;
  }
  if (xfer)
  {
    if (xfer > 16*512)
      return 1;			/* bad command */
  }
  r.eax = (_cmd<<8) + _di->nsectors;
  r.es  = __dos32_dos_buffer_seg;
  r.ebx = 0;
  r.ecx = ((_di->track & 0xff)<<8) + (_di->sector | ((_di->track >> 2) & 0xc0));
  r.edx = (_di->head<<8) + _di->drive;
  if (xfer && before)
    memcpy(__dos32_dos_buffer,_di->buffer, xfer);
  __dos32_call_realmode_int(0x13, &r,0);
  if (xfer && !before)
    memcpy(_di->buffer,__dos32_dos_buffer, xfer);
  return ((r.eax>>8) & 0xff);
}
