/* EXAMPLE FILE: main.c
   by Alioth

   Well, this file should be pretty explanatory - it demonstrates the use of
   multiple key presses and needs a few delays in there because it's going
   too fast!
*/
#include <stdio.h>
#include <i86.h>   /* this is usually dos.h for other compilers */
#include <dos.h>
#include "keyb.h"

#define DELAY 1

void (_interrupt _far *OldTime)();
void (_interrupt _far NewTime)();

char far *vbuf = (char far *)0xA0000000L;
int starx[40], stary[40], starspeed[40];
char lett[] = { 00, 00, 18, 18, 18, 00, 00, 00,
                00, 18, 20, 20, 20, 18, 00, 00,
                18, 20, 22, 24, 22, 20, 18, 00,
                18, 20, 24, 26, 24, 20, 18, 00,
                18, 20, 22, 24, 22, 20, 18, 00,
                00, 18, 20, 20, 20, 18, 00, 00,
                00, 00, 18, 18, 18, 00, 00, 00,
                00, 00, 00, 00, 00, 00, 00, 00 };

/* I hate setting video mode this way just cos it looks ugly :) - inline ASM
   in Watcom is slightly non-portable */
void SetVidMode(unsigned mode)
{
   union REGS iregs, oregs;
   iregs.x.ax = mode;
   int86(0x10, &iregs, &oregs);
}

/* Originally named because the original sprite was the letter 'A'. This
   function simply draws an 8x8 block to the screen */
void PlaceLetter(int x, int y)
{
   int mx, my;

   for (my = 0; my < 8; my++)
      for (mx = 0; mx < 8; mx++)
         vbuf[((my + y) << 6) + ((my + y) << 8) + (mx + x)] = lett[(my << 3) + mx];
}

/* This little function places an 8x8 blank block at x, y */
void PlaceBlock(int x, int y)
{
   int mx, my;

   for (my = 0; my < 8; my++)
      for (mx = 0; mx < 8; mx++)
         vbuf[((my + y) << 6) + ((my + y) << 8) + (mx + x)] = 0;
}

void SetupStars(void)
{
    int x;

    OldTime = _dos_getvect(0x1C);   /* Find the old timer interrupt handler */
    _dos_setvect(0x1C, NewTime);    /* Replace it with new one */
    for (x = 0; x < 40; x++)
    {
       starx[x] = rand()%310;       /* Randomnly generate star attributes */
       stary[x] = rand()%190;
       starspeed[x] = rand()%5 + 1;
    }
}

void MoveStars(void)
{
   int x;

   for (x = 0; x < 40; x++)
   {
      /* Delete star */
      vbuf[(stary[x] << 6) + (stary[x] << 8) + starx[x]] = 0;
      /* Move star */
      starx[x] -= starspeed[x];
      /* Check if star is offscreen, if so put it on the other side */
      if (starx[x] < 0) starx[x] = 315;
      /* Redraw star */
      vbuf[(stary[x] << 6) + (stary[x] << 8) + starx[x]] = 15 + (starspeed[x] * 3);
   }
}

/* This function is called everytime the timer issues an interrupt 1Ch - this
   is every 18.2 times per second at default */
void _interrupt _far NewTime(void)
{
   MoveStars();
   /* Call the old timer interrupt because we do not want complete control
      because there's lots to rewrite if we did */
   OldTime();
}

void main(void)
{
   int x = 160, y = 100, modx = x, mody = x, count = 0;

   InitKeyboard();
   SetVidMode(0x13); /* 320x200x256 */
   SetupStars();
   PlaceLetter(x, y);
   while (!keytab[KEY_ESCAPE])
   {
      /* Check to see if a key is held down - if so, adjust co-ords */
      if (keytab[KEY_UPARROW] && y > 0) y--;
      if (keytab[KEY_DOWNARROW] && y < 191) y++;
      if (keytab[KEY_LEFTARROW] && x > 0) x--;
      if (keytab[KEY_RIGHTARROW] && x < 311) x++;
      /* Check to see if sprite position has changed */
      if (modx != x || mody != y)
      {
         /* Delete sprite at old position */
         PlaceBlock(modx, mody);
         /* Draw sprite at new position */
         PlaceLetter(x, y);
         /* Update old sprite co-ords with new co-ords */
         modx = x;
         mody = y;
         delay(DELAY);
      }
   }
   SetVidMode(0x03);
   RestoreKeyboard();
   _dos_setvect(0x1C, OldTime);
}
