	IDEAL
	MODEL tpascal
	SMART
	JUMPS
	MULTERRS
	LOCALS
	P8086

	INCLUDE "intrupt.inc"
CODESEG

	; Some vars
badoff		dw ?
old_int6	dd ?

;----------------------------------------------------------------------------
; int6 (bad opcode) handler - used for 80286 test
PROC int6_handler
int6_handler_start:			; Had to put in this label, BP7
					; wouldn't let me link this .obj
					; if I used
					;	mov ax, OFFSET int6_handler
					; so now it's
					;	mov ax, OFFSET int6_handler_start
	push    ax
	push    bp
	mov     ax, [badoff]		; New return address
	mov     bp, sp
	mov     [ss:bp+4], ax		; insert new return address
	pop     bp
	pop     ax
	iret
ENDP int6_handler

;----------------------------------------------------------------------------
; Restores default int6 (bad opcode) handler
PROC release_int6
	mov ax, 6h
	push ax
	les si, [cs:old_int6]
	push si
	push es
	call FAR release_RM_int_vector

	ret
ENDP release_int6

;----------------------------------------------------------------------------
; Hooks interrupt 6 (bad opcode) for use during 80286 test
PROC hook_int6
	mov ax, 6h
	push ax
	call FAR get_RM_int_vector
	mov [WORD PTR cs:old_int6], ax
	mov [WORD PTR cs:old_int6+2], dx

	mov ax, 6h
	push ax
	mov ax, OFFSET int6_handler_start
	push ax
	mov ax, SEG int6_handler
	push ax
	call FAR hook_RM_int_vector

	ret
ENDP hook_int6

;----------------------------------------------------------------------------
; Determines CPU type
; Returns:
;	al = CPU type
;		0 if 8088/8086 or V20/V30
;		1 if 80186/80188
;		2 if 80286
;		3 if 80386
;		4 if 80486
;		5 if Pentium
;	ah = 	bit 0 =	0 if CPUID unavailable
;			1 if CPUID ok
;		bit 1 =	1 if NEC V20/V30
;			0 otherwise
;		bits 2-7 = 0
PROC get_cpu_version
	PUBLIC PASCAL get_cpu_version
	ARG RETURNS cpu_type:WORD
	P8086
	push cx
	push dx
	push ds
	push es


; Test for 8088
;	80186 and up processors mask SHL/SHR count to a maximum of 31 places.
@@test_8088:
	mov cl, 20h		; So use overlarge shift count
	mov ax, 1
	shr ax, cl
	cmp ax, 0		; If zero, then shift was NOT masked
	jne @@test_80186

; Test for V20/V30
;	It's NOT an 80186 or better processor, which means it's either a
;	V20/V30 or 8088/8086.
;
;	db 0Fh, 14h, 0C3h =
;		8088/8086	V20/V30
;		-----------------------
;		pop cs		set1 bl, cl
;		adc al, 0C3h
@@test_V20:
	xor al, al
	push cs
	db 0Fh, 14h, 0C3h
	cmp al, 0C3h
	jne @@its_a_V20
	mov ax, 0		; It's an 8088/8086
	jmp @@cpu_type_exit

@@its_a_V20:
	pop ax			; Compensate for lack of pop cs
	mov ax, 0200h		; It's a V20/V30
	jmp @@cpu_type_exit

; Test for 80186
;	80186 pre-increments the SP when pushing onto the stack. 80286 and
;	later do post-increment.
@@test_80186:
	mov bx, sp		; Store SP
	push sp			; On 8088/8086/80188/80186 this will actually
				; push SP+2 onto the stack. On 286 and later,
				; SP+0 will be pushed.
	pop ax
	cmp ax, bx		; Did SP "change"?
	je @@test_80286

	mov ax, 1		; It's an 80186
	jmp @@cpu_type_exit

; Test for 80286
;	Now that we know it's at least a 286, we'll try a 32bit opcode.
;	If it's a 286, the bad opcode interrupt (int 6) will get tripped.
;	If not, then it's at least a 386 and we go onwards.
@@test_80286:
	call hook_int6			; Set up for test
	mov [cs:badoff], offset @@bad_op

	P386			; Enabled 386 code generation
	xchg eax, eax		; 32bit NOP

	jmp @@test_80386	; If it's a 286, this instruction is never
				; reached
@@bad_op:
	call release_int6	; int6 handler "returns" here when it exits

@@its_a_80286:
	mov ax, 2		; Yep, it's finally confirmed: It's a 286!
	jmp @@cpu_type_exit

; Test for 80386
;	Bit 18 of EFLAGS can't be set on a 386, but can on 80486 or better
@@test_80386:
	P386			; make sure 386 code is enabled

	call release_int6	; Clean up residue from 286
	cli
	pushfd			; Store flags

	pop eax			; Get flags into eax
	mov ebx, eax		; store 'em
	xor eax, 40000h		; Toggle bit 18
	push eax
	popfd			; Set "new" flags
	pushfd
	pop eax			; Get "new" flags
	push ebx
	popfd			; Restore old flags
	sti
	xor eax, ebx		; See if bit changed
	jnz @@test_80486

	mov ax, 3
	jmp @@cpu_type_exit

; Test for 80486
;	Bit 21 in EFLAGS can't be set on a 486, but can on a P5 or better(?)
@@test_80486:
	cli
	pushfd
	pop eax
	mov ebx, eax
	xor eax, 200000h	; Toggle bit 21
	push eax
	popfd			; Load "new" flags
	pushfd
	pop eax			; Restore "new" flags
	push ebx		; Restore old flags
	popfd
	sti

	xor eax, ebx		; Did the bit change?
	jnz @@test_80586

	mov ax, 4
	jmp @@cpu_type_exit

; Test for 80586
;	Intel FINALLY put in an opcode to id the cpu for you, so now that
;	we know it *IS* a P5 or better cpu, we'll just use that opcode.
@@test_80586:
	push ecx
	push edx
	mov eax, 1
	db 0Fh, 0A2h		; CPUID instruction opcode
	and ax, 0F00h		; family info
	shr ax, 8		; move it into al
	mov ah, 1		; CPUID ok flag
	pop edx
	pop ecx
				; And FINALLY exit
@@cpu_type_exit:
	pop es
	pop ds
	pop dx
	pop cx
	ret
ENDP get_cpu_version

END
