
#ifndef  __GRAVIS_H__
#define  __GRAVIS_H__

//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// Gravis - Header file                                                      
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <socom\audio.h>

//Ŀ
//                                                                           
// Class specification                                                       
//                                                                           
//

class Gravis : public AudioDevice
{

 public:

   // Constructor
   Gravis( void );

   // Destructor
   ~Gravis( void );

   // Close down Gravis
   void  Close( void );

   // Handle interrupts generated by Gravis
   void  Handler( void );

   // Load a module into the AudioDevice
   int   LoadModule( Module* aMod, int digVoices );

   // Download a sample into DRAM
   int   LoadSample( Sample* smp );

   // Open and initialize Gravis
   int   Open( int musVoices, int digVoices );

   // Play a module
   void  Play( Module* aMod );

   // Play a standalone digital sample
   void  PlaySample( ubyte voice, ubyte panPos, Sample* smp );

   // Stop playing module
   void  Stop( Module* aMod );

   // Stop a running sample
   void  StopSample( int voice ) const;

   // Unload a module from device driver
   int   UnloadModule( Module* aMod );

 private:

   ulong myFreeDRAM;          // first free block of DRAM
   ulong myResDRAM;           // reserved DRAM
   int   myIrqStatus;         // interrupt status port
   int   myTimerControl;      // timer control port
   int   myTimerData;         // timer data port
   int   myIrqControl;        // interrupt control register
   int   myVocSelect;         // voice select port
   int   myRegSelect;         // register select port
   int   myDataLo;            // global data low port
   int   myDataHi;            // global data high port
   int   myDramPort;          // dram i/o port
   bool  myOpenFlag;
   uword myFreqTable[1815];   // buffer for pre-calculated frequency table
   ubyte myMixImage;          // image of mixer register
   ubyte myTimerPort;         // current timer
   ubyte myTimerMask;         // current mask for timer
   ubyte myTimerBpm;          // current timer speed

   // Allocate a block of DRAM
   int   AllocDRAM( ulong size, ulong& address );

   // Pre-calculate frequency table
   void  CalcFreqTable( void );

   // Convert address if DMA channel is 16 bit
   ulong ConvTo16bit( ulong address ) const;

   // Disable any output from Gravis
   void  DisableOutput( void );

   // Enable any output from Gravis
   void  EnableOutput( void );

   // Free a block of DRAM
   int   FreeDRAM( ulong size, ulong address );

   // Small delay needed when modifying certain hardware registers
   void  gdelay( void ) const;

   // Handle voice & volume interrupts
   void  HandleVoice( void );

   // Initialize memory allocation routines
   int   InitDRAM( void );

   // Read a byte from DRAM
   ubyte PeekByte( ulong address ) const;

   // Read a 32-bit value from DRAM
   ulong PeekLong( ulong address ) const;

   // Write a byte to DRAM
   void  PokeByte( ulong address, ubyte data ) const;

   // Write a 32-bit value to DRAM
   void  PokeLong( ulong address, ulong value ) const;

   // Prime channels with new values
   void  PrimeChannels( void );

   // Prime a voice with new values but don't start it
   ubyte PrimeVoice( ulong begin, ulong start, ulong end, ubyte mode ) const;

   // Try to detect a Gravis UltraSound
   bool  Probe( void );

   // Slide current voice's volume to destination volume
   void  RampVolume( ubyte endidx, ubyte mode ) const;

   // Full reset and initialization of all voices
   void  Reset( void ) const;

   // Restore interrupts and handler
   void  ResetHandler( void ) const;

   // Set balance of current voice
   void  SetBalance( ubyte panpos ) const;

   // Install a new interrupt handler
   void  SetHandler( void );

   // Program Gravis for IRQs and DMA
   void  SetInterface( void );

   // Set current voice's period
   void  SetPeriod( int period ) const;

   // Determine the amount of DRAM on-board
   ulong SizeDRAM( void );

   // Start module replayer
   void  StartPlayer( void );

   // Start up current voice
   void  StartVoice( ubyte mode ) const;

   // Stop current voice
   void  StopVoice( void ) const;

   // Stop current voice's volume
   void  StopVolume( void ) const;

   // Handle volume interrupts
   void  VolumeHandler( int voice );

};

#endif   // __GRAVIS_H__
