
//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// DSM - Implementation                                                      
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <string.h>
#include <socom\dsm.h>

//Ŀ
//                                                                           
// Data structures                                                           
//                                                                           
//

struct dmSampleInfo
{
   char  mySampleName[22];
   ubyte mySampleBits;
   uword myLength;
   ubyte myFineTune;
   ubyte myVolume;
   uword myRepPos;
   uword myRepLen;
   ubyte pad;
};

//Ŀ
//                                                                           
// Constructor                                                               
//                                                                           
//

DSM::DSM( char* fileName ) : Module( fileName )
{

}

//Ŀ
//                                                                           
// Copy constructor                                                          
//                                                                           
//

DSM::DSM( const DSM& aMod ) : Module( aMod )
{

}

//Ŀ
//                                                                           
// Destructor                                                                
//                                                                           
//

DSM::~DSM( void )
{

}

//Ŀ
//                                                                           
// Assignment operator                                                       
//                                                                           
//

DSM& DSM::operator =( const DSM& aMod )
{
   Module::operator =( aMod );

   return *this;
}

//Ŀ
//                                                                           
// Load module into memory                                                   
//                                                                           
//

int   DSM::LoadModule( void )
{
   Sample*  smp;
   ulong    size;
   int      retValue;
   char     id[3];

   if ( myFP != 0 )
   {
      fread( (void*)id, 3, 1, myFP );

      if ( strncmp( id, "DSm", 3 ) == 0 )
      {
         fseek( myFP, 42, SEEK_CUR );

         myNumChn       = fgetc( myFP );
         myNumSmp       = fgetc( myFP );
         mySongLen      = fgetc( myFP );
         myPackInfo     = fgetc( myFP );
         myMasterVolume = fgetc( myFP );
         myModType      = SOC_DSM;

         myMasterVolume = ( myMasterVolume * 255 ) / 100;

         fseek( myFP, 14, SEEK_CUR );
         fread( myPanPos, myNumChn, 1, myFP );
         fread( myOrders, mySongLen, 1, myFP );

         CalcNumPats();

         fseek( myFP, myNumPat * myNumChn * 8, SEEK_CUR );

         if (( retValue = ReadSampleInfo()) == SOC_OK )
         {
            myPatSize = 256 * myNumChn;

            if (( retValue = AllocPatterns()) == SOC_OK )
            {
               for ( int i = 0; i < myNumPat; i++ )
               {
                  if ( fread( myPatterns[i], myNumChn * 256, 1, myFP ) != 1 )
                  {
                     retValue = SOC_READ_FAULT;
                     break;
                  }
               }

               if ( i >= myNumPat )
               {
                  for ( i = 0; i < myNumSmp; i++ )
                  {
                     smp  = &mySamples[i];
                     size = smp->myLength;

                     if ( size != 0 )
                     {
                        if (( smp->myAddress = new ubyte [size] ) != 0 )
                        {
                           if ( fread( smp->myAddress, size, 1, myFP ) != 1 )
                           {
                              retValue = SOC_READ_FAULT;
                              break;
                           }
                        }
                     }
                  }
               }
            }
         }
      }
      else
      {
         retValue = SOC_UNKNOWN_MOD;
      }

      fclose( myFP );
   }
   else
   {
      retValue = SOC_NO_FILE;
   }

   return retValue;
}

//Ŀ
//                                                                           
// Read sample information structures                                        
//                                                                           
//

int   DSM::ReadSampleInfo( void )
{
   int            retValue;
   dmSampleInfo*  dmSamples = new dmSampleInfo [myNumSmp];
   dmSampleInfo*  bSample;
   Sample*        aSample;

   if ( dmSamples != 0 )
   {
      mySamples = new Sample [myNumSmp];

      if ( mySamples != 0 )
      {
         if ( fread( dmSamples, sizeof( dmSampleInfo ), myNumSmp, myFP ) == myNumSmp )
         {
            for ( int i = 0; i < myNumSmp; i++ )
            {
               aSample = &mySamples[i];
               bSample = &dmSamples[i];

               aSample->myLength     = bSample->myLength;
               aSample->myRepPos     = bSample->myRepPos;
               aSample->myRepEnd     = bSample->myRepLen;
               aSample->myVolume     = bSample->myVolume;
               aSample->myFineTune60 = bSample->myFineTune * 60;

               if ( bSample->mySampleBits == 16 )
               {
                  aSample->mySampleMode |= SOC_16BIT;
               }

               if ( aSample->myRepEnd > 2 )
               {
                  aSample->mySampleMode |= SOC_LOOP;
               }
            }

            retValue = SOC_OK;
         }
      }
      else
      {
         retValue = SOC_NO_MEMORY;
      }

      delete [] dmSamples;
   }
   else
   {
      retValue = SOC_NO_MEMORY;
   }

   return retValue;
}

