#include <stdio.h>
#include <math.h>
#include <dos.h>
#include "gfx.c"
#include "misc.c"
#include "memory.c"

#define pi 3.141592

unsigned char sinus[256];
unsigned int multab[320];

unsigned int frame,x,y,px,py;
unsigned int mousex,mousey;
unsigned int bseg,bseg3;

asm piccy  db 'piccy.raw',0

void GetMouse()
{
  asm mov ax,3
  asm int 0x33
  asm mov word ptr mousex,cx
  asm mov word ptr mousey,dx
}

void Close()
{
  if (bseg) FreeBuffer(bseg);
  if (bseg3) FreeBuffer(bseg3);
}

init()
{
  bseg=SetUpBuffer(4000);
  if (!bseg)
    {
      printf("Not enough conventional memory.\n");
      Close();
      exit(10);
    }

  bseg3=SetUpBuffer(4000);
  if (!bseg3)
    {
      printf("Not enough conventional memory.\n");
      Close();
      exit(10);
    }

  for (x=0;x<256;x++) sinus[x]=(cos(2*pi*x/256)*127+128);
  for (x=0;x<320;x++) multab[x]=x*320;
}

void loadpic()
{
  asm mov ax,0x3d02
  asm lea dx,piccy
  asm int 0x21
  asm jnc piccy_found
      {
	printf("pic-file not found.\n");
	Close();
	exit(10);
      }
      piccy_found:
  asm mov bp,ax
  asm push ds
  asm mov ds,bseg3
  asm mov bx,bp
  asm mov cx,64000
  asm mov ah,0x3f
  asm xor dx,dx
  asm int 0x21
  asm pop ds
  asm mov bx,bp
  asm lea dx,[pal]
  asm mov cx,768
  asm mov ah,0x3f
  asm int 0x21
  asm mov bx,bp
  asm mov ah,0x3e
  asm int 0x21
}

void DrawPic(unsigned int dest)
{
  asm mov gs,bseg3
  asm mov fs,bseg
  asm mov es,dest
  asm mov di,321
  asm mov y,1
      y_loop2:
  asm   mov x,1
	x_loop2:
  asm 	  mov al,byte ptr fs:[di-320]	// get vert distortion
  asm 	  sub al,byte ptr fs:[di+320]
  asm     cbw
  asm     mov si,y
  asm     add si,ax
  asm     shl si,1
  asm     mov si,word ptr multab[si]
  asm     add si,x
  asm     mov al,byte ptr fs:[di+1]     // get hor distortion
  asm 	  sub al,byte ptr fs:[di-1]
  asm     cbw
  asm     add si,ax
  asm 	  mov al,byte ptr gs:[si]       // si = new offset
  asm     mov byte ptr es:[di],al       // load pixel
  asm     inc di
  asm     inc x
  asm     cmp x,319
  asm   jne x_loop2
  asm   add di,2
  asm   inc y
  asm   cmp y,199
  asm jne y_loop2
}

void DrawWave()
{
  asm mov bx,mousex
  asm shr bx,2
  asm neg bx
  asm sub frame,50;
  asm mov es,bseg
  asm xor di,di
  asm mov y,0
      y_loop:
  asm   mov px,bx
  asm   mov ax,y        	//      py=(y-mousey)*(y-mousey);
  asm   sub ax,mousey
  asm   xor dx,dx
  asm   mul ax
  asm   mov py,ax
  asm   shl word ptr px,1
  asm   mov cx,320
	x_loop:
  asm     add px,1
  asm     mov ax,px
  asm     add py,ax
  asm     mov si,py
  asm     shr si,4
  asm     add si,frame
  asm     and si,255
  asm     mov al,byte ptr sinus[si]
  asm     shr al,2
  asm     mov byte ptr es:[di],al
  asm     inc di
  asm     dec cx
  asm   jnz x_loop
  asm   inc y
  asm cmp y,200
  asm jne y_loop
}

int main()
{
  init();
  loadpic();
  mode(0x13);
  setpal();
  frame=0;
  while (keypressed()!=1)
  {
    GetMouse();
    DrawWave();
    waitretrace();
    DrawPic(0xa000);
    frame++;
  }
  mode(3);
  Close();
}