comment $
Ŀ
                                                                          
                        	3D.ASM                                     
                        (Routines 3d gnrales)                           
Ĵ
                                                                        
                       (C) 1995, SM Karibou                             
                                                                        
Ĵ
                                                                          
 Date de cration: --/--/--                                               
 Date de rvison : 10/02/96                                               
                                                                          

$

.386p
locals
.MODEL FLAT,PASCAL
.DATA
align 4
include sincos.dd         ; Table Sinus/Cosinus 12-bits

.CODE
include 3d.ash

; Procedures de rotations de points 

RotateAxis MACRO

  ; entre: EAX 1ere coord ECX deuxieme coord EBX angle
  ; sortie: Pariel mais rotater

  ; X'=CosA(X+Y)-Y(SinA+CosA)
  ; Y'=X(SinA-CosA)+CosA(X+Y)

  push esi
  push edi
  push ebp

  shl ebx,2
  mov edi,dword ptr [Cosine+ebx]     ;= EDI=Cos A
  mov esi,dword ptr [Sine+ebx]       ;= ESI=Sin A
  mov ebp,edi
  add ebp,esi                        ;= EBP=SinA+CosA
  sub esi,edi                        ;= ESI=SinA-CosA
                                     ;= EDI=COS A
  mov ebx,eax
  add eax,ecx                        ;= X+Y
  imul edi                           ;= CosA(X+Y)
  mov edi,eax                        ;= EDI=CosA(x+y)

  mov eax,ebx
  imul esi                           ;= X*(SinA-CosA)
  mov ebx,eax
  add ebx,edi                        ;= EDI=y'

  mov eax,ecx
  imul ebp
  sub edi,eax

  mov eax,edi                        ;= EAX=X'
  mov ecx,ebx                        ;= ECX=y'
  sar eax,12
  sar ecx,12

  pop ebp
  pop edi
  pop esi
ENDM

;== Rotation autour de x,y et z. (9muls/Pt)

;== Entre: DS:ESI Coord a rotater (X,Y,Z)
;           DS:EDI Coord rotated   (X,Y,Z)
;== Arguments: AngleX,AngleY,AngleZ,Nbr de points

RotatePointsFast Proc pascal
                 Uses esi,edi
                 Arg  @@Xan,@@Yan,@@Zan,@@Nbr:DWord

@@RotateCounter:
  mov eax,DWord ptr [esi+4]    ; EAX = Y Coord
  mov ecx,Dword ptr [esi+8]    ; ECX = Z Coord
  mov ebx,@@Xan
  RotateAxis                  ; Rotation X
  mov dword ptr [edi+4],eax   ; on sauve Y
  mov eax,dword ptr [esi]     ; EAX = X Coord
  mov ebx,@@Yan                 ; ECX = Z Coord
  RotateAxis                  ; Rotation Y
  mov  DWord Ptr [edi+8],ecx   ; sauve Z
  mov  ecx,DWord Ptr [edi+4]   ; ECX = YCoord
  mov  ebx,@@Zan
  RotateAxis                   ; Rotation Z
  mov  DWord Ptr [edi],eax    ; sauve X
  mov  DWord Ptr [edi+4],ecx  ; sauve Y
  add  esi,12
  add  edi,12
  dec @@Nbr
  jnz @@RotateCounter
  ret
RotatePointsFast Endp

;

;== Rotation autour de z,y et x. (9muls/Pt)

;== Entre: DS:ESI Coord a rotater (X,Y,Z)
;           DS:EDI Coord rotated   (X,Y,Z)
;== Arguments: AngleX,AngleY,AngleZ,@@Nbr de points

RotateInvert Proc pascal
             Uses esi,edi
             Arg  @@Xan,@@Yan,@@Zan,@@Nbr:DWord

@@RotateCounter:
  mov eax,DWord ptr [esi]       ; EAX = X Coord
  mov ecx,Dword ptr [esi+4]     ; ECX = Y Coord
  mov ebx,@@Zan
  RotateAxis                    ; Rotation Z
  mov dword ptr [edi+4],ecx     ; on sauve Y
  mov ecx,dword ptr [esi+8]     ; EAX = X Coord
  mov ebx,@@Yan                   ; ECX = Z Coord
  RotateAxis                    ; Rotation Y
  mov  DWord Ptr [edi],eax      ; sauve X
  mov  eax,DWord Ptr [edi+4]    ; EAX = Y Coord
  mov  ebx,@@Xan
  RotateAxis                    ; Rotation X
  mov  DWord Ptr [edi+4],eax    ; sauve Y
  mov  DWord Ptr [edi+8],ecx    ; sauve Z
  add  esi,12
  add  edi,12
  dec @@Nbr
  jnz @@RotateCounter
  ret
RotateInvert Endp

;
;== Rotate des points autour de x,y et z. (6muls/pt+x muls)

;== Entre:    DS:ESI Coord a rotater (X,Y,Z,B=x*y*4096)
;              DS:EDI Coord rotated   (X,Y,Z)

;Note: Appeler PrepareRotation avant de faire appel aux autres fonctions
;Voir arguments respectifs
.DATA?
align 4
__A     dd  3   dup(?)
_R      dd  3*3 dup(?)
_cox    dd  ?
_coy    dd  ?
_coz    dd  ?
_coxy   dd  ?
_coxz   dd  ?
_six    dd  ?
_siy    dd  ?
_siz    dd  ?
_sixy   dd  ?
_sixz   dd  ?
_t1     dd  ?
_t2     dd  ?

.CODE
PrepareRotation6m Proc Pascal near
                Arg @@Xan,@@Yan,@@Zan:Dword

             ;==== Init des coefficients de la matrice de rotation
             mov eax,@@Xan
             shl eax,2
             mov ebx,eax
             mov ebx,Cosine[ebx]
             mov _cox,ebx

             mov ecx,@@Yan
             shl ecx,2
             mov ebx,ecx
             mov ebx,Cosine[ebx]
             mov _coy,ebx

             mov edx,@@Zan
             shl edx,2
             mov ebx,edx
             mov ebx,Cosine[ebx]
             mov _coz,ebx

             mov ebx,eax
             add ebx,ecx
             and ebx,512*4-1
             mov ebx,Cosine[ebx]
             mov _coxy,ebx

             mov ebx,eax
             add ebx,edx
             and ebx,512*4-1
             mov ebx,Cosine[ebx]
             mov _coxz,ebx

             mov ebx,eax
             mov ebx,Sine[ebx]
             mov _six,ebx

             mov ebx,ecx
             mov ebx,Sine[ebx]
             mov _siy,ebx

             mov ebx,edx
             mov ebx,Sine[ebx]
             mov _siz,ebx

             mov ebx,eax
             add ebx,ecx
             and ebx,512*4-1
             mov ebx,Sine[ebx]
             mov _sixy,ebx

             mov ebx,eax
             add ebx,edx
             and ebx,512*4-1
             mov ebx,Sine[ebx]
             mov _sixz,ebx

             ;===== R
             mov ebx,_coy
             mov eax,_coz
             cdq
             imul ebx
             sar eax,12
             mov _R,eax

             mov eax,_siz
             cdq
             imul ebx
             sar eax,12
             mov _R[12],eax

             mov eax,_siy
             neg eax
             mov _R[24],eax

             mov ebx,_six
             mov eax,_siy
             cdq
             imul ebx
             sar eax,12
             mov _R[4],eax

             mov eax,_coy
             cdq
             imul ebx
             sar eax,12
             mov _R[28],eax

             mov ebx,_coz
             mov eax,_cox
             cdq
             imul ebx
             sar eax,12
             mov _R[16],eax

             mov eax,_six
             cdq
             imul ebx
             sar eax,12
             mov _R[20],eax

             mov eax,_sixy
             sub eax,_R[28]
             mov _R[8],eax

             mov eax,_coxy
             add eax,_R[4]
             mov _R[32],eax

             mov ebx,_coz
             mov eax,_R[4]
             mov _t1,eax
             cdq
             imul ebx
             sar eax,12
             sub eax,_sixz
             add eax,_R[20]
             mov _R[4],eax

             mov eax,_R[8]
             mov _t2,eax
             cdq
             imul ebx
             sar eax,12
             sub eax,_coxz
             add eax,_R[16]
             mov _R[8],eax

             mov ebx,_siz
             mov eax,_t1
             cdq
             imul ebx
             sar eax,12
             add eax,_R[16]
             mov _R[16],eax

             mov eax,_t2
             cdq
             imul ebx
             sar eax,12
             sub eax,_R[20]
             mov _R[20],eax

             ;=================== Precalcul du vecteur A
             mov eax,_R[4]
             cdq
             imul dword ptr _R
             sar eax,12
             mov __a,eax

             mov eax,_R[16]
             cdq
             imul dword ptr _R[12]
             sar eax,12
             mov __a[4],eax

             mov eax,_R[28]
             cdq
             imul dword ptr _R[24]
             sar eax,12
             mov __a[8],eax

             ret
PrepareRotation6m endp



RotatePoints6m Proc pascal near
             Uses Esi,Edi
             Arg  @@Nbr:Dword

             ;===================  BAh si On calculait maintenant ?
@@RotateLoop:
             _RotatePoints6m

             add edi,12
             add esi,16

             dec @@Nbr
             jnz @@RotateLoop

             ret
Rotatepoints6m endp

; Rotations par additions 

.DATA?
align 4
_TriX       dd  A*4 dup(?)
_TriY       dd  A*4 dup(?)
_TriZ       dd  A*4 dup(?)

_TriedreRot dd  ?,?,?,?,?,?,?,?,?
.DATA
_Triedre    dd  A,0,0,0,A,0,0,0,A
LastX       dd 8000   ; Valeurs theorikment impossible
LastY       dd 8000
LastZ       dd 8000


.CODE
PrepareRotation Proc Pascal near
                Arg @@Xan,@@Yan,@@Zan:Dword
                local @@DX,@@DY,@@DZ:DWord
                Uses esi,edi

                ;==================== Verif des angles
                mov eax,@@Xan
                cmp eax,LastX
                jne @@Go
                mov ebx,@@Yan
                cmp ebx,LastY
                jne @@Go
                mov ecx,@@Zan
                cmp ecx,LastZ
                je @@BailOut
@@Go:
                mov Lastx,eax
                mov lasty,ebx
                mov lastz,ecx


                ;==================== Rotation du triedre
                lea esi,_Triedre
                lea edi,_TriedreRot
                Call RotatePointsFast,@@Xan,@@Yan,@@Zan,3

                ;==================== Calcul des deltas
                mov eax,_TriedreRot
                shl eax,16
                cdq
                mov ecx,A
                idiv ecx
                mov @@DX,eax

                mov eax,_TriedreRot[4]
                shl eax,16
                cdq
                idiv ecx
                mov @@DY,eax

                mov eax,_TriedreRot[8]
                shl eax,16
                cdq
                idiv ecx
                mov @@DZ,eax

                ;================== Remplissage des tablos
                xor eax,eax
                xor ebx,ebx
                xor edx,edx
                mov ecx,A
                lea edi,_Trix
@@l1:
                mov [edi],eax
                mov [edi+4],ebx
                mov [edi+8],edx

                add edi,16
                add eax,@@DX
                add ebx,@@Dy
                add edx,@@Dz
                dec ecx
                jnz @@l1

                ;==================== Calcul des deltas
                mov eax,_TriedreRot[12]
                shl eax,16
                cdq
                mov ecx,A
                idiv ecx
                mov @@DX,eax

                mov eax,_TriedreRot[16]
                shl eax,16
                cdq
                idiv ecx
                mov @@DY,eax

                mov eax,_TriedreRot[20]
                shl eax,16
                cdq
                idiv ecx
                mov @@DZ,eax

                ;================== Remplissage des tablos
                xor eax,eax
                xor ebx,ebx
                xor edx,edx

                mov ecx,A
                lea edi,_Triy
@@l2:
                mov [edi],eax
                mov [edi+4],ebx
                mov [edi+8],edx

                add edi,16
                add eax,@@DX
                add ebx,@@Dy
                add edx,@@Dz
                dec ecx
                jnz @@l2

                ;==================== Calcul des deltas
                mov eax,_TriedreRot[24]
                shl eax,16
                cdq
                mov ecx,A
                idiv ecx
                mov @@DX,eax

                mov eax,_TriedreRot[28]
                shl eax,16
                cdq
                idiv ecx
                mov @@DY,eax

                mov eax,_TriedreRot[32]
                shl eax,16
                cdq
                idiv ecx
                mov @@DZ,eax

                ;================== Remplissage des tablos
                xor eax,eax
                xor ebx,ebx
                xor edx,edx
                mov ecx,A
                lea edi,_Triz
@@l3:
                mov [edi],eax
                mov [edi+4],ebx
                mov [edi+8],edx

                add edi,16
                add eax,@@DX
                add ebx,@@Dy
                add edx,@@Dz
                dec ecx
                jnz @@l3
@@BailOut:
                ret
PrepareRotation endp

RotatePoints    Proc Pascal near
                Arg @@Nbr:Dword
                Uses esi,edi

@@Loop:
                _RotatePoints

                add esi,12
                add edi,12
                dec @@Nbr
                jnz @@Loop
                ret
RotatePoints    endp


; Scaling 
;== Scaling
;== Entre: DS:ESI Liste a scaler (X,Y,Z,(B))
;           EAX @@Nbr de points
;           EBP le facteur de scalage (12bits)

;           Note: Gare a la virgule fixe dans EBP !!!

; les lignes commentes servent pour les pts a 4 coord

ScalePoints Proc Pascal near
            Uses esi
;  mov ebx,1
  mov ecx,eax
  shl eax,2
  add ecx,eax
@@ScaleLooper:
;  test ebx,4
;  jz @@Plouf
;  mov eax,[ESI-12]
;  mov edx,[ESI-8]
;  imul edx
;  sal eax,12
;  mov [ESI],eax
;  mov ebx,0
;  jmp @@loop
@@Plouf:
  mov  eax,ebp
  mov  edx,DWord Ptr [ESI]
  imul edx
  sar  eax,12
  mov  DWord Ptr [ESI],EAX

@@loop:
  add  esi,4
;  inc  ebx
  dec  ecx
  jnz  @@ScaleLooper
  ret
ScalePoints Endp


; Translation 
;== Translation
;== Entre:    DS:ESI Liste a Translater (X,Y,Z,(B))
;   Arguments: Tx,Ty,Tz Vecteur de translation,@@Nbr de points

TransPoints Proc Pascal Near
            Uses esi
            Arg @@Tx,@@Ty,@@Tz,@@Nbr:Dword

	    mov eax,@@tx
	    mov ebx,@@ty
	    mov ecx,@@tz
@@Loop:
	    _TransPoint
	    ;mov eax,[esi]
        ;cdq
        ;imul dword ptr [esi+4]
        ;sal eax,12
        ;mov [esi+12],eax

            add esi,12
            dec @@Nbr
            jnz @@Loop
            ret
TransPoints endp

; Projection 
.DATA
align 4
_PCenterX   dd 160
_PCenterY   dd 100
_XZoom      dd 100h   ;= coef de zoom par rapport au 320*200
_YZoom      dd 100h
.CODE

;== Projection

;== Entre: ECX Nbr Points
;           DS:ESI Liste de coord a projeter
;           DS:EDI LIste de coord Y/X projete

Project Proc Pascal
        Uses edi,esi

 @@ProjectLooper:

  _Project

  add   esi,12
  add   edi,4
  dec   ecx
  jnz  @@ProjectLooper
  ret

Project EndP

;

END
