; These packing routines are based on the LZHUF.C program by
; Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

include ctrl\unpkint.ah
include lzss\lzssgen.ah

pack_text segment

lzss_init proc near
  mov lzunp.cur_bufpos,offset lzunp.decode_buf ; Start p offset 0 i vores buffer
  ret
endp

lzss_done proc near
  ; Skriv decode bufferen:
  cmp lzunp.cur_bufpos,offset lzunp.decode_buf ; Er der overhovedet noget?
  jz buf_emptry                  ; Hvis ikke, s hop
  ; Ellers skal der skrives:
  mov si,offset lzunp.decode_buf ; Skriv ES:SI
  mov dx,lzunp.cur_bufpos        ; DX=Frste byte der ikke bruges
  sub dx,offset lzunp.decode_buf ; DX=Antal bytes der skal skrives
  call user_write
  cmp ax,0
  jnz error   ; Hop ved fejl
  buf_emptry: ; Der er ikke sket noget fejl
  clc         ; Rest carry
  ret
endp

lzss_putchar proc near
  ; Send byten i BL
  mov si,lzunp.cur_bufpos
  cmp si,offset lzunp.decode_buf+bufsize ; Er strrelse overskredet?
  jz flush_buf                           ; S hop
  mov [si],bl                            ; Skriv byten til vores LZSS-buffer
  inc si                                 ; Vlg nste postion
  mov lzunp.cur_bufpos,si                ; Gem nyt offset
  clc
  ret                                    ; Og returner

  flush_buf:
  ; Vi skal starte forfra i LZSS bufferen - men frst skal den skrives:
  push bx                                ; Gem den nye karakter
  mov si,offset lzunp.decode_buf         ; Skriv ES:SI
  mov dx,bufsize                         ; Skriv DX antal bytes
  call user_write
  pop bx
  cmp ax,0
  jnz error   ; Hop ved fejl
  ; Skriv den karakter vi blev bedt om:
  mov lzunp.decode_buf,bl
  mov lzunp.cur_bufpos,offset lzunp.decode_buf+1 ; Og angiv nyt buffer offset
  clc ; Returner at der ingen fejl er
  ret
endp

; Denne bruges flere stedder:
error:
stc
ret

lzss_putstring proc near
  ; Overst den relative adresse i SI til en absolut adresse i vores buffer:
  mov di,lzunp.cur_bufpos
  dist di,si,<offset lzunp.decode_buf>
  ; SI=Vores relative offset
  mov di,lzunp.cur_bufpos
  cpy_again:
  ; Vi skal kopiere fra [SI] med lngden BX til vores buffer i [DI]
  mov cx,offset lzunp.decode_buf+bufsize ; CX=Frste ikke gyldeige offset i buffer
  cmp si,di
  ja sad     ; Source Above Dest
  ; Vi skal kopiere fra et offset der er mindre end destinationen.
  ; Det er derfor ved destinationen vi frst risikerer overflow.
  sub cx,di
  jmp short sbd
  sad:
  sub cx,si
  sbd:
  ; CX indeholder max antal bytes vi kan kopiere uden at der sker overflow
  cmp bx,cx   ; Vil der ske overflow hvis kopierer alt brugeren vil?
  ja overflow ; S hop
  ; Ellers: Kopier alt det brugeren vil:
  mov cx,bx
  rep movsb
  mov lzunp.cur_bufpos,di ; Gem nye offset
  clc
  ret  ; Og returner

  overflow:
  ; Der vil ske et overflow hvis vi kopierer det hele
  sub bx,cx                              ; BX=Antal bytes vi mangler at
                                         ; kopiere efter nste instruktion
  rep movsb                              ; Kopier alt det vi m
  cmp di,offset lzunp.decode_buf+bufsize ; Er DI blevet for stor?
  jz write_buffer                        ; S hop
  ; Ellers er det SI der er blevet for stor:
  si_bad:
  mov si,offset lzunp.decode_buf         ; Lad den starte forfra
  jmp cpy_again                          ; Og kopier igen:

  write_buffer:
  ; DI er blevet for stor.
  ; Vi skal skrive vores buffer til brugeren inden vi fortstter:
  push si ; Gem der bruges registre
  push bx
  mov si,offset lzunp.decode_buf ; Skriv ES:SI
  mov dx,bufsize                 ; Skriv DX antal bytes
  call user_write
  pop bx ; Gen etabler gemte registre
  pop si
  cmp ax,0
  jnz error  ; Hop ved fejl
  ; Bufferen er skrevet.
  mov di,offset lzunp.decode_buf ; Lad DI starte forfra i bufferen
  jmp cpy_again                  ; Og kopier igen
endp

ends
end
