; These packing routines are based on the LZHUF.C program by
; Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

; Denne fil indeholder rutiner der benyttes af svel huffman
; koderen og dekoderen. Public rutine benyttet internt af huffman modulerne:
;   huff_update.
; Den opdaterer tret for karakteren i BX/2. BX skal med andre ord
; vre fordoblet.

include ctrl\packgen.ah

pack_text segment

; Da dette modul bruges af svel ind som udpakker er nedenstende
; tekst ogs indsat her. Den m ikke fjernes.

; IT IS NOT ALLOWED TO REMOVE OR MODIFY THE FOLLOWING NOTICE:
db 13,10,"Suppack 1.00. Copyright (C) 1995 Cristian Worm",13,10

huff_init proc near
  ; Se C++ rutinernes inithuff for formls kommentarer for yderligere info

  ; Opret alle leaf noder:
  mov cx,huff_chars        ; CX=Antal gennemlb tilbage
  xor bx,bx                ; BX=Aktuelle node * 2
  mov si,huff_tabel_size*2 ; SI=Aktuelle node i prnts verste del
  init_loop:
    mov huffdata.freq[bx],1
    mov huffdata.parrent[si],bx
    mov huffdata.son[bx],si
    add bx,2
    add si,2
  loop init_loop

  ; Opret alle mellem noderne:
                      ; BX indeholder allerede aktuelle node * 2
  mov cx,huff_chars-1 ; CX=Antal gennemlb tilbage
  xor si,si           ; SI=Aktuelle "under" node.
  init_loop2:
    mov ax,huffdata.freq[si]
    add ax,huffdata.freq[si+2]
    mov huffdata.freq[bx],ax
    mov huffdata.son[bx],si
    mov huffdata.parrent[si],bx
    mov huffdata.parrent[si+2],bx
    add si,4
    add bx,2
  loop init_loop2

  ; Angiv hvor roden er og angiv dens forlder til 0
  mov huffdata.parrent[(huff_tabel_size-1)*2],0

  ; Og frekvens stop punkt
  mov huffdata.freq[huff_tabel_size*2],0FFFFh

  ret
endp

huff_reconst proc near
  ; Gr tr lige:
  mov bx,huff_tabel_size*2      ; BX=Frste karakter i parrent
  mov cx,huff_chars             ; CX=Karakterer tilbage=Aktuelle char +1
  reconst_loop:
    mov si,huffdata.parrent[bx] ; SI=Leaf node til karakter
    test huffdata.freq[si],1    ; Er den lige?
    jz good_char                ; Hvis ja, s g til nste char
    ; Ellers: Opdater frekvensen:
    push bx
    push cx                     ; Gem brugte registre
    sub bx,huff_tabel_size*2    ; BX=Aktuelle char*2
    call huff_update1        ; Og opdater tret uden at tjekke for freq overflow
    pop cx
    pop bx
    good_char:
    add bx,2
  loop reconst_loop

  ; Divider trets frekvenser ned:
  mov cx,huff_tabel_size    ; CX=Antal noder tilbage
  xor bx,bx                 ; BX=Aktuelle node
  reconst_loop1:
    shr huffdata.freq[bx],1 ; Divider frekvens med 2
    add bx,2
  loop reconst_loop1

  ret
endp

; Hrer til huff_update
update_tree:
push bx           ; Gem den karakter der skal opdateres
call huff_reconst ; Rekostrurer
pop bx
jmp huff_update1  ; Og g tilbage til tr opdtaering

huff_update proc near
  cmp huffdata.freq[(huff_tabel_size-1)*2],max_freq
  ; Har vi net maksimal frekvens
  jz update_tree ; S opdater tret
endp

huff_update1 proc near
  ; Opdater nu tret - reconst er kaldet hvis det skal gres.

  mov bx,huffdata.parrent[bx+huff_tabel_size*2] ; BX=Leaf node vi skal starte ved

  huff_update_loop:
    inc huffdata.freq[bx]      ; Opdater frekvensen
    mov ax,huffdata.freq[bx]   ; AX=Akautelle frekvens
    cmp ax,huffdata.freq[bx+2] ; Sammenlign med nste frekvens i rkken
    ja freqs_changed           ; Hop hvis den lille er strre end den store :-)
    ; Ellers er alt ok - g til nste node:
    tree_ok:
    mov bx,huffdata.parrent[bx] ; Vlg fader
    cmp bx,0                    ; Er vi net til roden?
  jnz huff_update_loop          ; Hvis nej, s tjek nste node
  ret                           ; Ellers, s returner

  freqs_changed:

  ; Vi skal til at lave ndringer i tret

  ; Find de to noder vi skal have byttet om:
  mov di,bx
  add di,offset huffdata.freq+2 ; ES:DI=Freq byte fra nste karakter
  mov cx,-1      ; Sg i al evighed...
  dec ax         ; Sg s lnge de er lig ax-1, dvs s lnge de er mindre end ax
  repz scasw     ; Sg!
  sub di,offset huffdata.freq+4 ; DI=Sidste freq der er mindre end den gamle

  ; Vi skal ny flytte node BX (den gamle) til node DI (den nye),

  ; Byt frst frekvenserne om:
  inc ax                    ; AX=Den gamle frekvens
  xchg ax,huffdata.freq[di] ; AX=Den nye frekvens
  mov huffdata.freq[bx],ax  ; Gem den nye

  ; Angiv overfor snnerne at de har fet nye forldre:
  mov ax,huffdata.son[bx]       ; AX=Den gamle sn
  mov si,huffdata.son[di]       ; SI=Den nye sn
  mov huffdata.parrent[si],bx   ; St den nyes nye sn til den nye forlder
  cmp si,huff_tabel_size*2      ; Er ved en leaf?
  jae no_other1                 ; S er der kun en sn
  mov huffdata.parrent[si+2],bx ; Ellers: Opdtaer ogs den anden sn
  no_other1:
  ; Opdater nu ogs den gamle nodes nye snner p samme mde
  xchg si,ax
  mov huffdata.parrent[si],di
  cmp si,huff_tabel_size*2
  jae no_other2
  mov huffdata.parrent[si+2],di
  no_other2:

  ; Lad SI og DI pege p deres nye snner:
  mov huffdata.son[bx],ax ; AX og SI er netop byttet om i forhold
  mov huffdata.son[di],si ; til da de blev loadet til snnerne

  mov bx,di   ; Fortst fra det nye sted

  jmp tree_ok ; Fortst op af i tret
endp

public huff_update

ends
end
