;***********************O*P*S***************************************************
OpMul Proc Near
  push   eax
  push   edx
  call   mypop
  jc     OpMul@exit
  mov    edx,eax
  call   mypop
  jc     OpMul@exit2
  push   eax
  push   edx                    ; save for (maybe) overflow...
  cmp    Ident,'i'
  je     OpMul@sign
  mul    edx
  jo     OpMul@overflow
  call   mypush
  pop    eax
  pop    eax                    ; throw away...
  jmp    OpMul@exit
OpMul@sign:
  imul   edx
  jo     OpMul@overflow
  call   mypush
  pop    eax
  pop    eax
  jmp    OpMul@exit
OpMul@overflow:
  pop    edx
  pop    eax
  call   mypush
  mov    eax,edx
  call   mypush
  jmp    OpMul@exit
OpMul@exit2:
  mov    eax,edx
  call   mypush                 ; put 1st argument back...
OpMul@exit:
  pop    edx
  pop    eax
  ret
OpMul endp

OpAdd Proc Near
  push   eax
  push   edx
  call   mypop
  jc     OpAdd@exit
  mov    edx,eax
  call   mypop
  jc     OpAdd@exit2
  add    eax,edx
  call   mypush
  jmp    OpAdd@exit
OpAdd@exit2:
  mov    eax,edx
  call   mypush
OpAdd@exit:
  pop    edx
  pop    eax
  ret
OpAdd endp

OpSub Proc Near
  push   eax
  push   edx
  call   mypop
  jc     OpSub@exit
  mov    edx,eax
  call   mypop
  jc     OpSub@exit2
  sub    eax,edx
  call   mypush
  jmp    OpSub@exit
OpSub@exit2:
  mov    eax,edx
  call   mypush
OpSub@exit:
  pop    edx
  pop    eax
  ret
OpSub endp

OpDiv Proc Near
  push   eax
  push   ecx
  push   edx
  call   mypop
  jc     OpDiv@exit
  mov    ecx,eax
  cmp    ecx,0
  jz     OpDiv@exit2
  call   mypop
  jc     OpDiv@exit2
  push   eax
  push   ecx                    ; save for (maybe) overflow...
  cmp    Ident,'i'
  je     OpDiv@sign
  xor    edx,edx
  Div    ecx
  jo     OpDiv@overflow
  call   mypush
  pop    eax
  pop    eax                    ; throw away...
  jmp    OpDiv@exit
OpDiv@sign:
  cdq
  iDiv   ecx
  jo     OpDiv@overflow
  call   mypush
  pop    eax
  pop    eax
  jmp    OpDiv@exit
OpDiv@overflow:
  pop    ecx
  pop    eax
  call   mypush
  mov    eax,ecx
  call   mypush
  jmp    OpDiv@exit
OpDiv@exit2:
  mov    eax,ecx
  call   mypush                 ; put 1st argument back...
OpDiv@exit:
  pop    edx
  pop    ecx
  pop    eax
  ret
OpDiv endp

OpMod Proc Near
  push   eax
  push   ecx
  push   edx
  call   mypop
  jc     OpMod@exit
  mov    ecx,eax
  cmp    ecx,0
  jz     OpMod@exit2
  call   mypop
  jc     OpMod@exit2
  push   eax
  push   ecx                    ; save for (maybe) overflow...
  cmp    Ident,'i'
  je     OpMod@sign
  xor    edx,edx
  div    ecx
  jo     OpMod@overflow
  mov    eax,edx
  call   mypush
  pop    eax
  pop    eax                    ; throw away...
  jmp    OpMod@exit
OpMod@sign:
  cdq
  idiv   ecx
  jo     OpMod@overflow
  mov    eax,edx
  call   mypush
  pop    eax
  pop    eax
  jmp    OpMod@exit
OpMod@overflow:
  pop    ecx
  pop    eax
  call   mypush
  mov    eax,ecx
  call   mypush
  jmp    OpMod@exit
OpMod@exit2:
  mov    eax,ecx
  call   mypush                 ; put 1st argument back...
OpMod@exit:
  pop    edx
  pop    ecx
  pop    eax
  ret
OpMod endp

OpDup Proc Near
  push   eax
  call   mypop
  jc     OpDup@exit
  call   mypush
  call   mypush
;  jc     OpDup@exit            ; stack overflow...
OpDup@exit:
  pop    eax
  ret
OpDup endp

OpSwap Proc Near
  push   eax
  push   edx
  call   mypop
  jc     OpSwap@exit
  mov    edx,eax
  call   mypop
  jc     OpSwap@exit2
  xchg   edx,eax
  call   mypush
  mov    eax,edx
  call   mypush
  jmp    OpSwap@exit
OpSwap@exit2:
  mov    eax,edx
  call   mypush
OpSwap@exit:
  pop    edx
  pop    eax
  ret
OpSwap endp

OpExit Proc Near
  sub    sp,4
  jmp    i9@exit
OpExit endp

OpEnter Proc Near
  sub    sp,4
  call   mypop
  jc     opEnter@end
  call   mypush
  call   MakeNumber
  mov    ah,05h
  mov    dx,cx
  xor    bx,bx
opent@loop:
  mov    cl,[offset InpBuffer+bx]
  int    16h
  cmp    al,1
  je     opEnter@end
  inc    bx
  cmp    bx,dx
  jne    opent@loop
opEnter@end:
  jmp    i9@exit
OpEnter endp

OpDrop Proc Near
  push   eax
  call   mypop
;  jc     OpDrop@exit
;OpDrop@exit:
  pop    eax
  ret
OpDrop endp

OpClr Proc Near
  mov    MyStackPtr,0
  ret
OpClr endp

OpSqu Proc Near
  push   eax
  call   mypop
  jc     OpSqu@exit
  call   mypush
  cmp    eax,65535
  ja     OpSqu@exit
  call   OpDup
  call   OpMul
OpSqu@exit:
  pop    eax
  ret
OpSqu endp

OpSqr proc near
  pushad
  call   mypop
  jc     OpSqr@exit
  or     eax,eax
  jz     OpSqr@exit2
  mov    ebx,eax

  xor    esi,esi
  xor    edx,edx
  mov    ecx,ebx
  mov    eax,ebx

OpSqr@iterat:
  idiv   ebx
  xor    edx,edx
  add    eax,ebx
  shr    eax,1
  sub    esi,eax
  cmp    esi,1
  jbe    OpSqr@exit2
  mov    esi,eax
  mov    ebx,eax
  mov    eax,ecx
  jmp    OpSqr@iterat
fertig:
OpSqr@exit2:
  call   mypush
OpSqr@exit:
  popad
  ret
OpSqr endp

OpNop Proc Near
  ret
OpNop endp

OpAbs Proc Near
  push   eax
  cmp    Ident,'i'
  jne    OpAbs@exit
  call   mypop
  jc     OpAbs@exit
  cmp    eax,0
  jge    OpAbs@exit2
  neg    eax
OpAbs@exit2:
  call   mypush
OpAbs@exit:
  pop    eax
  ret
OpAbs endp

OpNeg Proc Near
  push   eax
  call   mypop
  jc     OpNeg@exit
  neg    eax
  call   mypush
OpNeg@exit:
  pop    eax
  ret
OpNeg endp

OpShl Proc Near
  ret
OpShl endp

OpShr Proc Near
  ret
OpShr endp

OpNot Proc Near
  ret
OpNot endp

OpAnd Proc Near
  ret
OpAnd endp

OpOr Proc Near
  ret
OpOr endp

OpXor Proc Near
  ret
OpXor endp

OpBin Proc Near
  mov    Ident,'b'
  mov    Base,2
  ret
OpBin endp

OpOct Proc Near
  mov    Ident,'o'
  mov    Base,8
  ret
OpOct endp

OpDec Proc Near
  mov    Ident,'d'
  mov    Base,10
  ret
OpDec endp

OpInt Proc Near
  mov    Ident,'i'
  mov    Base,10
  ret
OpInt endp

OpHex Proc Near
  mov    Ident,'h'
  mov    Base,16
  ret
OpHex endp
