unit gra;      {ripped together...sorry guys...just needed something to
                test my recChar on...}
interface
function graphpixel(x,y:word):boolean;
procedure putpixel(x,y:word;col:byte);
procedure Line(x1, y1, x2, y2 : integer; color : byte;segment:word);
Procedure DrawCircle(X, Y, Radius:Word; Color:Byte);
procedure showpcx(sss:string);

implementation
type pcxheader_rec=record
     manufacturer: byte;
     version: byte;
     encoding: byte;
     bits_per_pixel: byte;
     xmin, ymin: word;
     xmax, ymax: word;
     hres: word;
     vres: word;
     palette: array [0..47] of byte;
     reserved: byte;
     colour_planes: byte;
     bytes_per_line: word;
     palette_type: word;
     filler: array [0..57] of byte;
     end;
var header: pcxheader_rec;
    width, depth: word;
    bytes: word;
    palette: array [0..767] of byte;
    f: file;
    c: byte;

function graphpixel(x,y:word):boolean;assembler;
asm
   mov  ax,320
   mul  y
   add  ax,x
   mov  di,ax
   push 0a000h
   pop  es
{   inc  byte ptr es:[di]}
   mov  al,es:[di]
end;

procedure putpixel(x,y:word;col:byte);assembler;
asm
   mov  ax,320
   mul  y
   add  ax,x
   mov  di,ax
   push 0a000h
   pop  es
{   inc  byte ptr es:[di]}
   mov  al,col
   stosb
end;

procedure Line(x1, y1, x2, y2 : integer; color : byte;segment:word);
var i, deltax, deltay, numpixels,
    d, dinc1, dinc2,
    x, xinc1, xinc2,
    y, yinc1, yinc2 : integer;
    screen : word;
    screeninc1, screeninc2 : integer;
begin
  deltax := abs(x2 - x1);
  deltay := abs(y2 - y1);
  if deltax >= deltay then
    begin
      numpixels := deltax + 1;
      d := (2 * deltay) - deltax;
      dinc1 := deltay Shl 1;
      dinc2 := (deltay - deltax) shl 1;
      xinc1 := 1;
      xinc2 := 1;
      yinc1 := 0;
      yinc2 := 1;
    end
  else
    begin
      numpixels := deltay + 1;
      d := (2 * deltax) - deltay;
      dinc1 := deltax Shl 1;
      dinc2 := (deltax - deltay) shl 1;
      xinc1 := 0;
      xinc2 := 1;
      yinc1 := 1;
      yinc2 := 1;
    end;
  if x1 > x2 then
    begin
      xinc1 := - xinc1;
      xinc2 := - xinc2;
    end;
  if y1 > y2 then
    begin
      yinc1 := - yinc1;
      yinc2 := - yinc2;
    end;
  screen := word(y1) * 320 + x1;
  screeninc1 := yinc1 * 320 + xinc1;
  screeninc2 := yinc2 * 320 + xinc2;
  asm
    mov ax,[segment]
    mov es,ax
    mov di, screen
    mov dx, d
    mov al, color
    mov cx, numpixels
    mov bx, dinc1
@bres1:
    mov es:[di], al
    cmp dx, 0
    jnl @bres2
    add dx, bx
    add di, screeninc1
    jmp @bres3
@bres2:
    add dx, dinc2
    add di, screeninc2
@bres3:
    loop @bres1
  end;
end;

Procedure DrawCircle(X, Y, Radius:Word; Color:Byte);
Var
   Xs, Ys    : Integer;
   Da, Db, S : Integer;
begin
     if (Radius = 0) then
          Exit;

     if (Radius = 1) then
     begin
          PutPixel(X, Y, Color);
          Exit;
     end;

     Xs := 0;
     Ys := Radius;

     Repeat
           Da := Sqr(Xs+1) + Sqr(Ys) - Sqr(Radius);
           Db := Sqr(Xs+1) + Sqr(Ys - 1) - Sqr(Radius);
           S  := Da + Db;

           Xs := Xs+1;
           if (S > 0) then
                Ys := Ys - 1;

           PutPixel(X+Xs-1, Y-Ys+1, Color);
           PutPixel(X-Xs+1, Y-Ys+1, Color);
           PutPixel(X+Ys-1, Y-Xs+1, Color);
           PutPixel(X-Ys+1, Y-Xs+1, Color);
           PutPixel(X+Xs-1, Y+Ys-1, Color);
           PutPixel(X-Xs+1, Y+Ys-1, Color);
           PutPixel(X+Ys-1, Y+Xs-1, Color);
           PutPixel(X-Ys+1, Y+Xs-1, Color);
     Until (Xs >= Ys);
end;

procedure Read_PCX_Line(vidoffset: word);
var c, run: byte;
    n: integer;
    w: word;
begin
  n:=0;
  while (n < bytes) do
  begin
    blockread (f, c, 1);

    { if it's a run of bytes field }
    if ((c and 192)=192) then
    begin

      { and off the high bits }
      run:=c and 63;

      { get the run byte }
      blockread (f, c, 1);
      n:=n+run;
      for w:=0 to run-1 do
      begin
        if c=0 then mem [$a000:vidoffset]:=5 else mem [$a000:vidoffset]:=0;
        inc (vidoffset);
      end;
    end else
    begin
      n:=n+1;
      mem [$a000:vidoffset]:=c;
      inc (vidoffset);
    end;
  end;
end;

procedure Unpack_PCX_File;
var i: word;
begin
  for i:=0 to 767 do
    palette [i]:=palette [i] shr 2;
  asm
    mov ax,13h
    int 10h
    mov ax,1012h
    xor bx,bx
    mov cx,256
    mov dx,offset palette
    int 10h
  end;
  for i:=0 to depth-1 do
    Read_PCX_Line (i*320);
end;

procedure showpcx(sss:string);
begin
    assign (f, sss);
    reset (f,1);
    blockread (f, header, sizeof (header));
    if (header.manufacturer=10) and (header.version=5) and
       (header.bits_per_pixel=8) and (header.colour_planes=1) then
    begin
      seek (f, filesize (f)-769);
      blockread (f, c, 1);
      if (c=12) then
      begin
        blockread (f, palette, 768);
        seek (f, 128);
        width:=header.xmax-header.xmin+1;
        depth:=header.ymax-header.ymin+1;
        bytes:=header.bytes_per_line;
        Unpack_PCX_File;
      end else writeln ('Error reading palette.');
    end else writeln ('Not a 256 colour PCX file.');
    close (f);
end;

end.