#include <stdio.h>
#include <graph.h>
#include <conio.h>
#include <malloc.h>
#include <string.h>
#include <dos.h>
#include <time.h>

#define byte unsigned char
#define word unsigned int
#define d_word unsigned long

#define OFF 0
#define ON 1

#define FAILURE 0
#define SUCCESS 1

char path[]={""};

#define goto(x,y) _settextposition(y,x)
#define rnd(n) ((rand() % (int)(((n)+1) - (1))) + (1))

#include "font.h"
#include "graphics.h"
#include "palette.h"
#include "text.h"
#include "mouse.h"

#define TILES 256
#define TILE_X 16
#define TILE_Y 16

/****************************************************************************
function prototypes
****************************************************************************/

void set_screen(void);
byte allocate_memory(void);

byte allocate_tile(void);
void free_tile(void);

void free_memory(void);

void init_mouse(void);
void hide_object(void);
void show_object(byte);

byte tile_color(byte, int, int);
void update_tile_grid(byte);
void update_tile(int, int, byte, byte);
void update_tile_display(byte, byte);

byte load(char *);
byte save(char *);

void hide_cursor(byte, int, int);
void show_cursor(byte, int, int);
void hide_color(byte);
void show_color(byte);
void show_palette_information(byte);

void hflip(byte);
void vflip(byte);
void rotate(byte);

/****************************************************************************
global variables
****************************************************************************/

char palette_file[]={"mode13h"};
char font_file[]={"fnt8-8"};

byte huge **tile;
char tile_file[]={"til16-16"};
byte map[64];
char map_file[]={"map8-8"};

byte huge *object_background;

/****************************************************************************/

void main(void)
{
 int x=0, y=0;
 byte current_tile=0, current_color=7;
 int a, b;
 int key=0;
 int tmp;

 byte current_page=0;
 byte object=OFF, object_carried;
 byte palette_rotation=ON;

 byte compressed=OFF;

/****************************************************************************/

 srand((unsigned)time);

 if (allocate_memory()==FAILURE) goto END;

 if (read_font(font_file)==FAILURE) goto END;

/****************************************************************************/

 _setvideomode(_MRES256COLOR);
 if (read_palette(palette_file)==SUCCESS)
  set_palette();

 set_screen();

 init_mouse();
 show_cursor(current_tile,x,y);
 show_color(current_color);

/****************************************************************************/

 do
 {
  memcpy(SCREEN,screen,(size_t)64000);
  hide_mouse();
  hide_cursor(current_tile,x,y);
  hide_color(current_color);
  if (object)
   hide_object();

  show_palette_information(current_color);
  if (palette_rotation) palette_switch(248,8);

  if (mouse_1)
  {
   ftime(&time_pointer);
   if (mouse_timer<max_mouse_timer)
   {
    mouse_timer+=(d_word)((time_pointer.time*1000+time_pointer.millitm)
		 -old_mouse_timer);
    goto END_MOUSE_CLICK;
   }

   old_mouse_timer=(d_word)(time_pointer.time*1000+time_pointer.millitm);
   max_mouse_timer=(d_word)(mouse_timer+PALETTE_TIMER);

   if (mouse_x>=4 && mouse_x<132 && mouse_y>=4 && mouse_y<132)
   {
    update_tile((mouse_x-4)/8,(mouse_y-4)/8,current_tile,current_color);
   }
   else if (mouse_x>=195 && mouse_x<307 && mouse_y>=180 && mouse_y<196)
   {
    if (object==ON)
    {
     /* copy */
     for (a=0;a<256;a++)
     {
      tile[current_page+(mouse_x-195)/16][a]=tile[object_carried][a];
     }
     update_tile_grid(current_tile);
     object=OFF;
    }
    else
    {
     object=ON;
     object_carried=current_page+(mouse_x-195)/16;
    }
   }
   else if (mouse_x>=188 && mouse_x<316 && mouse_y>=4 && mouse_y<132)
   {
    if (object)
    {
     map[(mouse_y-4)/16*8+(mouse_x-188)/16]=object_carried;
     object=OFF;
    }
    else
    {
     object=ON;
     object_carried=map[(mouse_y-4)/16*8+(mouse_x-188)/16];
    }
   }
   else if (mouse_x>=4 && mouse_x<132 && mouse_y>=136 && mouse_y<200)
   {
    mouse_x-=4; mouse_y-=136;
    current_color=(mouse_y/8)*32+(mouse_x/4);
   }
   else if (mouse_x>=142 && mouse_x<150 && mouse_y>=134 && mouse_y<198)
   {
    /* rem adjust red hue of current color */
    palette[current_color*3+0]=(byte)(197-mouse_y);
    set_palette();
   }
   else if (mouse_x>=156 && mouse_x<164 && mouse_y>=134 && mouse_y<198)
   {
    /* rem adjust green hue of current color */
    palette[current_color*3+1]=(byte)(197-mouse_y);
    set_palette();
   }
   else if (mouse_x>=170 && mouse_x<178 && mouse_y>=134 && mouse_y<198)
   {
    /* rem adjust blue hue of current color */
    palette[current_color*3+2]=(byte)(197-mouse_y);
    set_palette();
   }
   else if (mouse_x>=136 && mouse_x<184 && mouse_y>=68 && mouse_y<76)
   {
    for (a=0;a<256;a++)
     tile[current_tile][a]=0;
    update_tile_grid(current_tile);
   }
   else if (mouse_x>=136 && mouse_x<184 && mouse_y>=76 && mouse_y<84)
   {
    rotate(current_tile);
    update_tile_grid(current_tile);
   }
   else if (mouse_x>=136 && mouse_x<184 && mouse_y>=84 && mouse_y<92)
   {
    hflip(current_tile);
    update_tile_grid(current_tile);
   }
   else if (mouse_x>=136 && mouse_x<184 && mouse_y>=92 && mouse_y<100)
   {
    vflip(current_tile);
    update_tile_grid(current_tile);
   }
   else if (mouse_x>=136 && mouse_x<184 && mouse_y>=100 && mouse_y<108)
   {
     for (a=0;a<256;a++)
      tile[current_tile][a]=(current_color+rnd(4)-rnd(4));
    update_tile_grid(current_tile);
   }
   else if (mouse_x>=188 && mouse_x<195 && mouse_y>=180 && mouse_y<196)
   {
    current_tile--; if (current_tile==255) current_tile=0;
    update_tile_grid(current_tile);
    if (current_tile<current_page)
    {
     current_page--;
    }
   }
   else if (mouse_x>=308 && mouse_x<316 && mouse_y>=180 && mouse_y<196)
   {
    current_tile++; if (current_tile==0) current_tile=255;
    update_tile_grid(current_tile);
    if (current_tile>current_page+6)
    {
     current_page++;
    }
   }
  }
  if (mouse_2)
  {
   ftime(&time_pointer);
   if (mouse_timer<max_mouse_timer)
   {
    mouse_timer+=(d_word)((time_pointer.time*1000+time_pointer.millitm)
		 -old_mouse_timer);
    goto END_MOUSE_CLICK;
   }

   old_mouse_timer=(d_word)(time_pointer.time*1000+time_pointer.millitm);
   max_mouse_timer=(d_word)(mouse_timer+PALETTE_TIMER);

   if (mouse_x>=4 && mouse_x<132 && mouse_y>=4 && mouse_y<132)
   {
    current_color=tile[current_tile][(mouse_y-4)/8*TILE_X+(mouse_x-4)/8];
   }
   else if (mouse_x>=188 && mouse_x<316 && mouse_y>=4 && mouse_y<132)
   {
    current_tile=map[(mouse_y-4)/16*8+(mouse_x-188)/16];
    if (current_tile<current_page) current_page=current_tile;
    else if (current_tile>current_page+6)
    {
     current_page=current_tile-6;
     if (current_page>TILES-7) current_page=TILES-7;
    }
    update_tile_display(current_tile,current_page);
    update_tile_grid(current_tile);
   }
   else if (mouse_x>=195 && mouse_x<307 && mouse_y>=180 && mouse_y<196)
   {
    current_tile=current_page+(mouse_x-195)/16;
    update_tile_display(current_tile,current_page);
    update_tile_grid(current_tile);
   }
  }
END_MOUSE_CLICK:;

  if (kbhit())
  {
   key=getch();
   if (key==0)
   {
    key=getch();
    switch(key)
    {
     case 0x48:y--;break;
     case 0x50:y++;break;
     case 0x4B:x--;break;
     case 0x4D:x++;break;
     case 0x49:current_page--;if (current_page==255) current_page=0;break;
     case 0x51:current_page++;if (current_page>249) current_page=249;break;
    }
    if (x<0) x=TILE_X-1;
    else if (x>=TILE_X) x=0;
    if (y<0) y=TILE_Y-1;
    else if (y>=TILE_Y) y=0;
   }
   else
   {
    switch(key)
    {
     case ' ':update_tile(x,y,current_tile,current_color);break;
     case '=':
     case '+':show_palette_information(++current_color);break;
     case '-':show_palette_information(--current_color);break;
     case '.':
     case '>':current_tile++;if (current_tile==0) current_tile=255;
	      update_tile_grid(current_tile);break;
     case ',':
     case '<':current_tile--;if (current_tile==255) current_tile=0;
	      update_tile_grid(current_tile);break;
     case 'l':load(tile_file);read_palette(palette_file);
	      update_tile_grid(current_tile);break;
     case 's':save(tile_file);write_palette(palette_file);break;
     case 'z':for (a=0;a<256;a++)
	      {
	       tile[current_tile][a]=(current_color+rnd(4)-rnd(4));
	      }
	      update_tile_grid(current_tile);
	      break;
     case 'p':if (palette_rotation) palette_rotation=OFF;
	      else palette_rotation=ON; break;
     case 'h':hflip(current_tile);update_tile_grid(current_tile);break;
     case 'v':vflip(current_tile);update_tile_grid(current_tile);break;
     case 'r':rotate(current_tile);update_tile_grid(current_tile);break;
     case 'f':for (a=0;a<256;a++) tile[current_tile][a]=current_color;
	      update_tile_grid(current_tile);break;
     case 'g':current_color=tile[current_tile][y*TILE_X+x];break;
    }
    if (current_tile<current_page)
    {
     current_page--;
    }
    else if (current_tile>current_page+6)
    {
     current_page++;
    }
   }
  }

 read_mouse();

 update_tile_display(current_tile,current_page);
 put_string(160,28,"   ",4,INVERSE);
 put_number_i(160,28,x,7,NORMAL);
 put_string(160,44,"   ",4,INVERSE);
 put_number_i(160,44,y,7,NORMAL);

 put_string(136,116,"      ",4,INVERSE);
 put_string(160,60,"   ",4,INVERSE);
 if (compressed)
 {
  put_string(136,116,"cmp",7,NORMAL);
 }
 else
 {
  put_string(136,116,"uncmp",7,NORMAL);
  put_number_i(160,60,TILE_X*TILE_Y,7,NORMAL);
 }

 show_cursor(current_tile,x,y);
 show_color(current_color);

 if (object)
  show_object(object_carried);

 update_mouse();

 } while (key!=27);

/****************************************************************************/
DONE:;
 _setvideomode(_DEFAULTMODE);

/****************************************************************************/
END:;
 free_memory();

}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void set_screen(void)
{
 int a, b;

/* rem fill screen with brown (76) pattern */

 _setcolor(76);
 _rectangle(_GFILLINTERIOR,0,0,319,199);
 _setcolor(75);
 _rectangle(_GFILLINTERIOR,1,1,318,202);

/* setup individual windows */

 _setcolor(73);
 _rectangle(_GBORDER,3,3,132,132);
 _rectangle(_GBORDER,135,3,184,132);
 _rectangle(_GBORDER,187,3,316,132);
 _rectangle(_GBORDER,187,135,316,200);
 _rectangle(_GBORDER,3,135,132,200);

 _setcolor(74);
 _rectangle(_GBORDER,2,2,133,133);
 _rectangle(_GBORDER,134,2,185,133);
 _rectangle(_GBORDER,186,2,317,133);
 _rectangle(_GBORDER,186,134,317,201);
 _rectangle(_GBORDER,2,134,133,201);

/* setup palette bar */

 for (b=0;b<8;b++)
 {
  for (a=0;a<32;a++)
  {
   _setcolor(75);
   _rectangle(_GBORDER,a*4+4,b*8+136,a*4+7,b*8+143);
   _setcolor(b*32+a);
   _rectangle(_GFILLINTERIOR,a*4+5,b*8+137,a*4+6,b*8+142);
  }
 }

/* setup palette-information bars */

 _setcolor(74);
 _rectangle(_GFILLINTERIOR,134,134,185,199);
 _setcolor(0);
 _rectangle(_GFILLINTERIOR,142,135,149,198);
 _rectangle(_GFILLINTERIOR,156,135,163,198);
 _rectangle(_GFILLINTERIOR,170,135,177,198);
 _setcolor(75);
 _rectangle(_GBORDER,141,134,150,199);
 _rectangle(_GBORDER,155,134,164,199);
 _rectangle(_GBORDER,169,134,178,199);

/* setup tile drawing grid */

 _setcolor(0);
 _rectangle(_GFILLINTERIOR,4,4,131,131);

 _setcolor(73);
 for (a=0;a<16;a++)
 {
  _moveto(a*8+4,4);
  _lineto(a*8+4,131);
 }
 for (b=0;b<16;b++)
 {
  _moveto(4,b*8+4);
  _lineto(131,b*8+4);
 }

/* setup text info area(s) */

 _setcolor(4);
 _rectangle(_GFILLINTERIOR,136,4,136+47,4+127);
 _rectangle(_GFILLINTERIOR,188,136,188+127,136+63);

/* setup 8x8 tile display area */

 _setcolor(0);
 _rectangle(_GFILLINTERIOR,188,4,315,131);

/* setup 7 tile wide selection area */

 _setcolor(73);
 _rectangle(_GBORDER,194,179,307,196);
 _setcolor(74);
 _rectangle(_GBORDER,193,178,308,197);
 _setcolor(75);
 _rectangle(_GBORDER,192,177,309,198);

 _setcolor(0);
 _rectangle(_GFILLINTERIOR,195,180,306,195);

/* copy video to screen-buffer */

 memcpy(screen,SCREEN,(size_t)64000);

/* setup text entries */

 put_string(136,4,"tile",7,NORMAL);
 put_string(136,20,"x",7,NORMAL);
 put_string(136,36,"y",7,NORMAL);
 put_string(136,52,"size",7,NORMAL);
 put_string(136,68,"clear",7,NORMAL);
 put_string(136,76,"rotate",7,NORMAL);
 put_string(136,84,"flip h",7,NORMAL);
 put_string(136,92,"flip v",7,NORMAL);
 put_string(136,100,"z_fill",7,NORMAL);
/* put_string(136,116,"u/cmp",7,NORMAL); */
/* put_string(136,124,"file",7,NORMAL); */

 put_string(208,136,"Tile Editor",7,NORMAL);
 put_string(188,152,"filename",7,NORMAL);
 put_string(188,168,"filesize",7,NORMAL);

 put_string(252,160,tile_file,7,NORMAL);


}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte allocate_tile(void)
{
 int a;

 tile=(byte huge **)halloc((long)TILES,4);
 if (tile==NULL)
 {
  printf("error allocating tile pointers\n");
  return(FAILURE);
 }

 for (a=0;a<TILES;a++)
 {
  tile[a]=(byte huge *)halloc((long)(TILE_X*TILE_Y),1);
  if (tile[a]==NULL)
  {
   printf("error allocating tile %3d\n",a);
   return(FAILURE);
  }
 }
 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void free_tile(void)
{
 int a;

 for (a=0;a<TILES;a++)
  if (tile[a]!=NULL) hfree(tile[a]);

 if (tile!=NULL) hfree(tile);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte allocate_memory(void)
{
 if (allocate_screen()==FAILURE) return(FAILURE);
 if (allocate_font()==FAILURE) return(FAILURE);
 if (allocate_tile()==FAILURE) return(FAILURE);
 if (allocate_mouse()==FAILURE) return(FAILURE);
 if ((object_background=(byte huge *)halloc(256L,1))==NULL) return(FAILURE);
 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void free_memory(void)
{
 free_mouse();
 free_tile();
 free_font();
 free_screen();
 if (object_background!=NULL) hfree(object_background);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void init_mouse(void)
{
 byte tmp[]={1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,
	     1,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,
	     1,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,
	     1,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,
	     1,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,
	     1,7,7,7,7,7,7,7,7,7,1,0,0,0,0,0,
	     1,7,7,7,7,7,7,7,7,7,7,1,0,0,0,0,
	     1,7,7,7,7,1,1,1,1,1,1,0,0,0,0,0,
	     1,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
	     1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
 memcpy(mouse_cursor,tmp,256);
 read_mouse();
 update_mouse();
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte tile_color(byte current_tile,int x, int y)
{
 return(tile[current_tile][y*TILE_X+x]);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void update_tile_grid(byte current_tile)
{
 int a, b;

 for (b=0;b<16;b++)
 {
  for (a=0;a<16;a++)
  {
   box(FILL,a*8+6,b*8+6,a*8+10,b*8+9,tile[current_tile][b*TILE_X+a]);
  }
 }
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void update_tile(int x, int y, byte current_tile, byte current_color)
{
 tile[current_tile][y*TILE_X+x]=current_color;
 box(FILL,x*8+6,y*8+6,x*8+10,y*8+9,current_color);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void update_tile_display(byte current_tile, byte current_page)
{
 int a, b;

 for (a=0;a<7;a++)
  put_image(195+a*16,180,tile[(byte)(current_page+a)],TILE_X,TILE_Y,NORMAL);

 if (current_tile>=current_page && current_tile<(word)(current_page+7))
  box(BORDER,195+(current_tile-current_page)*16,180,
	     195+(current_tile-current_page)*16+TILE_X-1,180+TILE_Y-1,7);

 for (b=0;b<8;b++)
 {
  for (a=0;a<8;a++)
  {
   put_image(188+a*16,4+b*16,tile[map[b*8+a]],TILE_X,TILE_Y,NORMAL);
  }
 }

 put_string(160,12,"   ",4,INVERSE);
 put_number_i(160,12,current_tile,7,NORMAL);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void hide_cursor(byte current_tile, int x, int y)
{
 box(FILL,x*8+6,y*8+6,x*8+10,y*8+10,tile[current_tile][y*TILE_X+x]);
 box(BORDER,x*8+5,y*8+5,x*8+11,y*8+11,0);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void show_cursor(byte current_tile, int x, int y)
{
 box(BORDER,x*8+5,y*8+5,x*8+11,y*8+11,7);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void hide_color(byte current_color)
{
 int x=(current_color-(current_color/32)*32)*4+4,
     y=(current_color/32)*8+136;
 box(BORDER,x,y,x+3,y+7,75);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void show_color(byte current_color)
{
 int x=(current_color-(current_color/32)*32)*4+4,
     y=(current_color/32)*8+136;
 box(BORDER,x,y,x+3,y+7,7);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void show_palette_information(byte current_color)
{
 byte red=palette[current_color*3+0],
      green=palette[current_color*3+1],
      blue=palette[current_color*3+2];

 box(FILL,142,135,149,197,0);
 box(FILL,156,135,163,197,0);
 box(FILL,170,135,177,197,0);

 if (red>0) box(FILL,142,198-red,149,197,15);
 if (green>0) box(FILL,156,198-green,163,197,23);
 if (blue>0) box(FILL,170,198-blue,177,197,31);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void hide_object(void)
{
 put_image(mouse_x,mouse_y,object_background,TILE_X,TILE_Y,NORMAL);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void show_object(byte object_carried)
{
 get_image(mouse_x,mouse_y,object_background,TILE_X,TILE_Y);
 put_image(mouse_x,mouse_y,tile[object_carried],TILE_X,TILE_Y,MASK);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte load(char *filename)
{
 FILE *file;
 size_t bytes_read;
 char buf[80];
 int a;

 sprintf(buf,"%s%s.til",path,filename);

 file=fopen(buf,"rb");
 if (file==NULL) return(FAILURE);

 for (a=0;a<256;a++)
  bytes_read=fread(tile[a],1,256,file);

 sprintf(buf,"%s%s.dat",path,map_file);
 file=fopen(buf,"rb");
 if (file!=NULL)
 {
  bytes_read=fread(map,1,64,file);
  fclose(file);
 }

 fclose(file);
 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

byte save(char *filename)
{
 FILE *file;
 size_t bytes_written;
 char buf[80];
 int a;

 sprintf(buf,"%s%s.til",path,filename);

 file=fopen(buf,"wb");
 if (file==NULL) return(FAILURE);

 for (a=0;a<256;a++)
  bytes_written=fwrite(tile[a],1,256,file);

 fclose(file);

 sprintf(buf,"%s%s.dat",path,map_file);
 file=fopen(buf,"wb");
 if (file!=NULL)
 {
  bytes_written=fwrite(map,1,64,file);
  fclose(file);
 }

 return(SUCCESS);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void hflip(byte current_tile)
{
 byte tmp[256];
 int a, b;

 for (a=0;a<16;a++)
 {
  for (b=0;b<16;b++)
   tmp[b*TILE_X+a]=tile[current_tile][b*TILE_X+(TILE_X-1-a)];
 }
 memcpy(tile[current_tile],tmp,TILE_X*TILE_Y);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void vflip(byte current_tile)
{
 byte tmp[256];
 int a, b;

 for (b=0;b<16;b++)
 {
  for (a=0;a<16;a++)
   tmp[b*TILE_X+a]=tile[current_tile][(TILE_Y-1-b)*TILE_X+a];
 }
 memcpy(tile[current_tile],tmp,TILE_X*TILE_Y);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

void rotate(byte current_tile)
{
 byte tmp[256];
 int a, b;

 for (a=0;a<16;a++)
 {
  for (b=0;b<16;b++)
   tmp[b*TILE_X+a]=tile[current_tile][(TILE_Y-1-a)*TILE_X+b];
 }
 memcpy(tile[current_tile],tmp,TILE_X*TILE_Y);
}

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

/****************************************************************************/
/****************************************************************************/
/****************************************************************************/


