;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                           ;
; palette resampler - By Jason Nunn(JsNO)/SuperReal & Hornet - Nov 95       ;
; Uses DOS32V32       (jsno@turtle.apana.org.au)                            ;
;                                                                           ;
; Written for my Litchfield park piccys ;) (NB/this is a very quick hack,   ;
; while isn't based on any other formal algo, etc.                          ;
;                                                                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ideal
p386
model flat
stack 1000h
codeseg

extrn debug           : near
Zero_Addr             dd ?
Environment_Address   dd ?
PSP_Address           dd ?
_0B8000h              dd ?

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PALETTE_SIZE          = 256

struc tpal_stat_table
  index_pal           db ?
  r                   db ?
  g                   db ?
  b                   db ?
  tally               dd ?
ends

filename_in           db 64 dup(0)
filename_out          db 64 dup(0)
pal_stat_table        tpal_stat_table PALETTE_SIZE dup(<>)
new_pal_stat_table    tpal_stat_table PALETTE_SIZE dup(<>)
new_pal_stat_table_p  dd 0
target_colours        db 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc write_dec
  mov    ecx,eax
@@dec83:
  mov    eax,ecx
  xor    edx,edx
  div    [dword esi+@@Dec_divider]
  mov    ecx,edx
  add    al,'0'
  mov    [edi],al
  inc    edi
  sub    esi,4
  jge    @@dec83
  ret
@@dec_divider:
  dd 1,10,100,1000
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                           ;
; the qsort algo that sorts our palette statistic table in a descending     ;
; "the most popular colours first" order                                    ;
;                                                                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc qsort_stack
  bp_r                dd ?
  caller              dd ?
  r                   dd ?
  l                   dd ?
ends

; eax = i
; edx = j
; ecx = x
; esi = sort list
proc qsort
  push   ebp
  mov    ebp,esp
  push   eax edx
  mov    eax,[ebp+qsort_stack.l]
  mov    edx,[ebp+qsort_stack.r]
  mov    ebx,eax
  add    ebx,edx
  shr    ebx,1
  mov    ecx,[esi+ebx*8+tpal_stat_table.tally]
@@repeat_loop1:
  cmp    [dword esi+eax*8+tpal_stat_table.tally],ecx
  jle    @@find_list_j_loop ;jge  ;sort decending        <================
  inc    eax
  jmp    @@repeat_loop1
@@find_list_j_loop:
  cmp    ecx,[dword esi+edx*8+tpal_stat_table.tally]
  jle    @@fin_retract      ;jge  ;ditto                <================
  dec    edx
  jmp    @@find_list_j_loop
@@fin_retract:
  cmp    eax,edx
  jg     @@done_sect_sort
  je     @@skip
  mov    edi,[dword esi+eax*8+tpal_stat_table.index_pal]
  mov    ebx,[esi+eax*8+tpal_stat_table.tally]
  xchg   edi,[dword esi+edx*8+tpal_stat_table.index_pal]
  xchg   ebx,[esi+edx*8+tpal_stat_table.tally]
  mov    [dword esi+eax*8+tpal_stat_table.index_pal],edi
  mov    [esi+eax*8+tpal_stat_table.tally],ebx
@@skip:
  inc    eax
  dec    edx
@@done_sect_sort:
  cmp    eax,edx
  jle    @@repeat_loop1
  cmp    [dword ebp+qsort_stack.l],edx
  jge    @@nt1
  push   [dword ebp+qsort_stack.l]
  push   edx
  call   qsort
  add    esp,size qsort_stack-8
@@nt1:
  cmp    eax,[dword ebp+qsort_stack.r]
  jge    @@nt2
  push   eax
  push   [dword ebp+qsort_stack.r]
  call   qsort
  add    esp,size qsort_stack-8
@@nt2:
  pop    edx eax ebp
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                           ;
; here is the crunching code                                                ;
;                                                                           ;
; read the demonews article i wrote on this...                              ;
;                                                                           ;
;                                                                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc display_stat
;do a quick compare to see how many colours are used-------------------
  mov    esi,offset pal_stat_table
  xor    dl,dl
  xor    cl,cl
@@quick_count:
  cmp    [dword esi+tpal_stat_table.tally],0
  je     @@iqc
  inc    dl
@@iqc:
  add    esi,size tpal_stat_table
  add    cl,1
  jnc    @@quick_count

  mov    edi,offset @@mess3
  xor    eax,eax
  mov    al,dl
  mov    esi,4*2
  call   write_dec

  mov    edx,offset @@mess3
  mov    ah,9h
  int    21h
  ret
@@mess3               db "XXX indices used.",13,10,"$"
endp

proc ptoss_mb
  mov    edi,offset @@mess_cn
  xor    eax,eax
  mov    al,[byte target_colours]
  mov    esi,4*2
  call   write_dec

  mov    edx,offset @@mess1
  mov    ah,9h
  int    21h

  mov    eax,size tpal_stat_table
  mul    [dword new_pal_stat_table_p]
  mov    [new_pal_stat_table_p],eax

;load file -----------------------------------------------------------
  mov    edx,offset filename_in
  mov    eax,3d00h
  int    21h
  jc     @@fileerror
  mov    ebx,eax
  mov    eax,4202h
  xor    edx,edx
  int    21h
  push   eax eax
  mov    eax,4200h
  xor    edx,edx
  int    21h
  pop    edx
  mov    eax,0EE42h                              ;mem alloc
  Int    31h
  jc     @@memalloc_error
  mov    esi,edx
  mov    ah,3fh
  pop    ecx
  int    21h
  push   eax
  mov    ah,3eh
  int    21h
  pop    edx
  sub    edx,768
  add    edx,esi
  mov    [@@mb_ptr],esi
  mov    [@@mb_pal],edx

  xor    eax,eax                                 ;calc bitmap size
  xor    ecx,ecx
  mov    ax,[esi]
  mov    cx,[esi+2]
  mul    ecx
  mov    [@@bm_size],eax

;init palette stat tables -------------------------------------------
  mov    edx,offset @@mess2
  mov    ah,9h
  int    21h

  mov    esi,offset pal_stat_table
  mov    edx,[@@mb_pal]
  xor    cl,cl
@@init_it:
  mov    [byte esi+tpal_stat_table.index_pal],cl

  mov    al,[edx]
  mul    [byte target_colours]
  mov    [byte esi+tpal_stat_table.r],ah

  mov    al,[edx+1]
  mul    [byte target_colours]
  mov    [byte esi+tpal_stat_table.g],ah

  mov    al,[edx+2]
  mul    [byte target_colours]
  mov    [byte esi+tpal_stat_table.b],ah

  mov    [dword esi+tpal_stat_table.tally],0
  add    edx,3
  add    esi,size tpal_stat_table
  add    cl,1
  jnc    @@init_it

;build pal stat index table -------------------------------------------
  mov    esi,offset pal_stat_table
  mov    edi,[@@mb_ptr]
  add    edi,4
  mov    ecx,[@@bm_size]
@@build_palstatl:
  xor    eax,eax
  mov    al,[edi]
  inc    edi
  inc    [dword esi+eax*8+tpal_stat_table.tally]
  dec    ecx
  jnz    @@build_palstatl

  call   display_stat

;sort it from highest occurring to lowest -----------------------------
  mov    esi,offset pal_stat_table
  push   0
  push   PALETTE_SIZE-1
  call   qsort
  add    esp,size qsort_stack-8

;elliminate proxys ----------------------------------------------------
;now compare each palette entry with every other palette entry to see if
;we can perform a merger,..starting with the lowest frequency pixels.
  mov    edx,offset @@mess4
  mov    ah,9h
  int    21h
  mov    esi,offset pal_stat_table
  xor    ecx,ecx
@@subject_indice:
  cmp    [dword esi+ecx*8+tpal_stat_table.tally],0
  je     @@next_subject

  xor    eax,eax
  mov    al,[esi+ecx*8+tpal_stat_table.index_pal]
  lea    eax,[eax*2+eax]
  add    eax,[@@mb_pal]
  xor    ebx,ebx
  mov    bl,[eax]
  mov    [@@r_que],ebx
  mov    bl,[eax+1]
  mov    [@@g_que],ebx
  mov    bl,[eax+2]
  mov    [@@b_que],ebx

  mov    ebx,ecx
  inc    ebx
@@cmp_indice:
  cmp    [dword esi+ebx*8+tpal_stat_table.tally],0
  je     @@not_match

  mov    al,[esi+ecx*8+tpal_stat_table.r]
  cmp    al,[esi+ebx*8+tpal_stat_table.r]
  jne    @@not_match
  mov    ah,[esi+ecx*8+tpal_stat_table.g]
  cmp    ah,[esi+ebx*8+tpal_stat_table.g]
  jne    @@not_match
  mov    dl,[esi+ecx*8+tpal_stat_table.b]
  cmp    dl,[esi+ebx*8+tpal_stat_table.b]
  jne    @@not_match
  mov    [dword esi+ebx*8+tpal_stat_table.tally],0
  mov    al,[esi+ebx*8+tpal_stat_table.index_pal]
  mov    al,[esi+ecx*8+tpal_stat_table.index_pal]
  mov    [esi+ebx*8+tpal_stat_table.index_pal],al
@@not_match:
  inc    ebx
  cmp    ebx,PALETTE_SIZE
  jb     @@cmp_indice

  mov    eax,[new_pal_stat_table_p]
  mov    bl,[esi+ecx*8+tpal_stat_table.index_pal]
  mov    [eax+new_pal_stat_table.index_pal],bl
  mov    bl,[byte @@r_que]
  mov    [eax+new_pal_stat_table.r],bl
  mov    bl,[byte @@g_que]
  mov    [eax+new_pal_stat_table.g],bl
  mov    bl,[byte @@b_que]
  mov    [eax+new_pal_stat_table.b],bl
  add    [dword new_pal_stat_table_p],size tpal_stat_table
@@next_subject:
  inc    ecx
  cmp    ecx,PALETTE_SIZE-1
  jb     @@subject_indice

;translate bitmap according to new stat palette ----------------------
  mov    edx,offset @@mess5
  mov    ah,9h
  int    21h

  mov    esi,[@@mb_ptr]
  add    esi,4
  mov    ecx,[@@bm_size]
@@trans_l:
  xor    eax,eax
  mov    al,[esi]
  mov    [byte esi],0
  lea    ebp,[eax*2+eax]
  add    ebp,[@@mb_pal]

  mov    al,[ebp]
  mul    [byte target_colours]
  mov    bl,ah

  mov    al,[ebp+1]
  mul    [byte target_colours]
  mov    bh,ah

  mov    al,[ebp+2]
  mul    [byte target_colours]
  mov    al,ah

  mov    edi,offset pal_stat_table
  xor    dh,dh
@@f_match_rgbl:
  cmp    [dword edi+tpal_stat_table.tally],0
  je     @@f_no_match

  cmp    bl,[edi+tpal_stat_table.r]
  jne    @@f_no_match
  cmp    bh,[edi+tpal_stat_table.g]
  jne    @@f_no_match
  cmp    al,[edi+tpal_stat_table.b]
  jne    @@f_no_match

  mov    ah,[edi+tpal_stat_table.index_pal]
  mov    edi,offset new_pal_stat_table
  xor    dl,dl
@@f_match_newrbg:
  cmp    ah,[edi+tpal_stat_table.index_pal]
  jne    @@f_no_newrgb
  mov    [esi],dl
  jmp    @@index_xlated
@@f_no_newrgb:
  add    edi,size tpal_stat_table
  add    dl,1
  jnc    @@f_match_newrbg

@@f_no_match:
  add    edi,size tpal_stat_table
  add    dh,1
  jnc    @@f_match_rgbl

@@index_xlated:
  inc    esi
  dec    ecx
  jnz    @@trans_l

;save new stat table to palette area ---------------------------------
  mov    esi,offset new_pal_stat_table
  mov    edx,[@@mb_pal]
  xor    cl,cl
@@save_palstat_l:
  mov    al,[esi+tpal_stat_table.r]
  mov    [edx],al
  mov    al,[esi+tpal_stat_table.g]
  mov    [edx+1],al
  mov    al,[esi+tpal_stat_table.b]
  mov    [edx+2],al
  add    edx,3
  add    esi,size tpal_stat_table
  add    cl,1
  jnc    @@save_palstat_l

  call   display_stat

;save file -----------------------------------------------------------
  mov    edx,offset @@mess6
  mov    ah,9h
  int    21h

  mov    edx,offset filename_out
  mov    eax,3c00h
  xor    ecx,ecx
  int    21h
  mov    ebx,eax
  mov    edx,[@@mb_ptr]
  mov    ecx,[@@bm_size]
  add    ecx,4+768
  mov    ah,40h
  int    21h
  mov    ah,3eh
  int    21h

  mov    eax,0EE40h                                 ;delloc src mem
  int    31h

  ret
@@fileerror:
  mov    edx,offset @@mess_fe
  mov    ah,9h
  int    21h
  ret
@@memalloc_error:
  mov    edx,offset @@mess_me
  mov    ah,9h
  int    21h
  ret
@@mb_ptr              dd ?
@@mb_pal              dd ?
@@bm_size             dd ?
@@r_que               dd ?
@@g_que               dd ?
@@b_que               dd ?
@@mess1               db "Palette Resampler - by JsNO/SuperReal & Hornet",13,10
                      db "Loading piccy..",13,10
@@mess_cn             db "XXX colours to fit.",13,10,"$"
@@mess2               db "Resampling palette indices and constructing histogram.",13,10,"$"
@@mess4               db "Eliminating used indices.",13,10,"$"
@@mess5               db "Translating bitmap to new index.",13,10,"$"
@@mess6               db "Saving new piccy.",13,10,"$"
@@mess_fe             db "File not found.",13,10,"$"
@@mess_me             db "File is too big. Can't load it contingiously..sorry.",13,10,"$"
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc get_vnib
  xor    ebx,ebx
@@find_com_loop:
  mov    al,[byte ebx+@@nibble_display]
  cmp    al,[byte edi]
  je     @@num_found
  add    al,"a"-"A"
  cmp    al,[byte edi]
  je     @@num_found
  inc    ebx
  cmp    ebx,16
  jb     @@find_com_loop
  xor    bl,bl
@@num_found:
  add    edi,1
  ret
@@nibble_display      db "0123456789ABCDEF"
endp

proc get_vbyte
  call   get_vnib
  push   ebx
  call   get_vnib
  pop    eax
  shl    al,4
  and    bl,1111b
  or     al,bl
  ret
endp

proc search_param
  mov    bx,"s-"
  call   @@get_parm
  jnc    @@set_start
@@next:
  mov    bx,"c-"
  call   @@get_parm
  jnc    @@set_colours
  mov    edx,offset @@help_mess
  mov    ah,9h
  int    21h
  stc
  ret
@@set_start:
  add    edi,2
  call   get_vbyte
  mov    [byte new_pal_stat_table_p],al
  jmp    @@next
@@set_colours:
  add    edi,2
  call   get_vbyte
  mov    [target_colours],al

  call   @@fin_fn
  mov    esi,offset filename_in
  call   @@cp_fn

  call   @@fin_fn
  mov    esi,offset filename_out
  call   @@cp_fn

  clc
  ret
proc @@get_parm
  mov    edi,[PSP_Address]
  add    edi,81h
  mov    cl,128
@@l:
  cmp    bx,[word edi]
  je     @@found
  cmp    [byte edi],13
  je     @@eol
  inc    edi
  dec    cl
  jnz    @@l
@@eol:
  stc
  ret
@@found:
  mov    al,[byte edi+2]
  clc
  ret
endp
proc @@fin_fn
@@find_fi:
  cmp    [byte edi],32
  jne    @@found_fi
  inc    edi
  dec    cl
  jnz    @@find_fi
@@found_fi:
  ret
endp
proc @@cp_fn
@@cp_fl:
  mov    al,[edi]
  cmp    [byte edi],32
  je     @@eol_fl
  cmp    [byte edi],13
  je     @@eol_fl
  mov    [esi],al
  inc    esi
  inc    edi
  dec    cl
  jnz    @@cp_fl
@@eol_fl:
  inc    edi
  ret
endp
@@help_mess           db 13,10,"COMMAND LINE: PRESAMP -sXX -cXX <filein>.VGA <fileout>.VGA",13,10,"$"
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Start:
;  call   debug
  cld
  mov    ax,0EE02h                                  ; get DOS32 info
  int    31h
  neg    ebx
  mov    [Zero_Addr],ebx
  add    ebx,0B8000h
  mov    [_0B8000h],ebx
  mov    [Environment_Address],edi
  mov    [PSP_Address],esi

  call   search_param
  jc     @@end
  call   ptoss_mb
@@end:
  mov    eax,4c00h
  int    21h
ends

end Start
