#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include "3dtools.h"
#include "mode13h.h"

//////// showasc.cpp - 3dStudio .asc file viewer
     //  by Zach Mortensen [Voltaire/OTM]
    //   compile using: 
   //    wcl386 /mf /oneat /5r /d2 showasc.cpp 3dtools.obj sin.obj mode13h.obj
  //
 //      a nasty GPF appears without the /d2 switch...THIS IS NOT MY FAULT!
//////// Ask WATCOM why a GP fault would disappear with a debug compile...  


void main(int argc, char *argv[])
{
    FILE *inFile;
    int tempInt, vertices, faces, count, vNum, tempA, tempB, tempC;
    char tempChar;
    float tempX, tempY, tempZ;
    unsigned long tIn, tOut, *timer;
    int shades, dist;

    if (argc < 2)
    {
        printf("USAGE:  showasc <filename.asc> <shading> <distance>\n");
        printf("\nshading:  0 = none; 1 = lambert; 2 = gouraud\n");
        printf("distance: distance between object and eye\n");
        exit(1);
    }

    if (argc > 2)
        shades = atoi(argv[2]);
    else
        shades = sGouraud;

    if (argc > 3)
        dist = atoi(argv[3]);
    else
        dist = 4096;

    char *tempStr = new char [80];
    char *virtScreen = new char [64000];        // virtual page
    short *zBuffer = new short[64000];          // z-buffer
    obj3d *test = new obj3d(0, 0, dist);        // object #1 
    obj3d *test2 = new obj3d(0, 0, dist);       // object #2

    inFile = fopen(argv[1], "rt");
    if (inFile == NULL)
    {
        printf("%s does not exist!\n", argv[1]);
        printf("USAGE:  showasc <filename.asc>\n");
        exit(3);
    }

    // parse the input file, get the object data we're after

    while (strncmp(tempStr, "Vertices", 8))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Vertex\" NOT FOUND!!\n");
            exit(2);
        }
    }

    printf("Found string: %s\n", tempStr);

    tempChar = fgetc(inFile);

    fscanf(inFile, "%d", &vertices);

    printf("Object has %d vertices\n", vertices);

    while (strncmp(tempStr, "Faces", 5))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Faces\" NOT FOUND!!\n");
            exit(2);
        }
    }

    printf("Found string: %s\n", tempStr);

    tempChar = fgetc(inFile);

    fscanf(inFile, "%d", &faces);

    printf("Object has %d faces\n", faces);

    while (strncmp(tempStr, "Vertex", 6))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Vertex\" NOT FOUND!!\n");
            exit(2);
        }
    }

    while (strncmp(tempStr, "list:", 5))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"list:\" NOT FOUND!!\n");
            exit(2);
        }
    }



    printf("\nVertex data:\n");

    tempStr = "blah blah blah";

    for (count = 0; count < vertices; count++)
    {
        while (strncmp(tempStr, "Vertex", 6))
        {
            fscanf(inFile, "%s", tempStr);
            if (feof(inFile))
            {
                printf("End-o-FILE and string \"Vertex\" NOT FOUND!!\n");
                exit(2);
            }
        }

        fscanf(inFile, "%d", &vNum);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%f", &tempX);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%f", &tempY);
        fscanf(inFile, "%s", tempStr);
        fscanf(inFile, "%f", &tempZ);

        printf("Vertex %d:  %8d %8d %8d\n", vNum, (int) tempX, (int) tempY, (int) tempZ);

        // add points to objects

        test->addLocalPoint((int) tempX, (int) tempY, (int) tempZ);
        test2->addLocalPoint((int) tempX, (int) tempY, (int) tempZ);
    }

    while (strncmp(tempStr, "Face", 4))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"Face\" NOT FOUND!!\n");
            exit(2);
        }
    }

    printf("\nFound string: %s\n", tempStr);

    while (strncmp(tempStr, "list", 4))
    {
        fscanf(inFile, "%s", tempStr);
        if (feof(inFile))
        {
            printf("End-o-FILE and string \"list\" NOT FOUND!!\n");
            exit(2);
        }
    }

    printf("Found string: %s\n", tempStr);

    printf("\nFacial data:\n");

    for (count = 0; count < faces; count++)
    {
        while (strncmp(tempStr, "Face", 4))
        {
            fscanf(inFile, "%s", tempStr);
            if (feof(inFile))
            {
                printf("End-o-FILE and string \"Face\" NOT FOUND!!\n");
                exit(2);
            }
        }

        fscanf(inFile, "%d", &vNum);
        fscanf(inFile, "%s", tempStr);

        while (fgetc(inFile) != 'A');
        fgetc(inFile);                  // get the ':' character
        fscanf(inFile, "%d", &tempA);   // get value for vertex A

        while (fgetc(inFile) != 'B');
        fgetc(inFile);
        fscanf(inFile, "%d", &tempB);

        while (fgetc(inFile) != 'C');
        fgetc(inFile);
        fscanf(inFile, "%d", &tempC);

        printf("Face %d:  %8d %8d %8d\n", vNum, (int) tempA, (int) tempB, (int) tempC);

        // add faces to objects

        test->addLocalPoly(tempA, tempB, tempC, 1);
        test2->addLocalPoly(tempA, tempB, tempC, 32);
    }

    // setup video mode, page flipping, z-buffer

    setMode13h(virtScreen, zBuffer);

    // set two color ranges in the palette

    for (count = 1; count < 20; count++)
    {
        set_dac_register(count, count, count + 5,
            count + 15);
        set_dac_register(count + 30, 15 + count, 5 + count,
            count);
    }

    // set shading and facing data for objects

    for (count = 0; count < test->numPolys; count++)
    {
        test->poly[count]->shading = shades;
        test2->poly[count]->shading = shades;

        test->poly[count]->facing  = fOutside;
        test2->poly[count]->facing  = fOutside;
    }

    // create gouraud shading normals if we need them

    if (shades == sGouraud)
    {
        test->setGNormals();
        test2->setGNormals();
    }

    // rotate the second object 90 degrees about its z-axis

    test2->matRotate(0, 0, 90);

    // show the objects

    test->display();
    test2->display();

    getch();

    // set up for offscreen drawing

    setActivePage(pVirtual);

    // get timer ticks

    timer = (unsigned long *) 0x046c;
    tIn = *timer;

    // loop de loop...

    for (count = 1; (count <= 1000) && !kbhit(); count++)
    {
        // rotate our two objects

        test->matRotate(-2, 4, -6);
        test2->matRotate(-5, 5, 1);

        // clear the screen

        clearScreen(0);

        // draw the objects to the virtual page

        test->display();
        test2->display();

        // show the virtual page so we can see what we have done

        flipVPage();
    }

    // get timer ticks

	tOut = *timer;

    // read keypress if we need to

	if (count < 1000)
        getch();


    // back to text mode

    textMode();

    // print timing info

    printf("%f frames per second\n", (float) ((count * 18.2) / (tOut - tIn)));

    // clean up a bit

    fclose(inFile);
    delete test;
    delete test2;
    delete virtScreen;
    delete zBuffer;

    exit(0);
}

