/* WAVPLAY.CPP

   Coded by Francis Reynders (Python of Genetrix)
		and Olivier Jacquet  (Jax    of Genetrix)

   March 1997

   This code may be freely distributed and used for any
   purposes as long as my name is mentioned.
   Thanks to Mark Feldman and Draeden for there tutorials.

   This is a very basic WAV player.
   It allocates 3*64K so 2 full pages of 64K are available
   It uses DMA transfer of one buffer while the other gets
   loaded from disk.

   Compilation: BorlandC, compact memory model
				** INVARIANT CODE MOTION must be off **
				** (options->compiler->optimisation) **

   Bugs: - datalength isn't always correct
		   That's no problem since the file gets read
		   till EOF
		 - maybe others...

   How to find me:	Home:   http://student.vub.ac.be/~freynder
					E-mail: freynder@is1.vub.ac.be
							(feel free to drop in a message)

   Other Genetrix Member:   http://student.vub.ac.be/~ojacquet
							ojacquet@is1.vub.ac.be

   The latest Genetrix releases are always available at my
   homepage. */

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <alloc.h>
#include <string.h>
#include <io.h>

int PORT=2;		    // port 220h
int IRQN=7;     	// IRQ  7
int DMA=1;		    // DMA  1
int DMA_PAGE;
int IRQ;

int RESET;
int READ;
int WRITE;
int DATA;


unsigned char far *buffer;
unsigned char cont;
FILE *file;

struct wavheader
{
	char rId[4];
	unsigned long rLen;
	char wId[4];
	char fId[4];
	unsigned long fLen;
	unsigned int wFormatTag;
	unsigned int nChannels;
	unsigned int nSamplesPerSec;
	unsigned int nAvgBytesPerSec;
	unsigned int nBlockAlign;
	unsigned int FormatSpecific;
	char dId[4];
	unsigned long dLen;
}	header;

void interrupt far (*old)(...);

void interrupt far handler(...)
{
	inportb(DATA);
	cont++;
	outportb(0x20,0x20);
}


int main(int argno,char *arg[])
{
	unsigned char search_page(unsigned char far *adress);
	void error(int errno);
	int  check_wav(void);
	int reset_DSP(void);
	void write_DSP(unsigned char value);

	unsigned char far *actualbuffer,*backgroundbuffer,*temp;
	unsigned char page,bpage,temp2,timeconstant,lo,hi,interrupts;
	unsigned int length;
	unsigned long counter;

	// Check if enough parameters
	if(argno<2) error(1);
	if(argno>2)
		IRQN=*arg[2]-48;
	if(argno>3)
		DMA=*arg[3]-48;
	IRQ=IRQN+8;
	if(argno>4)
		PORT=*arg[4]-48;

	// Setting up DMA parameters
	switch(DMA)
	{
		case 0:	DMA_PAGE=0x87;
				break;
		case 1: DMA_PAGE=0x83;
				break;
		case 2:	DMA_PAGE=0x81;
				break;
		case 3:	DMA_PAGE=0x82;
				break;
		default:error(6);
	}

	// Setting up Ports
	RESET=PORT*0x10+0x200+0x6;
	READ=PORT*0x10+0x200+0xA;
	WRITE=PORT*0x10+0x200+0xC;
	DATA=PORT*0x10+0x200+0xE;

	// Show information
	printf("WAVPLAYER by Genetrix\n\n");
	printf("Playing: %s",arg[1]);
	printf("\nPort:%Xh Interrupt:%d DMA-channel:%d",RESET-6,IRQN,DMA);
	printf("\n\nhttp://student.vub.ac.be/~freynder freynder@is1.vub.ac.be (Python)\n");
	printf("http://student.vub.ac.be/~ojacquet ojacquet@is1.vub.ac.be (Jax)\n");

	// Allocate 128k for each buffer
	buffer=(unsigned char far *)farmalloc(0x30000);
	if(buffer==NULL) error(2);

	// Set pointer of buffers to beginning of 64k page
	page=search_page(buffer);

	// Open Wav-file
	file=fopen(arg[1],"rb");
	if(file==NULL) error(3);

	// Read Header
	fread(&header,1,32,file);
	fseek(file,20+header.fLen,SEEK_SET);
	fread(header.dId,1,8,file);

	// Check if Wav-format
	if(check_wav()==0) error(4);

	// Reset SB
	if(reset_DSP()==0) error(5);

	// Turn Speakers on
	write_DSP(0xD1);

	// Set variables
	bpage=page+1;
	actualbuffer=(unsigned char far *)MK_FP(page*0x1000,0);
	backgroundbuffer=(unsigned char far *)MK_FP(bpage*0x1000,0);
	timeconstant=256-(1000000L/(header.nSamplesPerSec*header.nChannels));
	cont=1;

	// Setup interrupt
	old=getvect(IRQ);
	setvect(IRQ,handler);
	interrupts=inportb(0x21);
	outportb(0x21,~(1<<IRQN)&interrupts);       // Set interrupt mask off

	// Main loop
	while(!feof(file))
	{
		//read data in actualbuffer
		counter=0L;
		while((counter<0x10000L)&&(!feof(file)))
		{
			*(actualbuffer+counter)=fgetc(file);
			counter++;
		}

		length=(unsigned int)(counter-1);
		asm{
			mov ax,length
			mov hi,ah
			mov lo,al
			}

		while(!cont);	//wait for interrupt
		cont=0;

		//setup DMA transfer for 64k transfer
		outportb(0x0A,4+DMA);
		outportb(0x0C,0);
		outportb(0x0B,0x48+DMA);
		outportb(DMA*2,0);
		outportb(DMA*2,0);
		outportb(DMA_PAGE,page);
		outportb(DMA*2+1,lo);
		outportb(DMA*2+1,hi);
		outportb(0x0A,1);

		//write to DSP
		write_DSP(0x40);
		write_DSP(timeconstant);
		write_DSP(0x14);
		write_DSP(lo);
		write_DSP(hi);		  // Now the DMA transfer starts

		temp=actualbuffer;    // Switch buffers
		actualbuffer=backgroundbuffer;
		backgroundbuffer=temp;
		temp2=page;
		page=bpage;
		bpage=temp2;
	}

	while(!cont);			  //wait for interrupt

	// Restore interrupt
	setvect(IRQ,old);
	outportb(0x21,interrupts);

	// Reset SB
	reset_DSP();

	// Close file and free up memory
	fclose(file);
	farfree(buffer);

	return 0;
}

int check_wav(void)
{
	char b[16]="RIFFWAVEfmtdata";
	char a[16];
	int c;
	for(c=0;c<4;c++)
		a[c]=header.rId[c];
	for(c=4;c<8;c++)
		a[c]=header.wId[c-4];
	for(c=8;c<11;c++)
		a[c]=header.fId[c-8];
	for(c=11;c<15;c++)
		a[c]=header.dId[c-11];
	a[15]=NULL;
	if(strcmp(a,b)!=0) return 0;
	return 1;
}

unsigned char search_page(unsigned char far *adress)
{
	unsigned char page;
	unsigned int f_segment,f_offset;
	f_segment=FP_SEG(adress);
	f_offset=FP_OFF(adress);
	asm{
		pusha
		mov dx,f_segment
		mov ax,f_offset

		mov bl,dh
		shr bl,4            // get upper 4 bits in bl

		shl dx,4			// get lower 12 bits in dx
		add ax,dx           // add dx with offset
		adc bl,1            // add carry + 1 in bl
		mov page,bl         // bl is now a page with at least
		popa                // 64k free (maximum DMA transfer)
		}
	return page;
}

void error(int errno)
{
	switch(errno)
	{
		case 1:	printf("Not enough parameters\n\n");
				break;
		case 2: printf("Not enough base memory\n\n");
				break;
		case 3: printf("Unable to open file\n\n");
				break;
		case 4: printf("Wrong file format\n\n");
				break;
		case 5: printf("Wrong SB settings\n\n");
				break;
		case 6: printf("Wrong DMA setting must be 0-3");
				break;
		default:printf("Undefined error\n\n");
	}
	exit(errno);
}

int reset_DSP(void)
{
	outportb(RESET,1);
	delay(10);
	outportb(RESET,0);
	delay(10);
	if(((inportb(DATA)&0x80)==0x80)&&(inportb(READ)==0xAA)) return 1;
	return 0;
}

void write_DSP(unsigned char value)
{
	while((inportb(WRITE)&0x80)!=0);
	outportb(WRITE,value);
}

