;            ͻ
;                   FILES.ASM       
;                                                               
;                          Useless Files Manager                
;            ĺ
;               By Freddy Vtel (FreddyV/Useless)              
;                                                               
;               Code Starts .................. 31/03/1996       
;               Last Update .................. 28/06/1997       
;            ͼ
.386p
INCLUDE OS.INC

CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME  CS:CODE32,DS:CODE32,ES:CODE32

INCLUDE ERR_CODE.INC
INCLUDE FILES.INC

INCLUDE UTILS.INC

;=============================================================================

;͸
;  fopen: Open a file                                                     
;                                                                         
; Input: EDX, pointer to the file name (terminated with a 0)              
;        AL,  Access mode (00h read only, 01h write only, 02 read/write ) 
;                                                                         
; Output: CF Set=> Error                                                  
;         AX returns the error number                                     
;                                                                         
;         CF Clear                                                        
;         AX file handle                                                  
;
fopen proc
if (OS EQ KERNEL)
        call FileOpen
        jc Ferror
else
        mov ah,3Dh      ; open a file function
        int 21h
        jc ferror
endif
        ret
fopen endp

;͸
;  fcreate: Create a file                                                 
;                                                                         
; Input: EDX, pointer to the file name (terminated with a 0)              
;                                                                         
; Output: CF Set=> Error                                                  
;         AX returns the error number                                     
;                                                                         
;         CF Clear                                                        
;         AX file handle                                                  
;
fcreate proc
if (OS EQ KERNEL)
        call FileCreate
        jc ferror
else
        mov ax,3C02h            ; creat a file function
        xor ecx,ecx
        int 21h
        jc ferror
endif
        ret
fcreate endp

;͸
;  fclose: Close a file                                                   
;                                                                         
; Input: BX, file handle                                                  
;                                                                         
; Output: CF Set=> Error                                                  
;         AX returns the error number                                     
;                                                                         
;
fclose proc
if (OS EQ KERNEL)
        call FileClose
        jc ferror
else
        mov ah,03Eh         ; close a file function
        int 21h
        jc ferror
endif
        ret
fclose endp

;͸
;  fsetpos: Set/read the file pos                                         
;                                                                         
; Input: AL  origin of move                                               
;         00h start of file                                               
;         01h current file position                                       
;         02h end of file                                                 
;        BX  file handle                                                  
;        EDX  offset from origin of new file position                     
;                                                                         
; Output: CF Set=> Error                                                  
;         AX returns the error number                                     
;                                                                         
;         CF Clear                                                        
;         EAX new file position in bytes from start of file               
;                                                                         
;         Warning: Seek is alwas from begin with KERNEL 386               
;
fsetpos proc
If _DPMI
        mov ecx,edx     ; Convert EDX to CX:DX (for DPMI compliant extenders)
        shr ecx,16
        mov ah,42h
        int 21h
        jc ferror
elseif (OS EQ KERNEL)
        mov eax,edx
        call FileSeek
        jc ferror
else
        mov ah,42h
        int 21h
        jc ferror
endif        
        ret
fsetpos endp

;͸
;  fread: read from the file                                              
;                                                                         
; Input: EDX bufer offset                                                 
;        ECX Length of the buffer                                         
;        BX  file handle                                                  
;                                                                         
; Output: CF Set=> Error                                                  
;         AX returns the error number                                     
;
fread  proc
if (OS EQ KERNEL)
        call FileRead
        jc ferror
else
        mov ah,3Fh
        int 21h
        jc ferror
endif
        ret
fread endp

;͸
;  fwrite: write to the file                                              
;                                                                         
; Input: EDX bufer offset                                                 
;        ECX Length of the buffer                                         
;        BX  file handle                                                  
;                                                                         
; Output: CF Set=> Error                                                  
;         AX returns the error number                                     
;
fwrite proc
if (OS EQ KERNEL)
        call FileWrite
        jc ferror
else
        mov ah,40h
        int 21h
        jc ferror
endif        
        ret
fwrite endp

ferror proc
        movzx eax,al
        cmp al,7
        jb ferrorEnd
        mov al,1        
ferrorEnd:
        add ax,File_Error
        stc
        ret
ferror Endp

CODE32 ENDS
;=============================================================================
end
; FILES.ASM (c) 1997 FreddyV/Useless