/***************************************************************************
*	NAME:  PATCH.H
**	COPYRIGHT:
**	"Copyright (c) 1991,1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 07/01/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>		1/98	   pcburns      Modified for djgpp
***************************************************************************/
#ifndef _PATCH_H_
#define _PATCH_H_
#include "types.h"

#pragma pack(1)

#define ENVELOPES	6	

/* This is the definition for what FORTE's patch format is. All .PAT */
/* files will have this format. */

#define HEADER_SIZE	           12
#define ID_SIZE		           10
#define DESC_SIZE 	           60
#define RESERVED_SIZE	           40 /* 40 */
#define PATCH_HEADER_RESERVED_SIZE 36
#define LAYER_RESERVED_SIZE	   40
#define PATCH_DATA_RESERVED_SIZE   36
#define GF1_HEADER_TEXT	           "GF1PATCH110"

typedef struct /* 129 = 0x81*/
{
  char	 header[ HEADER_SIZE ];	  /* "GF1PATCH110" */
  char	 gravis_id[ ID_SIZE ];	  /* "ID#000002" */
  char	 description[ DESC_SIZE ];
  ubyte	 instruments; 
  ubyte  voices;      
  ubyte  channels; 
  uword	 wave_forms; 
  uword	 master_volume;
  udword data_size;
  char   reserved[ PATCH_DATA_RESERVED_SIZE ];
}  PATCHHEADER;

typedef struct /* 63 = 0x3f */
{
  uword	 instrument;
  char   instrument_name[16];
  sdword instrument_size;
  sbyte  layers;
  char   reserved[ RESERVED_SIZE ];	
} INSTRUMENTDATA;

typedef struct /* 47 = 0x2f */
{
  ubyte  layer_duplicate;
  ubyte  layer;
  sdword layer_size;
  ubyte  samples;
  char   reserved[ LAYER_RESERVED_SIZE ];	
} LAYERDATA;

typedef struct /* 96 = 0x60*/
{
  char   wave_name[7];  
  ubyte	 fractions;
  udword wave_size;
  udword start_loop;
  udword end_loop;
  uword	 sample_rate; 
  udword low_frequency;
  udword high_frequency;
  udword root_frequency;
  sword  tune;
  ubyte  balance;
  ubyte	 envelope_rate[ ENVELOPES ];
  ubyte	 envelope_offset[ ENVELOPES ];
  ubyte	 tremolo_sweep;
  ubyte  tremolo_rate;
  ubyte  tremolo_depth;
  ubyte  vibrato_sweep;
  ubyte  vibrato_rate;
  ubyte  vibrato_depth;
  ubyte  modes;  
  uword  scale_frequency;
  uword  scale_factor;             /* from 0 to 2048 or 0 to 2 */
  char   reserved[ PATCH_DATA_RESERVED_SIZE ];
} PATCHDATA;

/* MODES */
/* bit 0 = 8 or 16 bit wave data. */
/* bit 1 = Signed - Unsigned data. */
/* bit 2 = looping enabled-1. */
/* bit 3 = Set is bidirectional looping. */
/* bit 4 = Set is looping backward. */
/* bit 5 = Turn sustaining on. (Env. pts. 3)*/
/* bit 6 = Enable envelopes - 1 */

#pragma pack()

#endif
