// this is ncmod -- an NCURSES interface for playing modules
// $Id: ncmod.cc,v 0.1 1998/06/08 01:21:05 pcburns Exp pcburns $
// $Log: ncmod.cc,v $
// Revision 0.1  1998/06/08 01:21:05  pcburns
// initial release
#include <unistd.h>
#include <stdlib.h>
#include <ncurses.h>
#include <signum.h>

#include "dsp.h"
#include "module.h"
#include "player.h"

// POSITIONS FOR CALLBACK STUFF TO UPDATE SCREEN
#define ORDER_X 28
#define BPM_X   19
#define SPEED_X  9
#define GV_X    54

class ncplayer : public player
{
public:
  ncplayer();
  ~ncplayer();

  void callback_order(void);
  void callback_bpm(void);
  void callback_speed(void);  
  void callback_gv(void);
  void callback_end(void);

  // channel callbacks
  //void callback_ch_volume(int ch);
  //void callback_ch_note(int ch);
  //void callback_ch_smp(int ch);
  //void callback_ch_inst(int ch);  

  void callback_error(const char *s);
  
  void niceline(void);
};

char *note_to_string(byte note);

int main(int argc, char **argv)
{
  int j;
  ncplayer p;
  
  if (argc <= 1) 
    {
      printw("usage : %s sample_file\n", argv[0]);
      curs_set(1);
      refresh();
      exit(-1);
    }

  for (j = 0; j < argc; j++) 
    {
      Module *mod = new Module;  
      if (!mod->is_module(argv[j]))
	continue;
      if (!mod->load(argv[j]))
	{
	  printw("error: %s\n", mod->error_message);
	  refresh();
	  continue;
	}
      move(0,0);
      p.niceline();
      printw("\nFile : %-31s Name : %-31s\n", argv[j], mod->name);
#if 0
      // display some pattern data
      for (int i = 0; i < mod->rows[mod->order[0]]; i++)
	{
	  printw("%.2x ", i);
	  for (int k = 0; k < 4/*mod->channels*/; k++)
	    {
	      Note n = mod->PatternData[mod->order[0]][k][i];
	      printw("| %s ", note_to_string(n.NoteNum));
	      if (n.number)
		printw("%.2X ",n.number);
	      else
		printw("-- ");
	      if (n.volume)
		printw("%.2X ", n.volume-1);
	      else
		printw("-- ");
	      if (n.effect || n.effParam)
		printw("%.2X%.2X ",n.effect,n.effParam);
	      else
		printw("---- ");		  
	    }
	  printw("|\n");
	  refresh();
	}
#endif
      p.set_mod(mod);
      move(2,0);
      printw("chan %2d", mod->channels);
      refresh();
      if (p.error)
	{
	  move(3,0);
	  printw("player error\n");
	  refresh();
	  return 1;
	}      
      p.play();      
      byte paused = 0;
      while (char c = getch())
	{
	  if (c=='q') // quit
	    break;
	  switch (c)
	    {
	    case ' ': // pause playback
	    case 'p':
	      if (paused)
		{
		  p.play();
		  paused = 0;
		}
	      else
		{
		  p.pause();
		  paused = 1;
		}
	      break;
	    case 'r': // restart
	      p.stop();
	      p.play();
	      break;
	    default:
	      break;
	    }
	} 
      p.stop();
      p.release_mod();
    }
  curs_set(1);
  refresh();
  exit(0);
}

char *note_to_string(byte note)
{
  char *str = (char *)malloc(4);
  if (!note)
    return "---";
  if (note == 254)
    return "^^^";
  switch ((note-1) % 12)
    {
    case 0: 
      str[0] = 'C'; str[1] = '-';
      break;
    case 1:
      str[0] = 'C'; str[1] = '#';
      break;
    case 2:
      str[0] = 'D'; str[1] = '-';
      break;
    case 3:
      str[0] = 'D'; str[1] = '#';
      break;
    case 4:
      str[0] = 'E'; str[1] = '-';
      break;
    case 5:
      str[0] = 'F'; str[1] = '-';
      break;
    case 6:
      str[0] = 'F'; str[1] = '#';
      break;
    case 7:
      str[0] = 'G'; str[1] = '-';
      break;
    case 8:
      str[0] = 'G'; str[1] = '#';
      break;
    case 9:
      str[0] = 'A'; str[1] = '-';
      break;
    case 10:
      str[0] = 'A'; str[1] = '#';
      break;
    case 11:
      str[0] = 'B'; str[1] = '-';
      break;
    default:      
      return "---";
    }   
  str[2] = (char)((note / 12) + '0');
  str[3] = 0;
  return str;
}

ncplayer::ncplayer()
{
  // set up ncurses screen
  initscr();
  cbreak();
  noecho();
  //  timeout(-1);
  nonl();
  nodelay(stdscr,TRUE);
  keypad(stdscr,TRUE);
  curs_set(0); // hide the cursor
}

ncplayer::~ncplayer()
{
  curs_set(1); // display cursor
  refresh();
  endwin();
}

void ncplayer::callback_order(void)
{
  move(2,ORDER_X);
  printw("order %2X/%2X  pattern %2X", order, mod->SongLength-1, pattern);
  refresh();
}

void ncplayer::callback_bpm(void)
{
  move(2,BPM_X);
  printw("bpm %3d", bpm);
  refresh();
}

void ncplayer::callback_speed(void)
{
  move(2,SPEED_X);
  printw("speed %2d", speed);
  refresh();
}

void ncplayer::callback_gv(void)
{
  move(2,GV_X);
  printw("gv %2X", gv);
  refresh();
}

void ncplayer::callback_end(void)
{
  // loop or stop ?
  // tell my parent to stop me !
  //  _exit(0);
}

// draw a horizontal line
void ncplayer::niceline(void)
{
  addch('*');
  for (int i = 76; i--;)
    addch(ACS_HLINE);
  addch('*');

  refresh();
}

void ncplayer::callback_error(const char *s)
{
  move(4,0);
  printw(s);
  refresh();
}
