/* -*-c++-*-*/
#ifndef _INSTRUMENT_H_
#define _INSTRUMENT_H_
#include "sample.h"
#include "types.h"

typedef struct
{
  ubyte points;
  ubyte sustain;
  ubyte loop_start;
  ubyte loop_end;
  uword type; 
  uword fadeout;
  uword envelope[24]; /* change this to byte *Envelope ? */

  // values for Type
  static const uword ENABLED = 1;
  static const uword SUSTAIN = 2;
  static const uword LOOP    = 4;
} Parameters;

typedef struct
{
  ubyte type;
  ubyte sweep;
  ubyte depth;
  ubyte rate;
} Vibe;

class Instrument
{
public:
  Instrument(void);
  ~Instrument(void);

  // generic
  int load(const char *filename);
  int save(const char *filename);

  bool is_instrument(const char *filename);
  int dump(void);

  // specific
  int loadPAT (const char *filename);
  int loadXI  (const char *filename);

  int savePAT (const char *filename);
  int saveXI  (const char *filename);

  char *error_message;

// private:
  Parameters volume;
  Parameters panning;
  Vibe       vibrato;
  uword      NumSamples;
  ubyte      key_note[96];       /* note for each key -- 120 for IT*/
  ubyte      key_samp[96];       /* sample for each key*/
  char       *name;           /* how long ? */
  Sample     **samples;
};
#endif
