// this is gtkmod -- a GTK interface for playing modules
// $Id: gtkmod.cc,v 0.1 1998/06/08 01:23:38 pcburns Exp pcburns $
// $Log: gtkmod.cc,v $
// Revision 0.1  1998/06/08 01:23:38  pcburns
// initial release
extern "C" {
#include <gtk/gtk.h>
}
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <math.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "dsp.h"
#include "sample.h"
#include "module.h"
#include "player.h"

#define RC_FILE "gtkrc"
#define TITLE "GTKMOD"

#define LOAD_ROW 0
#define FILE_ROW 0
#define SONG_ROW 1
#define CHAN_ROW 2
#define GV_ROW   2
#define BPM_ROW  3
#define SPD_ROW  3
#define ORD_ROW  4
#define PAT_ROW  4
#define CTRL_ROW 5

class xplayer : public player
{
public:
  xplayer();

  void callback_order(void);
  void callback_bpm(void);
  void callback_speed(void);  
  void callback_gv(void);
  void callback_end(void);
  //channel callbacks
  //  void callback_ch_volume(int ch);
  //  void callback_ch_note(int ch);
  //  void callback_ch_smp(int ch);
  //  void callback_ch_inst(int ch);  

private:
  char buf_bpm[5];
  char buf_spd[4];
  char buf_ord[9];
  char buf_gv[4];
};


GtkWidget *label_song    = 0;
GtkWidget *label_file    = 0;
GtkWidget *label_bpm     = 0;
GtkWidget *label_speed   = 0;
GtkWidget *label_order   = 0;
GtkWidget *label_pattern = 0;
GtkWidget *label_gv      = 0;
GtkWidget *label_chan    = 0;

GtkWidget *play_button   = 0;
GtkWidget *table         = 0;
GtkWidget *fs            = 0;
Module    *mod           = 0;
xplayer    p;
gchar *file_name          = 0;

int pipe_f[2];
gint ipc_tag;

void input_callback(gpointer, gint source, GdkInputCondition);
void play_callback(GtkWidget *, gpointer *);
void stop(GtkWidget *, gpointer *);
void pause(GtkWidget *, gpointer *);
void file_ok(GtkWidget *, GtkFileSelection *fs);
void load(GtkWidget *, gpointer *);
void delete_event(GtkWidget *, gpointer *);

int main(int argc, char **argv)
{
  GtkWidget *window = 0;
  GtkWidget *button = 0;
  GtkWidget *label  = 0;
  
  gtk_init(&argc, &argv);
  gtk_rc_parse(RC_FILE);

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), TITLE);

  table = gtk_table_new(6,4,TRUE);
  gtk_container_add(GTK_CONTAINER(window),table);

  // set up labels
  label = gtk_label_new("song");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 
			    0,1,SONG_ROW,SONG_ROW+1); 
  gtk_widget_show(label);  

  label = gtk_label_new("bpm");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 
			    0,1,BPM_ROW,BPM_ROW+1);
  gtk_widget_show(label);

  label = gtk_label_new("speed");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 
			    2,3,SPD_ROW,SPD_ROW+1);  
  gtk_widget_show(label);

  label = gtk_label_new("order");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 
			    0,1,ORD_ROW,ORD_ROW+1);  
  gtk_widget_show(label);  

  label = gtk_label_new("pattern");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 
			    2,3,PAT_ROW,PAT_ROW+1);  
  gtk_widget_show(label);  

  label = gtk_label_new("channels");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 
			    0,1, CHAN_ROW,CHAN_ROW+1);  
  gtk_widget_show(label);

  label = gtk_label_new("volume");
  gtk_table_attach_defaults(GTK_TABLE(table), label, 
			    2,3, GV_ROW,GV_ROW+1);  
  gtk_widget_show(label);
  

  // variable labels

  label_song = gtk_label_new("-");
  gtk_table_attach_defaults(GTK_TABLE(table),label_song,
			    1,4,SONG_ROW,SONG_ROW+1);
  gtk_widget_show(label_song);

  label_file = gtk_label_new("-");
  gtk_table_attach_defaults(GTK_TABLE(table), label_file, 
			    1,4,FILE_ROW,FILE_ROW+1);  
  gtk_widget_show(label_file);

  label_bpm = gtk_label_new("125");
  gtk_table_attach_defaults(GTK_TABLE(table), label_bpm, 
			    1,2,BPM_ROW,BPM_ROW+1);  
  gtk_widget_show(label_bpm);

  label_speed = gtk_label_new("6");
  gtk_table_attach_defaults(GTK_TABLE(table), label_speed, 
			    3,4,SPD_ROW,SPD_ROW+1);
  gtk_widget_show(label_speed);

  label_order = gtk_label_new("00/00");
  gtk_table_attach_defaults(GTK_TABLE(table), label_order, 
			    1,2,ORD_ROW,ORD_ROW+1);  
  gtk_widget_show(label_order);

  label_pattern = gtk_label_new("0");
  gtk_table_attach_defaults(GTK_TABLE(table), label_pattern, 
			    3,4,PAT_ROW,PAT_ROW+1);  
  gtk_widget_show(label_pattern);

  label_gv = gtk_label_new("64");
  gtk_table_attach_defaults(GTK_TABLE(table), label_gv, 
			    3,4,GV_ROW,GV_ROW+1);  
  gtk_widget_show(label_gv);

  label_chan = gtk_label_new("");
  gtk_table_attach_defaults(GTK_TABLE(table), label_chan, 
			    1,2,GV_ROW,GV_ROW+1);  
  gtk_widget_show(label_chan);

  // set up buttons
  play_button = gtk_button_new_with_label("play");
  gtk_signal_connect(GTK_OBJECT(play_button), "clicked",
		     GTK_SIGNAL_FUNC(play_callback), NULL);
  gtk_table_attach_defaults(GTK_TABLE(table), play_button, 
			    0,1,CTRL_ROW,CTRL_ROW+1);
  gtk_widget_show(play_button);


  button = gtk_button_new_with_label("pause");
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(pause), NULL);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 
			    1,2,CTRL_ROW,CTRL_ROW+1);
  gtk_widget_show(button);

  button = gtk_button_new_with_label("stop");
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(stop), NULL);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 
			    2,3,CTRL_ROW,CTRL_ROW+1);
  gtk_widget_show(button);
  
  button = gtk_button_new_with_label("load");
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(load), NULL);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 
			    0,1,LOAD_ROW,LOAD_ROW+1);
  gtk_widget_show(button);

  button = gtk_button_new_with_label("quit");
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(delete_event), NULL);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 
			    3,4,CTRL_ROW,CTRL_ROW+1);
  gtk_widget_show(button);

  gtk_signal_connect(GTK_OBJECT(button), "destroy",
		     GTK_SIGNAL_FUNC(delete_event), NULL);

  gtk_widget_show(table);
  gtk_widget_show(window);

  gtk_main();
#ifdef DEBUG
  g_print("gtk_main has quit\n");
#endif
  return 0;
}

void input_callback(gpointer, gint source, GdkInputCondition)
{
  char buffer[80];
  char *b;

  int bytes_read = read(source,buffer,80);
  if (bytes_read)
    {
      gtk_container_disable_resize(GTK_CONTAINER(table));
      if ((b = strstr(buffer, "["))!=0)
	{
	  char *buf = strtok((b+1), ":");
	  char buf2[7];
	  snprintf(buf2, 7,"%s/%.2x", buf, mod->SongLength-1);
	  gtk_label_set(GTK_LABEL(label_order), buf2);
	  gtk_label_set(GTK_LABEL(label_pattern), buf);
	}
      else if ((b = strstr(buffer,"S"))!=0)
	{
	  p.set_speed(atoi(b+1));
	  gtk_label_set(GTK_LABEL(label_speed), (b+1));
	}
      else if ((b = strstr(buffer, "T"))!=0)
	{
	  p.set_bpm(atoi(b+1));
	  gtk_label_set(GTK_LABEL(label_bpm), (b+1));
	}	   
      else if ((b = strstr(buffer, "V"))!=0)
	{
	  gtk_label_set(GTK_LABEL(label_gv), (b+1));
	}
      gtk_container_enable_resize(GTK_CONTAINER(table));
    }
}

void play_callback(GtkWidget *, gpointer *)
{
  if (p.forked_player)
    return;
  
  if (!p.child)
    {
      if (mod)    
	{
	  p.release_mod();
	  p.set_mod(mod);
	  if (p.error)
	    {
	      g_print("player error \n");
	      return;
	    }
	  if (pipe(pipe_f) < 0)
	    {
	      g_print("error opening pipe");
	      return;
	    }	  
	  p.play();
	  // setup monitor for IPC -- make sure it's not called by the child
	  // should be the parent
	  if (!p.forked_player)
	    {
	      close(pipe_f[1]);
	      ipc_tag=gdk_input_add(pipe_f[0],GDK_INPUT_READ,input_callback,0);
	    }
	}
    } 
  else 
    {
      if (p.paused)
	{
	  p.play();
	  p.paused = 0;
	  return;
	}
    }      
}

void stop(GtkWidget *, gpointer *)
{
  if (!p.forked_player)
    p.stop();
}

void pause(GtkWidget *, gpointer *)
{
  if (!p.forked_player)
    p.pause();  
}


// this gets called multiple times by the file selector
// after you press okay or double click 
// -- this unexpected feature made my program segfault until I discovered
// the problem
void file_ok(GtkWidget *, GtkFileSelection *fs)
{  
  if (!p.forked_player)
    {
      gchar *name = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
      if (file_name)
	{
	  if (!strcmp(name,file_name))
	    return;
	  else
	    free(file_name);
	}
      if ((file_name = strdup(name))==0)
	g_print("error in strdup");
      if (!mod->is_module(name))
	{
	  g_print("Not a module");
	  return;
	}
      if (mod)
	{
	  p.stop();
	  close(pipe_f[0]);
	  gdk_input_remove(ipc_tag);
	  p.child = 0;
	  p.release_mod();
	  //      dump_mod(mod);
	}
      else
	{
	  mod = new Module;
	}
      if (!mod->load(name))
	{
	  g_print("%s\n",mod->error_message);
	  mod->dump();
	  mod = 0;
	}
      gtk_widget_hide(GTK_WIDGET(fs)); // hide the file selector
      
      gtk_label_set(GTK_LABEL(label_song), mod->name);
      gtk_label_set(GTK_LABEL(label_file), strrchr(name,'/')+1);

      char buf_chan[3];
      snprintf(buf_chan,3,"%d",mod->channels);
      gtk_label_set(GTK_LABEL(label_chan), buf_chan);
    }
}

void load(GtkWidget *, gpointer *)
{
  if (!fs)
    fs = gtk_file_selection_new("load");

  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fs)->ok_button),
		      "clicked", (GtkSignalFunc)file_ok, fs);

  gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(fs)->cancel_button),
		     "clicked", (GtkSignalFunc) gtk_widget_hide,
			    GTK_OBJECT(fs));
  gtk_widget_show(fs);

}

void delete_event(GtkWidget *, gpointer *)
{
  // make sure the player has finished
  p.stop(); 
  mod->dump();
  gtk_main_quit();
}

// xplayer stuff
xplayer::xplayer()
{
  buf_spd[1] = '6';
  buf_bpm[2] = '5';
  buf_bpm[1] = '2';
  buf_bpm[0] = '1';
}

// need to think a bit more about these callbacks
void xplayer::callback_order(void)
{
  if (!child)
    {
      snprintf(buf_ord,6,"[%2x:%2x",this->order,this->pattern);
      if (pipe_f[1])
	if (write(pipe_f[1],buf_ord,7)<0)
	  perror("speed callback");      
    }
}

void xplayer::callback_bpm(void)
{
  if (forked_player)
    {
      // tell parent process
      snprintf(buf_bpm,5,"T%d",this->bpm);
      if (write(pipe_f[1],buf_bpm,5)<0)
	perror("speed callback");      
    }
}

void xplayer::callback_speed(void)
{
  int error = -1;
  int chances = 0;

  if (forked_player)
    {
      snprintf(buf_spd,4,"S%d",this->speed);
      do {
          error = write(pipe_f[1],buf_spd,4);
          chances++;
          if (chances > 5)
            {
              perror("speed callback");
              break;
            }
          if (error < 0)
            sleep(1);
       } while (error < 0);
    }
}

void xplayer::callback_end(void)
{
  //  _exit(0);
}

void xplayer::callback_gv(void)
{
  if (forked_player)
    {
      snprintf(buf_gv,4,"V%d",this->gv);
      if (write(pipe_f[1],buf_gv,4)<0)
	perror("gv callback");
    }
}
