;
;
; Polygon scan-conversion routines
; Copyright (C) 1997 Andrew Harveym c9607776@engmail.newcastle.edu.au
; Use these for whatever you like, but please credit me (and Chris Hecker
; also deserves credit just as much, I think).
;
; These are based on Chris Hecker's divflfl.cpp.  They started off as a
; direct asm conversion, but I feel I can call them my own by now.
;
; The actual trifillers are in scan_???.asm. scan_PGL.asm means 
; Perspective, Gouraud, Lo-colour(8-bit) texturemapping.  I have routines
; for flat(single colour)/linear/perspective tmapping with flat/gouraud
; shading in lo/high/true colour ,let me know if you're interested.
;
; These should be fairly easy to translate to any flat model environment
;
; I meant to include scan_lgl not scan_lll, so you're stuck with flat
; shaded linear tmapping.  Shouldn't be too hard to add a different (or 
; no) shading type to any of these trifillers
;
; This file, scan.asm, contains some common vars for the trifillers, it
; keeps down the size (I have 18 trifillers in my exe for all possible
; colour depth/detail situations.
;
; The trifillers use floating point extensively, they are very accurate
; but slow on 486/Cyrix and are probably not suited to lots of small
; polys
;
; The floating point makes these very accurate, however the last segnment
; of a perspective scan-line (<16 pixels long) may go fuzzy at the edges
; due to texel coord overflows (I don't think this happens very often).
; Most importantly, the gouraud shading can cause sparks on the edge of
; a very dark polygon.  I think it would be easiest to restrict the light
; values to, say, 4-255 or something in you're lighting model, which should
; be unnoticeable, and should fix the sparks
;
; All of the floating point and inner loop integer is quite (or very) well
; optimised as far as I can see, but of course you could speed it up
; even more.
;
; Clipping is done every scan-line which is not the best way to do it,
; but you would need support for >3 edges if you wanted to improve this
; I suspect.

; You wont be able to assemble these as they are, you need to have some
; public variables.
;
; zed_left/right/top/bottom - float dwords defining the clipping window.
; would be 0.0, 0.0, 320.0, 200.0 for a 320x200 screen (note 320.0 not 319.0)
;
; scan_dest - near pointer to linear framebuffer in RAM or on video card.
;
; mode_x - framebuffer width in pixels
; mode_bx - framebuffer width in bytes
; mode_y - framebuffer height in pixels
;
; light_ptr - near pointer to a lighting table (the same format as produce by
; reduce).  This is a 64k array of bytes with :
;   lit_colour = light_ptr[unlit_colour][intensity]
; You should align this on a 64k boundary :
;   aligned_address = (address + 65535) and not 65535
;
; tex_ptr - near pointer to 256x256 texture map.  Doesn't need any alignment
; but if it was 64k aligned you could optimise the inner loops.
;
; scan_pts - near pointer to vertices of polygons. Each vertex is in the form:
; float dword x, float dword y, float dword 1/z,
; float dword Intensity 0.0 to 255.0 shl 16
; so they are 16 bytes long.
;
; scr_muls - a label in front of a table of dwords where :
;   scr_muls[i] = mode_bx * i
;
; This is the polygon struc.  Call scan_pgl with esi pointing to one of
; these.  Change the structure if you want, but make sure you keep connect?
; and u/v? in the same format
; Points must be anticlockwise! Its not hard to change this (xchg connect1, connect3)

if 0
struc   polygon
connect1        dd ?    ;point and smooth normal ptrs (0, 16, 32, 48...)
connect2        dd ?
connect3        dd ?    
u1              dd ?    ;texel coords.  float, 0.0 to 255.0 shl 16
u2              dd ?
u3              dd ?
v1              dd ?
v2              dd ?
v3              dd ?    
normal          dd ?    ;plane equation ptr (0, 16, 32, 48...)
shade           dd ?    ;type of shading
texture         dd ?    ;texture map or colour
flags           dd ?    ;flags&2 is whether poly selected
ends
endif

;

p486
p487
ideal
locals
largestack

;

o equ offset
b equ byte
w equ word
d equ dword
s equ short
n equ near
f equ far

;

segment code32 page public use32
        assume cs:code32, ds:code32

include "\code\omn\include\macros.inc"  ;You'll have to supply you own
include "\code\omn\pmode\pmode.inc"     ;versions of these to assemble
include "\code\omn\video\video.inc"     ;this file.
include "\code\omn\include\strucs.inc"  ;You'll also have to choose
include "\code\omn\fmath\fmath.inc"     ;appropriate directories.

include "\code\omn\scan\scan.inc"

;

align 4
scan_dest       dd ?
scan_pts        dd ?
scan_proc       dd ?

scanline_buffer db 1280 dup ( ? )

YEnd            dd ?
XPrestep        dd ?
YPrestep        dd ?

OneOverdX       dd ?
OneOverdY       dd ?

X               dd ?, ?, ?
Y               dd ?, ?, ?
OneOverZ        dd ?, ?, ?
UOverZ:
U               dd ?, ?, ?
VOverZ:
V               dd ?, ?, ?
Intens          dd ?, ?, ?

dOneOverZdX     dd ?
dOneOverZdX16   dd ?
dUOverZdX16     dd ?
dVOverZdX16     dd ?
dUOverZdX:
dUdX            dd ?
dVOverZdX:
dVdX            dd ?
dIdX            dd ?
dUdX_int        dd ?
dVdX_int        dd ?
dIdX_int        dd ?
dOneOverZdY     dd ?
dUOverZdY:
dUdY            dd ?
dVOverZdY:
dVdY            dd ?
dIdY            dd ?

scan_third      dd 0.333333333333333333333333333333333333333333333333
scan_half       dd 0.5
scan_16         dd 16.0

Ax_Cx           dd ?
Bx_Cx           dd ?
Ay_Cy           dd ?
By_Cy           dd ?
Az_Cz           dd ?
Bz_Cz           dd ?
Au_Cu           dd ?
Bu_Cu           dd ?
Av_Cv           dd ?
Bv_Cv           dd ?
Ai_Ci           dd ?
Bi_Ci           dd ?

YPrestepL1      dd ?    ;for clipping
YPrestepR1      dd ?    ;for clipping
YPrestepL2      dd ?    ;for clipping
YPrestepR2      dd ?    ;for clipping

TopSkip         dd ?
BottomSkip      dd ?
Count1          dd ?
Count2          dd ?
leftismiddle    db ?

;

ends    code32

;
;

end
