////////////////////////////////////////////////////////////////////////////
//									  //
//  A gouraud filler, coded by Cazz - hope it's the right way to do it,   //
//				      but it works... somehow.		  //
//									  //
////////////////////////////////////////////////////////////////////////////
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "data.h"

long	normals[nump][3];
long	fnormal[numf][3];
long	lpos[3];
long	light[3];
char	coltab[nump];

const	double PI = 3.1415926545897932385;
char	*screen;

long	leftx[200];
long	rightx[200];
char	leftc[200];
char	rightc[200];
long	yrows[200];
long	sinus[256];
long	cosinus[256];

unsigned char angleX;
unsigned char angleY;
unsigned char angleZ;
unsigned char angleL;

long	distance = 512;

long	i;
long	vis;

///////////////////////////   INIT STUFF   ///////////////////////////////
void center(){
    float xc,yc,zc;
    xc = yc = zc = 0;
    for(i=0;i<nump;i++){
	xc += points[i][0];
	yc += points[i][1];
	zc += points[i][2];
    }
    xc = xc / nump;
    yc = yc / nump;
    zc = zc / nump;
    for(i=0;i<nump;i++){
	points[i][0] -=	xc;
	points[i][1] -=	yc;
	points[i][2] -=	zc;
    }

}

void inittrig(){
    for(i=0;i<200;i++) yrows[i]	= i*320;
    for(i=0;i<256;i++){
	sinus[i] = (long)(sin(i*PI/128)*256);
	cosinus[i] = (long)(cos(i*PI/128)*256);
    }
}

void calcnormals(){

    long a,ax,ay,az,bx,by,bz,kx,ky,kz,num;
    float length;
    // CALC FACE NORMALS //
    for(i=0;i<numf;i++){
	ax = points[faces[i][1]][0] - points[faces[i][0]][0];
	ay = points[faces[i][1]][1] - points[faces[i][0]][1];
	az = points[faces[i][1]][2] - points[faces[i][0]][2];
	bx = points[faces[i][2]][0] - points[faces[i][0]][0];
	by = points[faces[i][2]][1] - points[faces[i][0]][1];
	bz = points[faces[i][2]][2] - points[faces[i][0]][2];
	kx = (ay*bz) - (az*by);
	ky = (az*bx) - (ax*bz);
	kz = (ax*by) - (ay*bx);
	if((length = sqrt(kx*kx	+ ky*ky	+ kz*kz))>0){
	    fnormal[i][0] = ((kx / length)*256);
	    fnormal[i][1] = ((ky / length)*256);
	    fnormal[i][2] = ((kz / length)*256);
	}
    }

    // CALC NORMALS //
    for(i=0;i<nump;i++){
	ax = ay	= az = num = 0;
	for(a=0;a<numf;a++){
	    if(faces[a][0] == i){
		ax += fnormal[a][0];
		ay += fnormal[a][1];
		az += fnormal[a][2];
		num++;
	    }
	    if(faces[a][1] == i){
		ax += fnormal[a][0];
		ay += fnormal[a][1];
		az += fnormal[a][2];
		num++;
	    }
	    if(faces[a][2] == i){
		ax += fnormal[a][0];
		ay += fnormal[a][1];
		az += fnormal[a][2];
		num++;
	    }
	}
	if(num>0){
	    normals[i][0] = ax / num;
	    normals[i][1] = ay / num;
	    normals[i][2] = az / num;
	}
    }
}

void initlight(long l1,long l2,long l3){

    lpos[0] = l1;
    lpos[1] = l2;
    lpos[2] = l3;
    float len =	sqrt(lpos[0]*lpos[0] + lpos[1]*lpos[1] + lpos[2]*lpos[2]);
    light[0] = ((lpos[0]/len)*256);
    light[1] = ((lpos[1]/len)*256);
    light[2] = ((lpos[2]/len)*256);
}

////////////////////////   GOURAUD FILLER CODE	 ///////////////////////////
int leftline(long x1,long y1,char c1,long x2,long y2,char c2){

    if ( y1==y2	|| y1>199 || y2<0) return 1;	// no scanline

    long y22 = (y2 - y1	+ 1);		// height
    long xd = (((x2 - x1) << 8)	/ y22);	// delta x (8-bit fractional)
    long x = (x1 << 8);			// current x
    long cd = (((c2 - c1) << 8)	/ y22);	// same	as
    long c = (c1 << 8);			//   above

    if (y2>199){ y2 = 199; }		// clipping
    if (y1<0){
	x = x +	xd*(-y1);
	c = c +	cd*(-y1);
	y1 = 0;
    }

    y22	= (y2 -	y1 + 1);		// height after	clipping
		// clipping is not bugfree:
		//   when x-coord is out of screen, I store a bit wrong
		//   color value. When I clip x-value, I must also update
		//   color value, but it would make this code slower and
		//   more difficult to follow... and I'm a bit tired right
		//   now (my school just started and I'm not used to wake
		//   at	8 in the morning)
    _asm{
	mov edi,y1
	mov esi,edi
	shl edi,2
	mov edx,x			// edx holds current x
	mov ebx,c			// ebx holds current color
	add edi,offset leftx		// x-buffer
	add esi,offset leftc		// color-buffer
	mov ecx,y22
@loop:
	mov eax,edx
	add edx,xd			// update x
	sar eax,8

	cmp eax,319			// so so clipping
	jle @chk0
	mov eax,319
	jmp @nope
@chk0:
	cmp eax,0
	jge @nope
	xor eax,eax
@nope:
	mov [edi],eax
	add edi,4

	mov eax,ebx
	add ebx,cd			// update color
	mov [esi],ah
	inc esi
	dec ecx
	jnz @loop
    }
    return 0;
}

// the very same function as leftline, only buffers to store values
// are different
int rightline(long x1,long y1,char c1,long x2,long y2,char c2){

    if ( y1==y2	|| y1>199 || y2<0) return 1;

    long y22 = (y2 - y1	+ 1);
    long xd = (((x2 - x1) << 8)	/ y22);
    long x = (x1 << 8);
    long cd = (((c2 - c1) << 8)	/ y22);
    long c = (c1 << 8);

    if (y2>199){ y2 = 199; }
    if (y1<0){
	x = x +	xd*(-y1);
	c = c +	cd*(-y1);
	y1 = 0;
    }
    y22	= (y2 -	y1 + 1);
    _asm{
	mov edi,y1
	mov esi,edi
	shl edi,2
	mov edx,x
	mov ebx,c
	add edi,offset rightx
	add esi,offset rightc
	mov ecx,y22
@loop:
	mov eax,edx
	add edx,xd
	sar eax,8

	cmp eax,319
	jle @chk0
	mov eax,319
	jmp @nope
@chk0:
	cmp eax,0
	jge @nope
	xor eax,eax
@nope:
	mov [edi],eax
	add edi,4

	mov eax,ebx
	add ebx,cd
	mov [esi],ah
	inc esi
	dec ecx
	jnz @loop
    }
    return 0;
}

void shaded(long x1,long x2,long y,char	c1,char	c2){

    _asm{
	mov eax,x1
	mov ebx,x2
	mov ecx,ebx
	sub ecx,eax
	jz @off
	mov edi,y
	shl edi,2
	add edi,offset yrows
	add eax,[edi]
	mov edi,eax
	add edi,screen
	xor al,al
	mov ah,c2
	sub ah,c1
	cwde
	cdq
	idiv ecx
	mov edx,eax
	xor ebx,ebx
	mov bh,c1
	shr ecx,1
	jnc @inner		// It's possible to make this inner loop
	mov [edi],bh		// faster: check if edi	is an even number
	inc edi			//	1) yes,	continue storing words...
	add ebx,edx		//	2) nope, store one byte	then start
	and ecx,ecx		//	   storing words and in	the end
	jz @off			//	   store one more byte.	You must
@inner:				//	   notice that you don't fill a longer
	mov al,bh		//	   line	as needed. *important*
	add ebx,edx		// All this is because storing word to odd
	mov ah,bh		// address is as slow as storing two bytes.
	add ebx,edx		// It will make	this proc quite	complicated,
	mov [edi],ax		// but I hope it's worth it. Actually I
	add edi,2		// haven't done it in gouraud filler, but in
	dec ecx			// flat	polyfiller it made my code faster.
	jnz @inner
@off:
    }
}

void poly(long x1,long y1,char c1,long x2,long y2,char c2,long x3,long y3,char c3){

    long tempswap;
    char swp;

    if (y1 > y2){
	tempswap = x1; x1 = x2;	x2 = tempswap;
	tempswap = y1; y1 = y2;	y2 = tempswap;
	swp = c1; c1 = c2; c2 =	swp;
    };
    if	(y3 < y1){
	tempswap = x3; x3 = x2;	x2 = x1; x1 = tempswap;
	tempswap = y3; y3 = y2;	y2 = y1; y1 = tempswap;
	swp = c3; c3 = c2; c2 =	c1; c1 = swp;
    };
    if (y3 < y2) {
	tempswap = x2; x2 = x3;	x3 = tempswap;
	tempswap = y2; y2 = y3;	y3 = tempswap;
	swp = c2; c2 = c3; c3 =	swp;
    };
    if(	y1>199 || y3<0)return;

    leftline(x1,y1,c1,x3,y3,c3);
    rightline(x1,y1,c1,x2,y2,c2);
    rightline(x2,y2,c2,x3,y3,c3);

    if(y1<0){y1	= 0;}
    if(y3>199){y3 = 199;}
    for(tempswap=y1;tempswap<=y3;tempswap++){
	if (leftx[tempswap]<rightx[tempswap]){
	    shaded(leftx[tempswap],rightx[tempswap],tempswap,
		leftc[tempswap],rightc[tempswap]);
	}else{
	    shaded(rightx[tempswap],leftx[tempswap],tempswap,
		rightc[tempswap],leftc[tempswap]);
	}
    }
}

////////////////////////   ROTATING EVERYTHING	 ///////////////////////////

void rotateall(){

    long px,py,pz,a,i,j,k,z,dp;
    long sinx =	sinus[angleX];
    long siny =	sinus[angleY];
    long sinz =	sinus[angleZ];
    long cosx =	cosinus[angleX];
    long cosy =	cosinus[angleY];
    long cosz =	cosinus[angleZ];

    for(a=0;a<nump;a++){
/////////////////  ROTATE POINTS  ////////////////////
// Maybe not the very right way	to do 3d-rotate, but who cares...
	px = points[a][0];
	py = points[a][1];
	pz = points[a][2];
	i = (cosy*px - siny*pz)	>> 8;
	k = (cosy*pz + siny*px)	>> 8;
	j = (cosz*py - sinz*i) >> 8;
	z = (cosx*k - sinx*j) >> 8;
	z = z -	distance;
	if (z >	-8){z =	-8;}
	outpnt[a][0] = 160 + ((cosz*i +	sinz*py) / z);
	outpnt[a][1] = 100 + ((cosx*j +	sinx*k)	/ z);
	outpnt[a][2] = z + distance;

/////////////////  ROTATE NORMALS  ////////////////////
	px = normals[a][0];
	py = normals[a][1];
	pz = normals[a][2];
	i = (cosy*px - siny*pz)	>> 8;
	k = (cosy*pz + siny*px)	>> 8;
	j = (cosz*py - sinz*i) >> 8;
	z = (cosx*k - sinx*j) >> 8;	// Z-normal
	i = (cosz*i + sinz*py) >> 8;	// X-normal
	j = (cosx*j + sinx*k) >> 8;	// Y-normal

/////////////////  CALCULATE GOURAUD COLORS  ////////////////////
	dp = ((i*light[0]) + (j*light[1]) + (z*light[2])) >> 9;
	if (dp>=128){coltab[a] = 0;
	}else{
	    if (dp<=-127){coltab[a] = 255;
	    }else{coltab[a] = 128 - dp;}
	}

    }
}

void qsort(long	l,long r){

    long tempswap;
    long i = l;
    long j = r;
    long x = zzz[(l+r) / 2];
    do{
	if (zzz[i]>x)do{ i++; }while(zzz[i]>x);
	if (x>zzz[j])do{ j--; }while(x>zzz[j]);
	if (i<=j){
	    tempswap = zzz[i];
	    zzz[i] = zzz[j];
	    zzz[j] = tempswap;
	    tempswap = pind[i];
	    pind[i] = pind[j];
	    pind[j] = tempswap;
	    i++;
	    j--;
	}
    }while(j>=i);
    if (l<j)qsort(l,j);
    if (i<r)qsort(i,r);
}

void main(){

////////////  INIT  ///////////////
    center();
    inittrig();
    calcnormals();

    screen = (char *)malloc(65536);
    _asm{
	mov	eax,0x13
	int	10h
    }

    for(i=0;i<256;i++){
	outp(0x3c8,i);
	outp(0x3c9,i / 8);
	outp(0x3c9,i / 4);
	outp(0x3c9,0);
    }

    angleX = 64;
    initlight(-200,0,0);
    do{
//	initlight(sinus[angleL]	/ 8,0,cosinus[angleL] /	8);
	rotateall();
	vis = 0;
	for(i=0;i<numf;i++){
	    if (((outpnt[faces[i][2]][0]-outpnt[faces[i][0]][0])*
		 (outpnt[faces[i][1]][1]-outpnt[faces[i][0]][1])-
		 (outpnt[faces[i][1]][0]-outpnt[faces[i][0]][0])*
		 (outpnt[faces[i][2]][1]-outpnt[faces[i][0]][1]))<0){
		zzz[vis] = outpnt[faces[i][0]][2]+
			   outpnt[faces[i][1]][2]+
			   outpnt[faces[i][2]][2];
		pind[vis] = i;
		vis++;
	    }
	}
	if (vis	!= 0){
	    vis--;

	    qsort(0,vis);

	    _asm{
		mov	edi,screen
		xor	eax,eax
		mov	ecx,16000
		cld
		rep	stosd
	    }
	    for(i=vis;i>=0;i--){
		poly(outpnt[faces[pind[i]][0]][0],outpnt[faces[pind[i]][0]][1],
		     coltab[faces[pind[i]][0]],
		     outpnt[faces[pind[i]][1]][0],outpnt[faces[pind[i]][1]][1],
		     coltab[faces[pind[i]][1]],
		     outpnt[faces[pind[i]][2]][0],outpnt[faces[pind[i]][2]][1],
		     coltab[faces[pind[i]][2]]);
	    }
	    _asm{
		mov	esi,screen
		mov	edi,0xA0000
		mov	ecx,16000
		cld
		rep	movsd
	    }
	}

/*	outp(0x3C0,0x31);
	outp(0x3C0,0);
	_asm{
	    mov	dx,3dah
@v1:
	    in al,dx
	    test al,8
	    jz @v1
@v2:
	    in al,dx
	    test al,8
	    jnz	@v2
	}
	outp(0x3C0,0x31);
	outp(0x3C0,200);	*/
//	angleX++;
//	angleY++;
	angleZ++;
//	angleL++;
//	distance = 512 + sinus[angleZ];
    }while (!kbhit());

    _asm{
	mov	eax,0x03
	int	10h
    };
}
