(*

                     Inertia Realtime 3D Rendering Engine
     Copyright (c) 1996, Alex Chalfin, Jeroen Bouwens. All Rights Reserved.

*)
Program Example07;
{ Inertia 3d system example. This example program demonstrates object }
{ replication and basic camera movements.                             }
{ Alex Chalfin   12/29/96 }
{ achalfin@uceng.uc.edu   }
{$N+}

Uses
  Types,    { Inertia type declarations     }
  Inertia,  { the 3d engine                 }
  Mode13h,  { Basic Mode 13h graphics unit  }
  Crt;

Const
  TextureData : String = 'Nice';
  CUBESPACE   = 800;

Var
  View : ViewObject;   { The View System }
  Cube : VectorObject;
  OldTime : Longint;

Procedure Initialize;

Var
  i : Integer;

Begin
  If (LoadPalette(TextureData + '.PAL', 0) <> I_OK)       { load the texture }
    Then Begin
      Writeln('Error loading Palette.');
      Halt(0);
    End;
  If (LoadIntensityTable(TextureData + '.IT', 0) <> I_OK) { load intensity table }
    Then Begin
      Writeln('Error loading intensity table.');
      Halt(0);
    End;

  If (LoadGVO(Cube, 'Cube.GVO', 0) <> I_OK)         { load the vector object }
    Then Begin
      Writeln('Error loading CUBE object.');
      Halt(0);
    End;
  i := Cube.Num_Polygons * 8 * 8 * 8;
  If (InitView(View, i) <> I_OK) { init the view }
    Then Begin
      Writeln('Error Initializing view.');
      Halt(0);
    End;

  SetSurface(Cube, SMOOTH);   { set smooth surface for lights}
  SetShading(Cube, GOURAUD);   { set ambient rendering for lights }
  SetbaseColor(Cube, 1);
  SetMinZ(Cube, 300);
End;

Var
  i, j, k : Integer;
  u, v, lx, ly, lz, tx, ty, tz : Real;
  cx, cy, cz : Longint;

Begin
  Initialize;

  SetMode($13);                    { Set graphics mode }
  SetPalette(GlobalPalette);       { Set the palette }
  PushLightSource(View, 0, 0, -1); { Push an arbitrary light source }

  u := 0;
  v := 1.00;
  OldTime := MemL[Seg0040:$6c];
  Repeat
    lx := sin(2*u)*5500;  { camera location }
    ly := sin(u*2)*5500;
    lz := sin(u)*5500;

    tx := sin(2*v)*5500;  { camera target }
    ty := sin(v*2)*5500;
    tz := sin(v)*5500;

    { allow the cube grid to follow the camera around }
    cx := (Round(lx) Div CUBESPACE) * CUBESPACE;
    cy := (Round(ly) Div CUBESPACE) * CUBESPACE;
    cz := (Round(lz) Div CUBESPACE) * CUBESPACE;

    if (OldTime <> MemL[Seg0040:$6c])
      Then Begin
        OldTime := MemL[Seg0040:$6c];
        u := u + 0.02;
        v := v + 0.02;
      End;

    SetViewLocation(View, Round(lx), Round(ly), Round(lz));
    SetFocusPoint(View, Round(tx), Round(ty), Round(tz), 0);

    PopLightSource(View);  { remove light source }

    { add a new light source in the direction we are now facing }
    PushLightSource(View, -(tx-lx), -(ty-ly), -(tz-lz));

    { Add in the Cube grid }
    For i := 0 to 11 do
      For j := 0 to 11 do
        For k := 0 to 11 do
          Begin
            SetAbsoluteLocation(Cube, cx + (i - 6)*CUBESPACE, cy + (j - 6)*CUBESPACE, cz + (k - 6)*CUBESPACE);
            AddtoRenderList(View, Cube);
          End;

    Render(View, VirtualPage);

    While ((Port[$3da] And 8) = 0) do;
    Flip;

  Until KeyPressed;
  While (KeyPressed) do ReadKey;

  FreeView(View);          { Free the view's allocated memory }
  FreeIntensityTable;
  FreeVectorObject(Cube);

  SetMode($03);           { return to text mode }
  Writeln(View.FramesPerSecond:5:2);
End.